package com.ejianc.business.material.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 采购订单子表
 *
 * @author generator
 *
 */
public class PurchaseOrderDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long pid; // 主表id
    private Long materialTypeId; // 物资分类id
    private String materialTypeName; // 物资分类名称
    private Long materialId; // 物资id
    private String materialName; // 物资名称
    private String model; // 规格型号
    private String unit; // 计量单位
    private Long supplierId; // 供应商品牌id
    private String supplierName; // 品牌
    private BigDecimal orderNum; // 订货量
    private BigDecimal price; // 单价
    private String memo; // 备注
    private Integer sourceType; // 物资来源类型：1-物资档案，2-用料申请，3-合同清单，4-导入
    private Long sourceId; // 物资来源单据Id
    private BigDecimal taxMny; // 金额


    //唯一的key需要使用方自己构建
    public String onlyKey;
    //匹配状态
    public String matchStatus;
    //匹配数量
    public String matchNumber;
    //描述
    public String matchStatusDescription;

    /**
     * 导入失败原因
     */
    private String errorMessage;

    private BigDecimal surplusNum; // 剩余数量\参照用


    /**
     * 物资编码
     */
    private String materialCode;

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public BigDecimal getSurplusNum() {
        return surplusNum;
    }

    public void setSurplusNum(BigDecimal surplusNum) {
        this.surplusNum = surplusNum;
    }

    public String getOnlyKey() {
        return onlyKey;
    }

    public void setOnlyKey(String onlyKey) {
        this.onlyKey = onlyKey;
    }

    public String getMatchStatus() {
        return matchStatus;
    }

    public void setMatchStatus(String matchStatus) {
        this.matchStatus = matchStatus;
    }

    public String getMatchNumber() {
        return matchNumber;
    }

    public void setMatchNumber(String matchNumber) {
        this.matchNumber = matchNumber;
    }

    public String getMatchStatusDescription() {
        return matchStatusDescription;
    }

    public void setMatchStatusDescription(String matchStatusDescription) {
        this.matchStatusDescription = matchStatusDescription;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(BigDecimal orderNum) {
        this.orderNum = orderNum;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

}
