package com.ejianc.business.material.api;

import com.ejianc.business.material.hystrix.MaterialPickRegisterHystrix;
import com.ejianc.business.material.vo.PickRegisterDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * 领料登记rpc服务
 */
@FeignClient(name= "ejc-material-web", url="${common.env.feign-client-url}", path="ejc-material-web", fallback = MaterialPickRegisterHystrix.class)
public interface IMaterialPickRegisterApi {

	/**
	 * 更新领料登记主子表扣款金额
	 * @param vos
	 * @return
	 */
	@RequestMapping(value = "/api/pickRegister/updateDeductMny", method=RequestMethod.POST)
	CommonResponse<String> updateDeductMny(@RequestBody List<PickRegisterDetailVO> vos);

	
}
