package com.ejianc.business.plan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标段计划
 *
 * @author generator
 *
 */
public class SectionPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long projectId; // 所属项目Id
    private String projectName; // 所属项目名称
    private String planCode; // 计划编码
    private BigDecimal totalPlanAmt; // 总计划金额
    private String remark; // 备注
    private Long orgId; // 所属项目部Id
    private String orgName; // 所属项目部名称
    private Integer changeState; // 变更状态
    private Integer billState; // 单据状态
    private Long curChangingPlanId; // 当前对应的变更计划Id
    private String createUserName; // 创建人名称
    private String modifyUserName; // 修改人名称
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate; // 生效日期
    private Integer changeVersion; // 变更版本
    private Long sectionId; // 标段
    private String sectionName; // 标段名称

    private List<SectionPlanSubVO> materialSubList = new ArrayList<>(); // 标段计划明细

    /**
     * 变更历史列表
     */
    private List<SectionPlanChangeHisVO> planChangeHisList;

    public List<SectionPlanChangeHisVO> getPlanChangeHisList() {
        return planChangeHisList;
    }

    public void setPlanChangeHisList(List<SectionPlanChangeHisVO> planChangeHisList) {
        this.planChangeHisList = planChangeHisList;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public BigDecimal getTotalPlanAmt() {
        return totalPlanAmt;
    }

    public void setTotalPlanAmt(BigDecimal totalPlanAmt) {
        this.totalPlanAmt = totalPlanAmt;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getCurChangingPlanId() {
        return curChangingPlanId;
    }

    public void setCurChangingPlanId(Long curChangingPlanId) {
        this.curChangingPlanId = curChangingPlanId;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    @ReferSerialTransfer(referCode = "section-doc")
    public Long getSectionId() {
        return sectionId;
    }

    @ReferDeserialTransfer
    public void setSectionId(Long sectionId) {
        this.sectionId = sectionId;
    }

    public String getSectionName() {
        return sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public List<SectionPlanSubVO> getMaterialSubList() {
        return materialSubList;
    }

    public void setMaterialSubList(List<SectionPlanSubVO> materialSubList) {
        this.materialSubList = materialSubList;
    }
}
