package com.ejianc.foundation.material.api;

import com.ejianc.foundation.material.hystrix.StoreBalanceHystrix;
import com.ejianc.foundation.material.vo.StoreBalanceDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 物资结存rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-material-web", url="${common.env.feign-client-url}", path="ejc-material-web", fallback = StoreBalanceHystrix.class)
public interface IStoreBalanceApi {

	/**
	 * 根据合同id查询物资结存-该月消耗
	 *
	 * @param projectId
	 * @param month
	 * @param materialCategoryCode 物资分类code
	 * @return
	 */
	@GetMapping("/api/storeBalance/queryOutStore")
	CommonResponse<StoreBalanceDetailVO> queryOutStore(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "month") String month, @RequestParam(value = "materialCategoryCode") String materialCategoryCode);

}
