/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.service.IReportService;
import com.ejianc.business.material.vo.BuyPriceDetailVO;
import com.ejianc.business.material.vo.BuyPriceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/"})
public class ReportController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IReportService reportService;
    @Autowired
    IProjectApi projectApi;
    @Autowired
    ISupplierApi supplierApi;
    @Autowired
    IMaterialApi materialApi;
    @Autowired
    IOrgApi orgApi;
    private static final Integer BATCH_SIZE = 1000;
    private static final Integer QUERY_TIMEOUT = 60;
    private static final String INDEX_NAME_DETAIL = "ejc_material_report_buy_price_detail";
    private static final String INDEX_NAME = "ejc_material_report_buy_price";
    private static final String INDEX_NAME_MATERIAL_CATEGORY = "ejc_material_report_material_category";
    @Autowired(required=false)
    private RestHighLevelClient client;

    @RequestMapping(path={"/inites"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> initEs() {
        try {
            XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject(INDEX_NAME_DETAIL).startObject("properties");
            mapping.startObject("billCode").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("contractName").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("contractId").field("type", "text").endObject();
            mapping.startObject("supplierName").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("supplierId").field("type", "text").endObject();
            mapping.startObject("orgName").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("orgId").field("type", "text").endObject();
            mapping.startObject("settlementDate").field("type", "date").field("format", "yyyy-MM-dd").endObject();
            mapping.startObject("contractPrice").field("type", "long").endObject();
            mapping.startObject("pId").field("type", "text").endObject();
            mapping.startObject("materialTypeName").field("type", "text").endObject();
            mapping.startObject("materialTypeId").field("type", "text").endObject();
            mapping.startObject("materialName").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("materialId").field("type", "text").endObject();
            mapping.startObject("model").field("type", "text").endObject();
            mapping.startObject("unit").field("type", "text").endObject();
            mapping.startObject("num").field("type", "long").endObject();
            mapping.startObject("price").field("type", "long").endObject();
            mapping.startObject("money").field("type", "long").endObject();
            mapping.startObject("taxRate").field("type", "long").endObject();
            mapping.startObject("province").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("city").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("region").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("projectId").field("type", "text").endObject();
            mapping.startObject("area").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("tenantId").field("type", "text").endObject();
            mapping.endObject().endObject().endObject();
            PutMappingRequest mappingRequest = Requests.putMappingRequest((String[])new String[]{INDEX_NAME_DETAIL}).type(INDEX_NAME_DETAIL).source(mapping);
            this.client.indices().putMapping(mappingRequest, RequestOptions.DEFAULT);
            return CommonResponse.success();
        }
        catch (IOException e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    @RequestMapping(path={"/init"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> init() {
        try {
            XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject(INDEX_NAME).startObject("properties");
            mapping.startObject("tenantId").field("type", "text").endObject();
            mapping.startObject("materialTypeName").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("materialTypeId").field("type", "text").endObject();
            mapping.startObject("materialCode").field("type", "text").endObject();
            mapping.startObject("materialName").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("materialId").field("type", "text").endObject();
            mapping.startObject("model").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("unit").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("totalNum").field("type", "long").endObject();
            mapping.startObject("totalMoney").field("type", "long").endObject();
            mapping.startObject("minContractPrice").field("type", "long").endObject();
            mapping.startObject("maxContractPrice").field("type", "long").endObject();
            mapping.startObject("avgPrice").field("type", "long").endObject();
            mapping.startObject("minPriceArea").field("type", "long").endObject();
            mapping.startObject("maxPriceArea").field("type", "long").endObject();
            mapping.startObject("buyPrice").field("type", "long").endObject();
            mapping.startObject("settlementDate").field("type", "date").field("format", "yyyy-MM-dd").endObject();
            mapping.endObject().endObject().endObject();
            PutMappingRequest mappingRequest = Requests.putMappingRequest((String[])new String[]{INDEX_NAME}).type(INDEX_NAME).source(mapping);
            this.client.indices().putMapping(mappingRequest, RequestOptions.DEFAULT);
            return CommonResponse.success();
        }
        catch (IOException e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    @RequestMapping(path={"/initCat"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> initCat() {
        try {
            XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject(INDEX_NAME_MATERIAL_CATEGORY).startObject("properties");
            mapping.startObject("tenantId").field("type", "text").endObject();
            mapping.startObject("id").field("type", "text").endObject();
            mapping.startObject("parentId").field("type", "text").endObject();
            mapping.startObject("code").field("type", "text").field("fielddata", true).endObject();
            mapping.startObject("name").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("innerCode").field("type", "text").endObject();
            mapping.startObject("enabled").field("type", "text").endObject();
            mapping.startObject("isLeaf").field("type", "text").endObject();
            mapping.endObject().endObject().endObject();
            PutMappingRequest mappingRequest = Requests.putMappingRequest((String[])new String[]{INDEX_NAME_MATERIAL_CATEGORY}).type(INDEX_NAME_MATERIAL_CATEGORY).source(mapping);
            this.client.indices().putMapping(mappingRequest, RequestOptions.DEFAULT);
            return CommonResponse.success();
        }
        catch (IOException e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    @RequestMapping(path={"/isViewSettle"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> isViewSettle(Long orgId) {
        List orgVOS;
        CommonResponse projectOrgsByUserId;
        if (null != orgId && null != (projectOrgsByUserId = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid())) && CollectionUtil.isNotEmpty((Collection)((Collection)projectOrgsByUserId.getData())) && CollectionUtil.isNotEmpty((Collection)(orgVOS = (List)projectOrgsByUserId.getData()))) {
            for (OrgVO vo : orgVOS) {
                if (!orgId.equals(vo.getId())) continue;
                return CommonResponse.success((String)"\u8be5\u7528\u6237\u6709\u6743\u9650\u67e5\u770b\u6b21\u7ed3\u7b97\u5355!");
            }
        }
        return CommonResponse.error((String)"\u8be5\u7528\u6237\u6ca1\u6709\u6b64\u7ed3\u7b97\u5355\u6240\u5c5e\u7ec4\u7ec7\u6743\u9650,\u65e0\u6cd5\u67e5\u770b!");
    }

    @RequestMapping(value={"/queryCategory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialCategoryVO>> queryCategory(Long id, Long zid, Long tid) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (id != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"parentId", (Object)id));
        }
        if (zid != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"id", (Object)zid));
        }
        if (tid != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)tid.toString()));
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME_MATERIAL_CATEGORY});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.sort("code", SortOrder.ASC);
        sourceBuilder.size(500);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        ArrayList<Object> list = new ArrayList<Object>();
        SearchResponse response = null;
        try {
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, MaterialCategoryVO.class));
            }
        }
        catch (IOException e) {
            try {
                response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                for (SearchHit hit : hits) {
                    String sourceAsString = hit.getSourceAsString();
                    list.add(JSON.parseObject((String)sourceAsString, MaterialCategoryVO.class));
                }
            }
            catch (IOException e1) {
                this.logger.error(e1.getMessage());
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/lazyMaterialCategory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialCategoryVO>> lazyMaterialCategory(Long id) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (id != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"parentId", (Object)id));
        } else {
            boolQuery.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"parentId"));
        }
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME_MATERIAL_CATEGORY});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.sort("code", SortOrder.ASC);
        sourceBuilder.size(500);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        ArrayList<Object> list = new ArrayList<Object>();
        SearchResponse response = null;
        try {
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, MaterialCategoryVO.class));
            }
        }
        catch (IOException e) {
            try {
                response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                for (SearchHit hit : hits) {
                    String sourceAsString = hit.getSourceAsString();
                    list.add(JSON.parseObject((String)sourceAsString, MaterialCategoryVO.class));
                }
            }
            catch (IOException e1) {
                this.logger.error(e1.getMessage());
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", list);
    }

    private List<MaterialCategoryVO> queryAllMaterialCategoryChildren(String materialTypeId) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"innerCode", (String)materialTypeId));
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME_MATERIAL_CATEGORY});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.sort("code", SortOrder.ASC);
        sourceBuilder.size(500);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        ArrayList<MaterialCategoryVO> list = new ArrayList<MaterialCategoryVO>();
        SearchResponse response = null;
        try {
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            String sourceAsString = hit.getSourceAsString();
            list.add((MaterialCategoryVO)JSON.parseObject((String)sourceAsString, MaterialCategoryVO.class));
        }
        return list;
    }

    @RequestMapping(value={"/queryBuyPrice"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BuyPriceVO>> queryBuyPrice(@RequestBody QueryParam param) {
        String materialTypeId = this.getParamValue(param.getParams(), "materialTypeId");
        List<MaterialCategoryVO> categoryVOS = this.queryAllMaterialCategoryChildren(materialTypeId);
        if (categoryVOS.size() > 0) {
            ArrayList<String> categoryIds = new ArrayList<String>();
            for (MaterialCategoryVO vo : categoryVOS) {
                categoryIds.add(String.valueOf(vo.getId()));
            }
            param.getParams().put("materialTypeIds", new Parameter("in", categoryIds));
            param.getParams().remove("materialTypeId");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<BuyPriceVO> list = this.reportService.queryBuyPriceList((Page<BuyPriceVO>)page, param);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public List<BuyPriceDetailVO> getBuyPriceDetail(Map<String, Parameter> params, List<String> materialIds) {
        int pageNumber = 1;
        int pageSize = 10000;
        Page page = new Page();
        page.setCurrent((long)pageNumber);
        page.setSize((long)pageSize);
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME_DETAIL});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"materialId", materialIds));
        String startDate = this.getParamValue(params, "startDate");
        String endDate = this.getParamValue(params, "endDate");
        if (startDate != null || endDate != null) {
            RangeQueryBuilder settlementDate = QueryBuilders.rangeQuery((String)"settlementDate");
            if (startDate != null) {
                params.remove("startDate");
                settlementDate.gte((Object)startDate);
            }
            if (endDate != null) {
                params.remove("endDate");
                settlementDate.lte((Object)endDate);
            }
            boolQuery.must((QueryBuilder)settlementDate);
        }
        sourceBuilder.size(pageSize);
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        ArrayList<BuyPriceDetailVO> list = new ArrayList<BuyPriceDetailVO>();
        SearchResponse response = null;
        try {
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add((BuyPriceDetailVO)JSON.parseObject((String)sourceAsString, BuyPriceDetailVO.class));
            }
            page.setRecords(list);
            page.setTotal(hits.getTotalHits().value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    @RequestMapping(value={"/queryBuyPriceList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BuyPriceVO>> queryBuyPriceList(@RequestBody QueryParam param) {
        boolean flag = false;
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Page page = new Page();
        page.setCurrent((long)pageNumber);
        page.setSize((long)pageSize);
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        Map params = param.getParams();
        HashMap<String, Parameter> detailParam = new HashMap<String, Parameter>();
        if (params != null && params.size() > 0) {
            String materialTypeId = this.getParamValue(params, "materialTypeId");
            List<MaterialCategoryVO> categoryVOS = this.queryAllMaterialCategoryChildren(materialTypeId);
            if (categoryVOS.size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (MaterialCategoryVO materialCategoryVO : categoryVOS) {
                    arrayList.add(String.valueOf(materialCategoryVO.getId()));
                }
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"materialTypeId", arrayList));
                params.remove("materialTypeId");
            }
            String string = this.getParamValue(params, "startDate");
            String endDate = this.getParamValue(params, "endDate");
            if (string != null || endDate != null) {
                flag = true;
                if (string != null) {
                    detailParam.put("startDate", new Parameter("gt", (Object)string));
                    params.remove("startDate");
                }
                if (endDate != null) {
                    detailParam.put("endDate", new Parameter("le", (Object)endDate));
                    params.remove("endDate");
                }
            }
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                String value = this.getParamValue(params, key);
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)key, (Object)value));
            }
        }
        sourceBuilder.size(pageSize);
        sourceBuilder.query((QueryBuilder)boolQuery);
        LinkedHashMap orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase((String)entry.getValue())) {
                    sourceBuilder.sort((String)entry.getKey(), SortOrder.ASC);
                    continue;
                }
                sourceBuilder.sort((String)entry.getKey(), SortOrder.DESC);
            }
        }
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        ArrayList<Object> list = new ArrayList<Object>();
        Object var13_17 = null;
        try {
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            for (SearchHit searchHit : hits) {
                String sourceAsString = searchHit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, BuyPriceVO.class));
            }
            if (flag && CollectionUtil.isNotEmpty(list)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                list.stream().forEach(item -> materialIds.add(String.valueOf(item.getMaterialId())));
                List<BuyPriceDetailVO> list2 = this.getBuyPriceDetail(detailParam, arrayList);
                HashMap<Long, BuyPriceVO> buyPriceMap = new HashMap<Long, BuyPriceVO>();
                if (CollectionUtil.isNotEmpty(list2)) {
                    Map<Long, List<BuyPriceDetailVO>> buyPriceDetailMap = list2.stream().collect(Collectors.groupingBy(BuyPriceDetailVO::getMaterialId));
                    for (Map.Entry<Long, List<BuyPriceDetailVO>> m : buyPriceDetailMap.entrySet()) {
                        List<BuyPriceDetailVO> value = m.getValue();
                        if (value == null || value.size() == 0) continue;
                        BuyPriceVO buyPriceVO = new BuyPriceVO();
                        BigDecimal sumNum = BigDecimal.ZERO;
                        BigDecimal sumMoney = BigDecimal.ZERO;
                        ArrayList<BigDecimal> conPriceList = new ArrayList<BigDecimal>();
                        ArrayList<BigDecimal> priceList = new ArrayList<BigDecimal>();
                        for (BuyPriceDetailVO vo : value) {
                            sumNum = MathUtil.safeAdd((BigDecimal)sumNum, (BigDecimal)vo.getNum());
                            sumMoney = MathUtil.safeAdd((BigDecimal)sumMoney, (BigDecimal)vo.getMoney());
                            if (vo.getContractPrice() != null) {
                                conPriceList.add(vo.getContractPrice());
                            }
                            if (vo.getPrice() == null) continue;
                            priceList.add(vo.getPrice());
                        }
                        Collections.sort(conPriceList);
                        Collections.sort(priceList);
                        if (conPriceList.size() > 0) {
                            buyPriceVO.setMinContractPrice((BigDecimal)conPriceList.get(0));
                            buyPriceVO.setMaxContractPrice((BigDecimal)conPriceList.get(conPriceList.size() - 1));
                        } else {
                            buyPriceVO.setMinContractPrice(null);
                            buyPriceVO.setMaxContractPrice(null);
                        }
                        if (priceList.size() > 0) {
                            buyPriceVO.setMinPriceArea((BigDecimal)priceList.get(0));
                            buyPriceVO.setMaxPriceArea((BigDecimal)priceList.get(priceList.size() - 1));
                        } else {
                            buyPriceVO.setMinPriceArea(null);
                            buyPriceVO.setMaxPriceArea(null);
                        }
                        buyPriceVO.setTotalNum(sumNum);
                        buyPriceVO.setTotalMoney(sumMoney);
                        buyPriceVO.setAvgPrice(MathUtil.safeDiv((BigDecimal)sumMoney, (BigDecimal)sumNum));
                        buyPriceMap.put(m.getKey(), buyPriceVO);
                    }
                }
                for (BuyPriceVO buyPriceVO : list) {
                    Long materialId = buyPriceVO.getMaterialId();
                    BuyPriceVO p = (BuyPriceVO)buyPriceMap.get(materialId);
                    if (p != null) {
                        buyPriceVO.setMinContractPrice(p.getMinContractPrice());
                        buyPriceVO.setMaxContractPrice(p.getMaxContractPrice());
                        buyPriceVO.setMinPriceArea(p.getMinPriceArea());
                        buyPriceVO.setMaxPriceArea(p.getMaxPriceArea());
                        buyPriceVO.setTotalNum(p.getTotalNum());
                        buyPriceVO.setTotalMoney(p.getTotalMoney());
                        buyPriceVO.setAvgPrice(p.getAvgPrice());
                        continue;
                    }
                    buyPriceVO.setMinContractPrice(BigDecimal.ZERO);
                    buyPriceVO.setMaxContractPrice(BigDecimal.ZERO);
                    buyPriceVO.setMinPriceArea(BigDecimal.ZERO);
                    buyPriceVO.setMaxPriceArea(BigDecimal.ZERO);
                    buyPriceVO.setTotalNum(BigDecimal.ZERO);
                    buyPriceVO.setTotalMoney(BigDecimal.ZERO);
                    buyPriceVO.setAvgPrice(BigDecimal.ZERO);
                    buyPriceVO.setBuyPrice(BigDecimal.ZERO);
                }
            }
            page.setRecords(list);
            page.setTotal(hits.getTotalHits().value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private List<Long> loadBuyPriceList2ES(QueryParam param) {
        BulkRequest bulkRequest = new BulkRequest();
        List<BuyPriceVO> list = this.reportService.queryBuyPriceList(param);
        ArrayList<Long> materialTypeIds = new ArrayList<Long>();
        for (BuyPriceVO vo : list) {
            materialTypeIds.add(vo.getMaterialTypeId());
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("tenantId", String.valueOf(vo.getTenantId()));
            dataMap.put("materialTypeName", vo.getMaterialTypeName());
            dataMap.put("materialTypeId", String.valueOf(vo.getMaterialTypeId()));
            dataMap.put("materialCode", null);
            dataMap.put("materialName", vo.getMaterialName());
            dataMap.put("materialId", String.valueOf(vo.getMaterialId()));
            dataMap.put("model", vo.getModel());
            dataMap.put("unit", vo.getUnit());
            dataMap.put("totalNum", vo.getTotalNum());
            dataMap.put("totalMoney", vo.getTotalMoney());
            dataMap.put("minContractPrice", vo.getMinContractPrice());
            dataMap.put("maxContractPrice", vo.getMaxContractPrice());
            dataMap.put("avgPrice", vo.getAvgPrice());
            dataMap.put("minPriceArea", vo.getMinPriceArea());
            dataMap.put("maxPriceArea", vo.getMaxPriceArea());
            dataMap.put("buyPrice", vo.getBuyPrice());
            dataMap.put("settlementDate", format.format(vo.getSettlementDate()));
            IndexRequest indexRequest = new IndexRequest(INDEX_NAME);
            indexRequest.id(String.valueOf(vo.getId()));
            indexRequest.source(dataMap, XContentType.JSON);
            bulkRequest.add(indexRequest);
        }
        if (bulkRequest.requests().size() > 0) {
            try {
                this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        this.logger.info("\u91c7\u8d2d\u4ef7\u683c\u5206\u6790\u540c\u6b65\u7ed3\u7b97\u6c47\u603b\u6570\u91cf: " + bulkRequest.requests().size());
        return materialTypeIds;
    }

    @RequestMapping(value={"/queryBuyPriceDetailList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryBuyPriceDetailList(@RequestBody QueryParam param) {
        JSONObject obj = new JSONObject();
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Page page = new Page();
        page.setCurrent((long)pageNumber);
        page.setSize((long)pageSize);
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME_DETAIL});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        Map params = param.getParams();
        if (params != null && params.size() > 0) {
            String startDate = this.getParamValue(params, "startDate");
            String endDate = this.getParamValue(params, "endDate");
            if (startDate != null || endDate != null) {
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"settlementDate");
                if (startDate != null) {
                    params.remove("startDate");
                    rangeQueryBuilder.gte((Object)startDate);
                }
                if (endDate != null) {
                    params.remove("endDate");
                    rangeQueryBuilder.lte((Object)endDate);
                }
                boolQuery.must((QueryBuilder)rangeQueryBuilder);
            }
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                String value = this.getParamValue(params, key);
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)key, (Object)value));
            }
        }
        sourceBuilder.size(pageSize);
        sourceBuilder.query((QueryBuilder)boolQuery);
        LinkedHashMap orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase((String)entry.getValue())) {
                    sourceBuilder.sort((String)entry.getKey(), SortOrder.ASC);
                    continue;
                }
                sourceBuilder.sort((String)entry.getKey(), SortOrder.DESC);
            }
        }
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        ArrayList<Object> list = new ArrayList<Object>();
        BuyPriceVO buyPriceVO = new BuyPriceVO();
        Object var13_18 = null;
        try {
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, BuyPriceDetailVO.class));
            }
            page.setRecords(list);
            page.setTotal(hits.getTotalHits().value);
            if (CollectionUtil.isNotEmpty(list)) {
                BigDecimal sumNum = BigDecimal.ZERO;
                BigDecimal sumMoney = BigDecimal.ZERO;
                ArrayList<BigDecimal> conPriceList = new ArrayList<BigDecimal>();
                ArrayList<BigDecimal> priceList = new ArrayList<BigDecimal>();
                for (BuyPriceDetailVO buyPriceDetailVO : list) {
                    buyPriceVO.setMaterialName(buyPriceDetailVO.getMaterialName());
                    buyPriceVO.setModel(buyPriceDetailVO.getModel());
                    buyPriceVO.setUnit(buyPriceDetailVO.getUnit());
                    sumNum = MathUtil.safeAdd((BigDecimal)sumNum, (BigDecimal)buyPriceDetailVO.getNum());
                    sumMoney = MathUtil.safeAdd((BigDecimal)sumMoney, (BigDecimal)buyPriceDetailVO.getMoney());
                    if (buyPriceDetailVO.getContractPrice() != null) {
                        conPriceList.add(buyPriceDetailVO.getContractPrice());
                    }
                    if (buyPriceDetailVO.getPrice() == null) continue;
                    priceList.add(buyPriceDetailVO.getPrice());
                }
                Collections.sort(conPriceList);
                Collections.sort(priceList);
                if (conPriceList.size() > 0) {
                    buyPriceVO.setMinContractPrice((BigDecimal)conPriceList.get(0));
                    buyPriceVO.setMaxContractPrice((BigDecimal)conPriceList.get(conPriceList.size() - 1));
                } else {
                    buyPriceVO.setMinContractPrice(null);
                    buyPriceVO.setMaxContractPrice(null);
                }
                if (priceList.size() > 0) {
                    buyPriceVO.setMinPriceArea((BigDecimal)priceList.get(0));
                    buyPriceVO.setMaxPriceArea((BigDecimal)priceList.get(priceList.size() - 1));
                } else {
                    buyPriceVO.setMinPriceArea(null);
                    buyPriceVO.setMaxPriceArea(null);
                }
                buyPriceVO.setTotalNum(sumNum);
                buyPriceVO.setTotalMoney(sumMoney);
                buyPriceVO.setAvgPrice(MathUtil.safeDiv((BigDecimal)sumMoney, (BigDecimal)sumNum));
            } else {
                buyPriceVO.setMinContractPrice(BigDecimal.ZERO);
                buyPriceVO.setMaxContractPrice(BigDecimal.ZERO);
                buyPriceVO.setMinPriceArea(BigDecimal.ZERO);
                buyPriceVO.setMaxPriceArea(BigDecimal.ZERO);
                buyPriceVO.setAvgPrice(BigDecimal.ZERO);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        obj.put("obj", (Object)buyPriceVO);
        obj.put("pageData", (Object)page);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)obj);
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }

    @RequestMapping(value={"/loadBuyPrice2ES"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BuyPriceDetailVO> loadBuyPrice2ES(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        try {
            this.deleteESData(INDEX_NAME, param);
            List<Long> materialTypeIds = this.loadBuyPriceList2ES(param);
            if (CollectionUtil.isNotEmpty(materialTypeIds)) {
                this.deleteESData(INDEX_NAME_MATERIAL_CATEGORY, param);
                CommonResponse<MaterialCategoryVO> materialCategoryVOCommonResponse = this.loadMaterialCategoryList2ES(materialTypeIds);
                if (!materialCategoryVOCommonResponse.isSuccess()) {
                    return CommonResponse.error((String)materialCategoryVOCommonResponse.getMsg());
                }
                this.deleteESData(INDEX_NAME_DETAIL, param);
                this.loadBuyPriceDetailList2ES(param);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.success((String)"\u91cd\u65b0\u52a0\u8f7d\u6570\u636e\u6210\u529f\uff01");
    }

    private Long queryIndexSize(String indexName) {
        Long resultSize = 0L;
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"tenantId", (Object)InvocationInfoProxy.getTenantid());
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)termQueryBuilder);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            resultSize = hits.getTotalHits().value;
        }
        catch (IOException e) {
            try {
                SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                resultSize = hits.getTotalHits().value;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        return resultSize;
    }

    private long deleteESData(String indexName, QueryParam param) throws IOException {
        int i = 0;
        Long resultSize = this.queryIndexSize(indexName);
        Long deleteTimes = resultSize % (long)BATCH_SIZE.intValue();
        if ((long)i < deleteTimes + 1L) {
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{indexName});
            deleteByQueryRequest.setQuery((QueryBuilder)new TermQueryBuilder("tenantId", (Object)InvocationInfoProxy.getTenantid()));
            deleteByQueryRequest.setBatchSize(BATCH_SIZE.intValue());
            BulkByScrollResponse response = this.client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            return response.getDeleted();
        }
        return 0L;
    }

    private CommonResponse<MaterialCategoryVO> loadMaterialCategoryList2ES(List<Long> materialTypeIds) {
        if (CollectionUtil.isEmpty(materialTypeIds)) {
            this.logger.info("\u672a\u67e5\u8be2\u5230\u7269\u8d44\u7ed3\u7b97\u660e\u7269\u6599\u5206\u7c7b\u6570\u636e!");
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u7269\u8d44\u7ed3\u7b97\u660e\u7269\u6599\u5206\u7c7b\u6570\u636e\uff01");
        }
        List ids = materialTypeIds.stream().distinct().collect(Collectors.toList());
        CommonResponse categoryList = this.materialApi.queryCategoryListByChildren(ids);
        if (CollectionUtil.isEmpty((Collection)((Collection)categoryList.getData()))) {
            this.logger.info("\u83b7\u53d6\u5f53\u524d\u79df\u6237\u7269\u6599\u5206\u7c7b\u6811\u5931\u8d25!");
            return CommonResponse.error((String)"\u83b7\u53d6\u5f53\u524d\u79df\u6237\u7269\u6599\u5206\u7c7b\u6811\u5931\u8d25\uff01");
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (MaterialCategoryVO vo : (List)categoryList.getData()) {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("tenantId", String.valueOf(InvocationInfoProxy.getTenantid()));
            dataMap.put("id", String.valueOf(vo.getId()));
            dataMap.put("parentId", null == vo.getParentId() ? null : String.valueOf(vo.getParentId()));
            dataMap.put("code", vo.getCode());
            dataMap.put("name", vo.getName());
            dataMap.put("innerCode", vo.getInnerCode());
            dataMap.put("enabled", String.valueOf(vo.getEnabled()));
            dataMap.put("isLeaf", String.valueOf(vo.getIsLeaf()));
            IndexRequest indexRequest = new IndexRequest(INDEX_NAME_MATERIAL_CATEGORY);
            indexRequest.id(String.valueOf(InvocationInfoProxy.getTenantid()) + vo.getId());
            indexRequest.source(dataMap, XContentType.JSON);
            bulkRequest.add(indexRequest);
        }
        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            System.out.println("\u540c\u6b65es....");
            this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        this.logger.info("\u91c7\u8d2d\u4ef7\u683c\u5206\u6790\u540c\u6b65\u7269\u6599\u5206\u7c7b\u6570\u91cf: " + bulkRequest.requests().size());
        return CommonResponse.success((String)"\u91cd\u65b0\u52a0\u8f7d\u7269\u6599\u5206\u7c7b\u6570\u636e\u6210\u529f\uff01");
    }

    private void loadBuyPriceDetailList2ES(QueryParam param) {
        CommonResponse listCommonResponse;
        List supplierVOS;
        List supplierIds;
        CommonResponse response;
        List projects;
        List<BuyPriceDetailVO> list = this.reportService.queryBuyPriceDetailList(param);
        List projectIds = list.stream().map(BuyPriceDetailVO::getProjectId).collect(Collectors.toList());
        Map<Object, Object> projectMap = new HashMap();
        Map<Object, Object> supplierMap = new HashMap();
        if (!CollectionUtil.isEmpty(projectIds) && !CollectionUtil.isEmpty((Collection)(projects = (List)(response = this.projectApi.queryProjectByIds(projectIds)).getData()))) {
            projectMap = projects.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        }
        if (!CollectionUtil.isEmpty(supplierIds = list.stream().map(BuyPriceDetailVO::getSupplierId).collect(Collectors.toList())) && !CollectionUtil.isEmpty((Collection)(supplierVOS = (List)(listCommonResponse = this.supplierApi.querySupplierByIds(supplierIds)).getData()))) {
            supplierMap = supplierVOS.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        }
        boolean insertEsFlag = false;
        BulkRequest bulkRequest = new BulkRequest();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        for (BuyPriceDetailVO vo : list) {
            Long projectId = vo.getProjectId();
            Long supplierId = vo.getSupplierId();
            ProjectRegisterVO pro = (ProjectRegisterVO)projectMap.get(projectId);
            SupplierVO su = (SupplierVO)supplierMap.get(supplierId);
            if (su != null && StringUtils.isNotEmpty((CharSequence)su.getProvince())) {
                vo.setProvince(su.getProvince());
                vo.setCity(su.getCity());
                vo.setRegion(su.getRegion());
                vo.setArea(su.getArea());
            } else if (null != pro) {
                vo.setProvince(pro.getProvince());
                vo.setCity(pro.getCity());
                vo.setRegion(pro.getRegion());
                vo.setArea(pro.getArea());
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("billCode", vo.getBillCode());
            dataMap.put("contractName", vo.getContractName());
            dataMap.put("contractId", String.valueOf(vo.getContractId()));
            dataMap.put("supplierName", vo.getSupplierName());
            dataMap.put("supplierId", String.valueOf(vo.getSupplierId()));
            dataMap.put("orgName", vo.getOrgName());
            dataMap.put("orgId", String.valueOf(vo.getOrgId()));
            dataMap.put("settlementDate", format.format(vo.getSettlementDate()));
            dataMap.put("contractPrice", vo.getContractPrice());
            dataMap.put("pId", String.valueOf(vo.getpId()));
            dataMap.put("materialTypeName", vo.getMaterialTypeName());
            dataMap.put("materialTypeId", String.valueOf(vo.getMaterialTypeId()));
            dataMap.put("materialName", vo.getMaterialName());
            dataMap.put("materialId", String.valueOf(vo.getMaterialId()));
            dataMap.put("model", vo.getModel());
            dataMap.put("unit", vo.getUnit());
            dataMap.put("num", vo.getNum());
            dataMap.put("price", vo.getPrice());
            dataMap.put("money", vo.getMoney());
            dataMap.put("taxRate", vo.getTaxRate());
            dataMap.put("province", vo.getProvince());
            dataMap.put("city", vo.getCity());
            dataMap.put("region", vo.getRegion());
            dataMap.put("projectId", String.valueOf(vo.getProjectId()));
            dataMap.put("tenantId", String.valueOf(vo.getTenantId()));
            dataMap.put("area", vo.getArea());
            IndexRequest indexRequest = new IndexRequest(INDEX_NAME_DETAIL);
            indexRequest.id(String.valueOf(vo.getId()));
            indexRequest.source(dataMap, XContentType.JSON);
            bulkRequest.add(indexRequest);
            insertEsFlag = true;
        }
        this.logger.info("\u91c7\u8d2d\u4ef7\u683c\u5206\u6790\u540c\u6b65\u7269\u6599\u660e\u7ec6\u6570\u91cf: " + bulkRequest.requests().size());
        if (insertEsFlag) {
            try {
                this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        CommonResponse<IPage<BuyPriceVO>> page = this.queryBuyPriceList(param);
        List list = ((IPage)page.getData()).getRecords();
        HashMap<String, List> beans = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            beans.put("records", list);
            ExcelExport.getInstance().export("buyPriceListExport.xlsx", beans, response);
        }
    }
}

