/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.pub.MaterialAllocationState;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IOutStoreSubService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.OutStoreExportVO;
import com.ejianc.business.material.vo.OutStoreSubVO;
import com.ejianc.business.material.vo.OutStoreVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.PickRegisterDetailVO;
import com.ejianc.business.sub.api.ISubReportApi;
import com.ejianc.business.sub.vo.SettlePickDeductVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/outStore/"})
public class OutStoreController {
    private static final String BILL_CODE = "MATERIAL-OUTSTORE";
    @Autowired
    IOutStoreService iOutStoreService;
    @Autowired
    IOutStoreSubService outStoreSubService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    IStoreService storeService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISubReportApi subReportApi;

    @RequestMapping(value={"saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutStoreVO> saveOrUpdate(@RequestBody OutStoreVO vo) {
        List<OutStoreSubEntity> outStoreSubEntities;
        this.beforeSave(vo);
        OutStoreEntity entity = (OutStoreEntity)((Object)BeanMapper.map((Object)((Object)vo), OutStoreEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (ListUtil.isNotEmpty(outStoreSubEntities = entity.getOutStoreSubEntities())) {
            OutStoreEntity oldEntity;
            Map<Object, Object> numMap = new HashMap();
            if (null != vo.getId() && CollUtil.isNotEmpty((oldEntity = (OutStoreEntity)((Object)this.iOutStoreService.selectById(vo.getId()))).getOutStoreSubEntities())) {
                numMap = oldEntity.getOutStoreSubEntities().stream().collect(Collectors.toMap(OutStoreSubEntity::getSourceSubId, OutStoreSubEntity::getOutStoreNumber));
            }
            for (OutStoreSubEntity outStoreSubEntity : outStoreSubEntities) {
                if ("del".equals(outStoreSubEntity.getRowState())) continue;
                BigDecimal inNum = this.storeService.calculateCanUseNum(outStoreSubEntity.getSourceSubId(), outStoreSubEntity.getMaterialId(), null);
                BigDecimal _num = outStoreSubEntity.getOutStoreNumber();
                if (null != numMap.get(outStoreSubEntity.getSourceSubId())) {
                    _num = ComputeUtil.safeSub((BigDecimal)_num, (BigDecimal)((BigDecimal)numMap.get(outStoreSubEntity.getSourceSubId())));
                }
                if (!ComputeUtil.isGreaterThan((BigDecimal)_num, (BigDecimal)inNum)) continue;
                throw new BusinessException("\u7269\u8d44\u3010" + outStoreSubEntity.getMaterialName() + "\u3011\u5df2\u88ab\u4f7f\u7528\u5b8c\u6bd5\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u5236\u5355\uff01");
            }
        }
        this.iOutStoreService.saveOrUpdate((Object)entity, false);
        OutStoreVO backVo = (OutStoreVO)((Object)BeanMapper.map((Object)((Object)entity), OutStoreVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)backVo));
    }

    public void beforeSave(OutStoreVO vo) {
        BigDecimal totalAmountNoTax = new BigDecimal(0);
        if (!ListUtil.isEmpty(vo.getOutStoreSubEntities())) {
            for (OutStoreSubVO sub : vo.getOutStoreSubEntities()) {
                if ("del".equals(sub.getRowState())) continue;
                sub.setStoreId(vo.getStoreId());
                sub.setStoreType(vo.getStoreType());
                sub.setOutDate(vo.getOutDate());
                sub.setStoreState(MaterialStoreState.OCCUPY.getCode());
                totalAmountNoTax = totalAmountNoTax.add(sub.getAmount() == null ? new BigDecimal("0.00") : sub.getAmount().divide(new BigDecimal("1.00").add(sub.getTaxRate() == null ? new BigDecimal("0.00") : sub.getTaxRate().divide(new BigDecimal("100.00"), 8, 4)), 8, 4));
            }
        }
        vo.setOutMoneyNoTax(totalAmountNoTax);
    }

    @RequestMapping(value={"pushToCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutStoreVO> pushToCost(@RequestBody OutStoreVO vo) {
        this.beforeSave(vo);
        OutStoreEntity entity = (OutStoreEntity)((Object)BeanMapper.map((Object)((Object)vo), OutStoreEntity.class));
        this.iOutStoreService.processCost(entity);
        this.iOutStoreService.saveOrUpdate((Object)entity, false);
        OutStoreVO backVo = (OutStoreVO)((Object)BeanMapper.map((Object)((Object)entity), OutStoreVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u5173\u8054\u6210\u529f\uff01", (Object)((Object)backVo));
    }

    @RequestMapping(value={"queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutStoreVO> queryDetail(Long id) {
        OutStoreEntity entity = (OutStoreEntity)((Object)this.iOutStoreService.selectById(id));
        OutStoreVO vo = (OutStoreVO)((Object)BeanMapper.map((Object)((Object)entity), OutStoreVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialNames");
        fuzzyFields.add("orgName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("useFor");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.iOutStoreService.queryForList(param, false));
    }

    @RequestMapping(value={"queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("store", this.iOutStoreService.selectById(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutStoreVO> vos) {
        this.iOutStoreService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.setPageIndex(0);
        queryParam.setPageSize(10000);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialNames");
        fuzzyFields.add("orgName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("useFor");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("billCode");
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage<OutStoreVO> voPage = this.iOutStoreService.queryForList(queryParam, false);
        List list = voPage.getRecords();
        ArrayList exportVOS = new ArrayList();
        if (ListUtil.isNotEmpty((List)list)) {
            list.forEach(vo -> {
                OutStoreExportVO exportVO = (OutStoreExportVO)BeanMapper.map((Object)vo, OutStoreExportVO.class);
                exportVO.setCreateTime(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getCreateTime()));
                exportVO.setOutDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getOutDate()));
                if (StringUtils.isNotBlank((CharSequence)vo.getReceiveState())) {
                    exportVO.setReceiveState(MaterialAllocationState.TO_RECEIVING.getCode().equals(vo.getReceiveState()) ? "\u5f85\u6536" : (MaterialAllocationState.RECEIVED.getCode().equals(vo.getReceiveState()) ? "\u5df2\u6536" : "\u5df2\u9000\u56de\uff1a" + vo.getReturnReason()));
                }
                exportVO.setBillState(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                String outNum = exportVO.getOutNum();
                String outMoney = exportVO.getOutMoney();
                if (StringUtils.isNotEmpty((CharSequence)outNum) && outNum.equals("0E-8")) {
                    exportVO.setOutNum("0");
                }
                if (StringUtils.isNotEmpty((CharSequence)outMoney) && outMoney.equals("0E-8")) {
                    exportVO.setOutMoney("0.00");
                }
                exportVOS.add(exportVO);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", exportVOS);
        if (((Parameter)queryParam.getParams().get("storeType")).getValue().equals(MaterialStoreType.ALLOCATION_OUT_STORE.getCode())) {
            ExcelExport.getInstance().export("allocationOutExport.xlsx", beans, response);
        } else if (((Parameter)queryParam.getParams().get("storeType")).getValue().equals(MaterialStoreType.PICKING_OUT_STORE.getCode())) {
            ExcelExport.getInstance().export("pickingOutExport.xlsx", beans, response);
        } else if (((Parameter)queryParam.getParams().get("storeType")).getValue().equals(MaterialStoreType.RETURN_GOODS_OUT_STORE.getCode())) {
            ExcelExport.getInstance().export("returnGoodsListExport.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"queryOutStoreMaterialList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutStoreSubVO>> queryOutStoreMaterialList(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        JSONObject json;
        Long storeId = null;
        String outDate = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            json = JSONObject.parseObject((String)condition);
            if (json.get((Object)"storeId") == null) {
                return CommonResponse.error((String)"condition\u6761\u4ef6\u7f3a\u5c11storeId\uff08\u4ed3\u5e93id\uff09\uff01");
            }
            storeId = Long.parseLong(json.get((Object)"storeId").toString());
            if (json.get((Object)"outDate") == null) {
                return CommonResponse.error((String)"condition\u6761\u4ef6\u7f3a\u5c11outDate(\u51fa\u5e93\u65e5\u671f)\uff01");
            }
        } else {
            return CommonResponse.error((String)"\u7f3a\u5c11condition\u6761\u4ef6");
        }
        outDate = json.get((Object)"outDate").toString();
        String storeType = "5,6";
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.outStoreSubService.queryOutStoreMaterialList(pageNumber, pageSize, storeId, outDate, storeType, searchText, searchObject));
    }

    @RequestMapping(value={"queryRefNotSettlementList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> queryRefNotSettlementList(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject json = JSONObject.parseObject((String)condition);
            if (json.get((Object)"orgId") == null) {
                return CommonResponse.error((String)"condition\u6761\u4ef6\u7f3a\u5c11orgId\uff01");
            }
            param.getParams().put("orgId", new Parameter("eq", json.get((Object)"orgId")));
            if (json.get((Object)"contractId") != null) {
                param.getParams().put("contractId", new Parameter("eq", json.get((Object)"contractId")));
            }
        } else {
            return CommonResponse.error((String)"\u7f3a\u5c11condition\u6761\u4ef6");
        }
        param.getParams().put("storeType", new Parameter("eq", (Object)"8"));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "desc");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("settlementFlag", new Parameter("eq", (Object)"0"));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("settlementFlag", new Parameter("eq", null));
        c1.getComplexParams().add(c3);
        param.getComplexParams().add(c1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialNames");
        IPage<OutStoreVO> page = this.iOutStoreService.queryForList(param, false);
        this.setType(page.getRecords());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", page);
    }

    public void setType(List<OutStoreVO> list) {
        if (ListUtil.isNotEmpty(list)) {
            list.forEach(l -> {
                OutStoreEntity entity = (OutStoreEntity)((Object)((Object)this.iOutStoreService.selectById(l.getId())));
                if (ListUtil.isNotEmpty(entity.getOutStoreSubEntities())) {
                    List<OutStoreSubEntity> entities = entity.getOutStoreSubEntities();
                    l.setOutStoreSubEntities(BeanMapper.mapList(entities, OutStoreSubVO.class));
                }
                l.setStoreTypeName(MaterialStoreType.getStoreTypeNameByCode((Integer)l.getStoreType()));
            });
        }
    }

    @RequestMapping(value={"queryMaterialCostTopN"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryMaterialCostTopN(@RequestParam(value="topN", defaultValue="5") Integer topN, @RequestParam(value="type", defaultValue="2") Integer type) {
        return this.iOutStoreService.queryMaterialCostTopN(topN, type);
    }

    @RequestMapping(value={"checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody MaterialPriceVO vo) {
        ParamsCheckVO paramsCheckVO = this.iOutStoreService.checkParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @RequestMapping(value={"queryPickDeductList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PickRegisterDetailVO>> queryPickDeductList(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnitName");
        Long projectId = null;
        Long supplierId = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject json = JSONObject.parseObject((String)condition);
            if (json.get((Object)"projectId") != null) {
                projectId = Long.parseLong(json.get((Object)"projectId").toString());
            }
            if (json.get((Object)"supplierId") != null) {
                supplierId = Long.parseLong(json.get((Object)"supplierId").toString());
            }
        } else {
            return CommonResponse.error((String)"\u7f3a\u5c11condition\u6761\u4ef6");
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<PickRegisterDetailVO> pickDeductList = this.iOutStoreService.queryPickDeductList((Page<PickRegisterDetailVO>)page, wrapper, projectId, supplierId);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        queryParam.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        List list = new ArrayList();
        CommonResponse listCommonResponse = this.subReportApi.queryLastSettlePickDeductMnyList(queryParam);
        if (listCommonResponse.isSuccess()) {
            list = (List)listCommonResponse.getData();
        }
        Map<Long, BigDecimal> deductMnymap = list.stream().collect(Collectors.toMap(SettlePickDeductVO::getMaterialId, SettlePickDeductVO::getDeductMny));
        for (PickRegisterDetailVO pickRegisterDetailVO : pickDeductList) {
            Long materialId = pickRegisterDetailVO.getMaterialId();
            BigDecimal deductMny = deductMnymap.get(materialId);
            pickRegisterDetailVO.setDeductMny(deductMny);
        }
        page.setTotal(page.getTotal());
        page.setRecords(pickDeductList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }
}

