package com.ejianc.foundation.mdm.api;

import javax.servlet.http.HttpServletRequest;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.mdm.hystrix.MdmHystrix;
import com.ejianc.foundation.mdm.param.DeleteParam;
import com.ejianc.foundation.mdm.param.InsertParam;
import com.ejianc.foundation.mdm.param.ListByIdsParam;
import com.ejianc.foundation.mdm.param.ListParam;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 人员管理微服务
 * 
 * @author guoming
 *
 */
@FeignClient(name= "ejc-mdm-web", url="${common.env.feign-client-url}", path="ejc-mdm-web", fallback = MdmHystrix.class)
public interface IMdmApi {	
	
	/**
	 * 根据主数据ID查询数据列表-分发数据
	 * 
	 * @param listByIdsParam
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/api/mdm/queryListByMdmIds", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> queryListByMdmIds(@RequestBody ListByIdsParam listByIdsParam);

	/**
	 * 根据查询条件查询列表-分发数据
	 * 
	 * @param listParam
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/api/mdm/queryListByConditions", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> queryListByConditions(@RequestBody ListParam listParam);

	/**
	 * 插入主数据-灌入数据
	 * 
	 * @return
	 */
	@RequestMapping(value = "/api/mdm/insertOrUpdateMdmData", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> insertOrUpdateMdmData(@RequestBody InsertParam insertParam);

	
	/**
	 * 删除主数据
	 * 
	 * @param deleteParam
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/api/mdm/deleteMdmData", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> deleteMdmData(@RequestBody DeleteParam deleteParam);
}
