package com.ejianc.foundation.mdm.controller.api;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.mdm.bean.DataCleanRuleDetailEntity;
import com.ejianc.foundation.mdm.bean.DataCleanRuleEntity;
import com.ejianc.foundation.mdm.bean.DataModelEntity;
import com.ejianc.foundation.mdm.bean.DataModelItemEntity;
import com.ejianc.foundation.mdm.bean.DataTransferLogEntity;
import com.ejianc.foundation.mdm.bean.ThirdSystemEntity;
import com.ejianc.foundation.mdm.param.DeleteParam;
import com.ejianc.foundation.mdm.param.InsertParam;
import com.ejianc.foundation.mdm.param.ListByIdsParam;
import com.ejianc.foundation.mdm.param.ListParam;
import com.ejianc.foundation.mdm.service.IDataCleanRuleDetailService;
import com.ejianc.foundation.mdm.service.IDataCleanRuleService;
import com.ejianc.foundation.mdm.service.IDataModelItemService;
import com.ejianc.foundation.mdm.service.IDataModelService;
import com.ejianc.foundation.mdm.service.IDataTransferLogService;
import com.ejianc.foundation.mdm.service.IThirdSystemService;
import com.ejianc.foundation.mdm.utils.MdmUtils;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.Validate;
import com.ejianc.support.idworker.util.IdWorker;

@RestController
@RequestMapping("/api/mdm/")
public class MdmApiController implements Serializable {
	
	private static final long serialVersionUID = 1L;
	
	@Autowired
	private IThirdSystemService thirdSystemService;
	@Autowired
	private IDataModelService dataModelService;
	@Autowired
	private IDataModelItemService dataModelItemService;
	@Autowired
	private IDataTransferLogService dataTransferLogService;
	@Autowired
	private IDataCleanRuleService dataCleanRuleService;
	@Autowired
	private IDataCleanRuleDetailService dataCleanRuleDetailService;
	
	/**
	 * 根据主数据ID查询数据列表-分发数据
	 * 
	 * @param listByIdsParam
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/queryListByMdmIds", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> queryListByMdmIds(@RequestBody ListByIdsParam listByIdsParam, HttpServletRequest request) {
		String ticket = request.getHeader("ticket");
		if(StringUtils.isBlank(ticket)) {
			throw new BusinessException("请求头中的ticket不能为空");
		}
		
		QueryWrapper<ThirdSystemEntity> thirdSystemWrapper = new QueryWrapper<>();
		thirdSystemWrapper.eq("system_code", listByIdsParam.getSystemCode());
		ThirdSystemEntity thirdSystemEntity = thirdSystemService.getOne(thirdSystemWrapper);
		if(thirdSystemEntity == null) {
			throw new BusinessException("参数错误：该系统编号未在主数据系统中注册");
		}
		//插入调用日志
		DataTransferLogEntity transferLog = new DataTransferLogEntity();
		transferLog.setId(IdWorker.getId());
		transferLog.setThirdSystemId(thirdSystemEntity.getId());
		transferLog.setCallType("queryListByMdmIds");
		transferLog.setReqTime(new Date());
		transferLog.setReqParams(listByIdsParam.toString());
		transferLog.setRespState("failed");
		dataTransferLogService.saveOrUpdate(transferLog, false);
		
		if(ticket.equals(thirdSystemEntity.getTicket())) {
			JSONObject responseData = new JSONObject();
			//获取主模型
			QueryWrapper<DataModelEntity> masterDataModelWrapper = new QueryWrapper<>();
			masterDataModelWrapper.eq("model_code", listByIdsParam.getDataModelCode());
			DataModelEntity masterDataModelEntity = dataModelService.getOne(masterDataModelWrapper);
			
			List<String> mdmIds = listByIdsParam.getMdmIds();
			String mdmIdStr = "";
			List<JSONObject> resultDataList = null;
			if(mdmIds != null && mdmIds.size() > 0) {
				for(String mdmId:mdmIds) {
					mdmIdStr += mdmId + ",";
				}
				if(StringUtils.isNotBlank(mdmIdStr)) {
					mdmIdStr = mdmIdStr.substring(0, mdmIdStr.length()-1);
				}
				Map<String, Object> modelItemMap = new HashMap<String, Object>();
				modelItemMap.put("mdmIdStr", mdmIdStr);
				modelItemMap.put("tableName", masterDataModelEntity.getModelCode());
				resultDataList = dataModelItemService.queryMdmDataList(modelItemMap);
				
				QueryWrapper<DataModelItemEntity> masterDataModelItemWrapper = new QueryWrapper<>();
				masterDataModelItemWrapper.eq("data_model_id", masterDataModelEntity.getId());
				List<DataModelItemEntity> dataModelItemEntities = dataModelItemService.list(masterDataModelItemWrapper);
				MdmUtils.parseJSONObject(resultDataList, dataModelItemEntities);
				
				if(resultDataList != null && resultDataList.size() > 0) {
					QueryWrapper<DataModelEntity> childDataModelWrapper = new QueryWrapper<>();
					childDataModelWrapper.eq("parent_id", masterDataModelEntity.getId());
					List<DataModelEntity> childDataModelList = dataModelService.list(childDataModelWrapper);
					if(childDataModelList != null && childDataModelList.size() > 0) {
						for(DataModelEntity childModel:childDataModelList) {
							
							//child模型项
							QueryWrapper<DataModelItemEntity> childDataModelItemWrapper = new QueryWrapper<>();
							childDataModelItemWrapper.eq("data_model_id", childModel.getId());
							List<DataModelItemEntity> childDataModelItemEntities = dataModelItemService.list(childDataModelItemWrapper);
							
							for(JSONObject masterData:resultDataList) {
								Map<String, Object> childParamMap = new HashMap<String, Object>();
								childParamMap.put("parentId", masterData.get("_master_data_id").toString());
								childParamMap.put("tableName", childModel.getModelCode());
								List<JSONObject> childDataList = dataModelItemService.queryMdmChildDataList(childParamMap);
								MdmUtils.parseJSONObject(childDataList, childDataModelItemEntities);
								
								masterData.put(childModel.getModelCode(), childDataList);
							}
						}
					}
				}
				responseData.put(masterDataModelEntity.getModelCode(), resultDataList);
				
				transferLog.setCallResp(JSON.toJSONString(responseData));
				transferLog.setRespState("ok");
				dataTransferLogService.saveOrUpdate(transferLog, false);
				
				return CommonResponse.success(responseData);
			}else{
				throw new BusinessException("主数据ids不正确");
			}
		}else{
			throw new BusinessException("票据验证不通过");
		}
	}

	/**
	 * 根据查询条件查询列表-分发数据
	 * 
	 * @param listParam
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/queryListByConditions", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> queryListByConditions(@RequestBody ListParam listParam, HttpServletRequest request) {
		String ticket = request.getHeader("ticket");
		if(StringUtils.isBlank(ticket)) {
			throw new BusinessException("请求头中的ticket不能为空");
		}
		
		QueryWrapper<ThirdSystemEntity> thirdSystemWrapper = new QueryWrapper<>();
		thirdSystemWrapper.eq("system_code", listParam.getSystemCode());
		ThirdSystemEntity thirdSystemEntity = thirdSystemService.getOne(thirdSystemWrapper);
		if(thirdSystemEntity == null) {
			throw new BusinessException("参数错误：该系统编号未在主数据系统中注册");
		}
		
		//插入调用日志
		DataTransferLogEntity transferLog = new DataTransferLogEntity();
		transferLog.setId(IdWorker.getId());
		transferLog.setThirdSystemId(thirdSystemEntity.getId());
		transferLog.setCallType("queryListByConditions");
		transferLog.setReqTime(new Date());
		transferLog.setReqParams(listParam.toString());
		transferLog.setRespState("failed");
		dataTransferLogService.saveOrUpdate(transferLog, false);
				
		if(ticket.equals(thirdSystemEntity.getTicket())) {
			JSONObject responseData = new JSONObject();
			//获取主模型
			QueryWrapper<DataModelEntity> masterDataModelWrapper = new QueryWrapper<>();
			masterDataModelWrapper.eq("model_code", listParam.getDataModelCode());
			DataModelEntity masterDataModelEntity = dataModelService.getOne(masterDataModelWrapper);
			
			Map<String, Object> modelItemMap = new HashMap<String, Object>();
			if(-1 != listParam.getPageIndex()) {
				modelItemMap.put("pageIndex", listParam.getPageIndex()==null?0:listParam.getPageIndex());
				modelItemMap.put("pageSize", listParam.getPageSize()==null?500:listParam.getPageSize());
			}
			modelItemMap.put("lastUpdateTime", listParam.getLastUpdateTime());
			modelItemMap.put("tableName", masterDataModelEntity.getModelCode());
			List<JSONObject> resultDataList = dataModelItemService.queryMdmDataList(modelItemMap);
			Long dataTotal = dataModelItemService.queryMdmDataCount(modelItemMap);
			
			QueryWrapper<DataModelItemEntity> masterDataModelItemWrapper = new QueryWrapper<>();
			masterDataModelItemWrapper.eq("data_model_id", masterDataModelEntity.getId());
			List<DataModelItemEntity> dataModelItemEntities = dataModelItemService.list(masterDataModelItemWrapper);
			MdmUtils.parseJSONObject(resultDataList, dataModelItemEntities);
			
			
			if(resultDataList != null && resultDataList.size() > 0) {
				QueryWrapper<DataModelEntity> childDataModelWrapper = new QueryWrapper<>();
				childDataModelWrapper.eq("parent_id", masterDataModelEntity.getId());
				List<DataModelEntity> childDataModelList = dataModelService.list(childDataModelWrapper);
				if(childDataModelList != null && childDataModelList.size() > 0) {
					for(DataModelEntity childModel:childDataModelList) {
						//child模型项
						QueryWrapper<DataModelItemEntity> childDataModelItemWrapper = new QueryWrapper<>();
						childDataModelItemWrapper.eq("data_model_id", childModel.getId());
						List<DataModelItemEntity> childDataModelItemEntities = dataModelItemService.list(childDataModelItemWrapper);
						
						for(JSONObject masterData:resultDataList) {
							Map<String, Object> childParamMap = new HashMap<String, Object>();
							childParamMap.put("parentId", masterData.get("_master_data_id").toString());
							childParamMap.put("tableName", childModel.getModelCode());
							List<JSONObject> childDataList = dataModelItemService.queryMdmChildDataList(childParamMap);
							
							MdmUtils.parseJSONObject(childDataList, childDataModelItemEntities);
							masterData.put(childModel.getModelCode(), childDataList);
						}
					}
				}
			}
			
			responseData.put("total", dataTotal);
			responseData.put(masterDataModelEntity.getModelCode(), resultDataList);
			
			transferLog.setCallResp(JSON.toJSONString(responseData));
			transferLog.setRespState("ok");
			dataTransferLogService.saveOrUpdate(transferLog, false);
			
			return CommonResponse.success(responseData);
		}else{
			throw new BusinessException("票据验证不通过");
		}
	}
	
	
	private Map<String, String> executeInsertMdmData(List<Map<String, String>> errorList, DataModelEntity masterDataModelEntity,
			List<DataModelItemEntity> dataModelItemEntities, 
			JSONObject saveData, List<DataCleanRuleDetailEntity> cleanRuleDetailList) {
		String sourceId = saveData.getString("sourceId");
		Map<String, String> errorMap = new HashMap<>();
		if(cleanRuleDetailList != null && cleanRuleDetailList.size() > 0) {
			for(DataCleanRuleDetailEntity cleanRuleDetail:cleanRuleDetailList) {
				String ruleType = cleanRuleDetail.getRuleType();
				DataModelItemEntity dataModelItem = dataModelItemService.getById(cleanRuleDetail.getDataModelItemId());
				String value = saveData.getString(dataModelItem.getItemCode());
				switch(ruleType) {
					case "1": //字段去重
						Map<String, String> paramMap = new HashMap<>();
						paramMap.put("repeatSql", dataModelItem.getItemCode() + "=" +value);
						paramMap.put("sourceId", sourceId);
						paramMap.put("tableName", masterDataModelEntity.getModelCode());
						JSONObject jsonObject = dataModelItemService.queryDataIsExist(paramMap);
						if(jsonObject != null) {
							errorMap.put(dataModelItem.getItemCode(), dataModelItem.getItemName()+"字段不能重复");
						}
						break;
					case "2": //必填判断
						if(StringUtils.isBlank(value)) {
							errorMap.put(dataModelItem.getItemCode(), dataModelItem.getItemName()+"不能为空");
						}
						break;
					case "3": //邮箱判断
						if(!Validate.isEmail(value)) {
							errorMap.put(dataModelItem.getItemCode(), dataModelItem.getItemName()+"邮箱不合法");
						}
						break;
					case "4": //整数判断
						try {
							Integer.parseInt(value);
						}catch(Exception e) {
							errorMap.put(dataModelItem.getItemCode(), dataModelItem.getItemName()+"必须是整数");
						}
						break;
					case "5": //金额判断
						if(!Pattern.matches("^[-\\+]?[.\\d]*$", value)){
							errorMap.put(dataModelItem.getItemCode(), dataModelItem.getItemName()+"必须是金额格式");
						}
						break;
					case "6": //日期判断
						SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
						try {
							format.parse(value);
						} catch (Exception e) {
							errorMap.put(dataModelItem.getItemCode(), dataModelItem.getItemName()+"必须是日期格式");
						}
						break;
					case "7": //参照
						Map<String, String> referParamMap = new HashMap<>();
						referParamMap.put("tableName", dataModelItem.getReferCode());
						referParamMap.put("_source_id", value);
						JSONObject referObject = dataModelItemService.queryReferData(referParamMap);
						if(referObject == null) {
							errorMap.put(dataModelItem.getItemCode(), dataModelItem.getItemName()+"未查询到对应的参照数据");
						}
						break;
				}
				if(!errorMap.isEmpty()) {
					errorMap.put("errorData", JSON.toJSONString(saveData));
					errorList.add(errorMap);
					break;
				}
			}
		}
		
		if(errorMap.isEmpty()) {
			String executeSql = "";
			JSONObject uniqueData = dataModelItemService.queryDataBySourceId(masterDataModelEntity.getModelCode(), sourceId);
			
			if(uniqueData != null) {
				executeSql += "update "+ masterDataModelEntity.getModelCode() + " set _last_update_time = now(),_data_type=2,";
				for(DataModelItemEntity modelItem:dataModelItemEntities) {
					if("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
						continue;
					}
					if(StringUtils.isNotBlank(saveData.getString(modelItem.getItemCode()))) {
						executeSql += "`"+modelItem.getItemCode() + "`='" + saveData.getString(modelItem.getItemCode()) + "',";
					}else{
						executeSql += "`"+modelItem.getItemCode() + "`=null,";
					}
				}
				executeSql = executeSql.substring(0, executeSql.length()-1);
				executeSql += " where _source_id='"+sourceId+"'";
				
				dataModelItemService.executeUpdateSql(executeSql);
			}
			if(StringUtils.isBlank(executeSql)) {
				String masterDataId = IdWorker.getId() + "";
				executeSql = "insert into " + masterDataModelEntity.getModelCode();
				String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id,";
				String valueSql = " values("+masterDataId+",now(),1,'"+sourceId+"',";
				for(DataModelItemEntity modelItem:dataModelItemEntities) {
					if("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
						continue;
					}
					String itemCode = modelItem.getItemCode();
					fieldSql += "`"+itemCode + "`,";
					if(StringUtils.isNotBlank(saveData.getString(itemCode))) {
						valueSql += "'"+saveData.getString(itemCode) + "',";
					}else{
						valueSql += "null,";
					}
				}
				fieldSql = fieldSql.substring(0, fieldSql.length()-1);
				valueSql = valueSql.substring(0, valueSql.length()-1);
				fieldSql = fieldSql + ")";
				valueSql = valueSql + ")";
				
				executeSql = executeSql + fieldSql + valueSql;
				saveData.put("masterDataId", masterDataId);
				dataModelItemService.executeInsertSql(executeSql);
			}
		}
		return errorMap;
	}
	
	/**
	 * 插入主数据-灌入数据
	 * 
	 * @return
	 */
	@RequestMapping(value = "/insertOrUpdateMdmData", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> insertOrUpdateMdmData(@RequestBody InsertParam insertParam, HttpServletRequest request) {
		String ticket = request.getHeader("ticket");
		if(StringUtils.isBlank(ticket)) {
			throw new BusinessException("请求头中的ticket不能为空");
		}
		
		QueryWrapper<ThirdSystemEntity> thirdSystemWrapper = new QueryWrapper<>();
		thirdSystemWrapper.eq("system_code", insertParam.getSystemCode());
		ThirdSystemEntity thirdSystemEntity = thirdSystemService.getOne(thirdSystemWrapper);
		if(thirdSystemEntity == null) {
			throw new BusinessException("参数错误：该系统编号未在主数据系统中注册");
		}
		//插入调用日志
		DataTransferLogEntity transferLog = new DataTransferLogEntity();
		transferLog.setId(IdWorker.getId());
		transferLog.setThirdSystemId(thirdSystemEntity.getId());
		transferLog.setCallType("insertOrUpdateMdmData");
		transferLog.setReqTime(new Date());
		transferLog.setReqParams(insertParam.toString());
		transferLog.setRespState("failed");
		dataTransferLogService.saveOrUpdate(transferLog, false);
		
		if(ticket.equals(thirdSystemEntity.getTicket())) {
			JSONObject responseData = new JSONObject();
			//获取主模型
			QueryWrapper<DataModelEntity> masterDataModelWrapper = new QueryWrapper<>();
			masterDataModelWrapper.eq("model_code", insertParam.getDataModelCode());
			DataModelEntity masterDataModelEntity = dataModelService.getOne(masterDataModelWrapper);
			
			//主模型字段
			QueryWrapper<DataModelItemEntity> masterDataModelItemWrapper = new QueryWrapper<>();
			masterDataModelItemWrapper.eq("data_model_id", masterDataModelEntity.getId());
			List<DataModelItemEntity> dataModelItemEntities = dataModelItemService.list(masterDataModelItemWrapper);
			
			//一个数据模型最多只能对应一个数据清洗模型
			QueryWrapper<DataCleanRuleEntity> cleanRuleWrapper = new QueryWrapper<>();
			cleanRuleWrapper.eq("data_model_id", masterDataModelEntity.getId());
			DataCleanRuleEntity dataCleanRuleEntity = dataCleanRuleService.getOne(cleanRuleWrapper);
			
			List<DataCleanRuleDetailEntity> cleanRuleDetailList = null;
			if(dataCleanRuleEntity != null) {
				QueryWrapper<DataCleanRuleDetailEntity> cleanRuleDetailWrapper = new QueryWrapper<>();
				cleanRuleDetailWrapper.eq("rule_id", dataCleanRuleEntity.getId());
				cleanRuleDetailList = dataCleanRuleDetailService.list(cleanRuleDetailWrapper);	
			}
			
			List<JSONObject> saveDatas = insertParam.getSaveData();
			List<Map<String, String>> errorList = new ArrayList<Map<String,String>>();
			List<JSONObject> resultDatas = new ArrayList<>();
			if(saveDatas != null && saveDatas.size() > 0) {
				for(JSONObject saveData:saveDatas) {
					Map<String, String> errorMap = executeInsertMdmData(errorList, masterDataModelEntity, dataModelItemEntities, saveData, cleanRuleDetailList);
					if(errorMap.isEmpty()) {
						QueryWrapper<DataModelEntity> childDataModelWrapper = new QueryWrapper<>();
						childDataModelWrapper.eq("parent_id", masterDataModelEntity.getId());
						List<DataModelEntity> childDataModelList = dataModelService.list(childDataModelWrapper);
						if(childDataModelList != null && childDataModelList.size() > 0) {
							for(DataModelEntity childDataModelEntity:childDataModelList) {
								QueryWrapper<DataModelItemEntity> childMasterDataModelItemWrapper = new QueryWrapper<>();
								childMasterDataModelItemWrapper.eq("data_model_id", childDataModelEntity.getId());
								List<DataModelItemEntity> childDataModelItemEntities = dataModelItemService.list(childMasterDataModelItemWrapper);
								
								JSONArray childList = saveData.getJSONArray(childDataModelEntity.getModelCode());
								if(childList != null && childList.size() > 0) {
									for(int i=0;i<childList.size();i++) {
										JSONObject childSaveData = childList.getJSONObject(i);
										
										QueryWrapper<DataCleanRuleEntity> childCleanRuleWrapper = new QueryWrapper<>();
										cleanRuleWrapper.eq("data_model_id", childDataModelEntity.getId());
										DataCleanRuleEntity childDataCleanRuleEntity = dataCleanRuleService.getOne(childCleanRuleWrapper);
										
										List<DataCleanRuleDetailEntity> childCleanRuleDetailList = null;
										if(childDataCleanRuleEntity != null) {
											QueryWrapper<DataCleanRuleDetailEntity> cleanRuleDetailWrapper = new QueryWrapper<>();
											cleanRuleDetailWrapper.eq("rule_id", childDataCleanRuleEntity.getId());
											childCleanRuleDetailList = dataCleanRuleDetailService.list(cleanRuleDetailWrapper);	
										}
										List<Map<String, String>> childErrorList = new ArrayList<Map<String,String>>();
										executeInsertMdmData(childErrorList, childDataModelEntity, childDataModelItemEntities, childSaveData, childCleanRuleDetailList);
									}
								}
							}
						}
						resultDatas.add(saveData);
					}
				}
			}
			responseData.put(insertParam.getDataModelCode(), resultDatas);
			transferLog.setCallResp(JSON.toJSONString(responseData));
			transferLog.setRespState("ok");
			dataTransferLogService.saveOrUpdate(transferLog, false);
			
			if(errorList.size() > 0) {
				return CommonResponse.error(errorList.toString(), responseData);
			}else{
				return CommonResponse.success(responseData);
			}
			
		}else{
			throw new BusinessException("票据验证不通过");
		}
	}
	
	
	/**
	 * 删除主数据
	 * 
	 * @param deleteParam
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/deleteMdmData", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> deleteMdmData(@RequestBody DeleteParam deleteParam, HttpServletRequest request) {
		String ticket = request.getHeader("ticket");
		if(StringUtils.isBlank(ticket)) {
			throw new BusinessException("请求头中的ticket不能为空");
		}
		
		QueryWrapper<ThirdSystemEntity> thirdSystemWrapper = new QueryWrapper<>();
		thirdSystemWrapper.eq("system_code", deleteParam.getSystemCode());
		ThirdSystemEntity thirdSystemEntity = thirdSystemService.getOne(thirdSystemWrapper);
		if(thirdSystemEntity == null) {
			throw new BusinessException("参数错误：该系统编号未在主数据系统中注册");
		}
		//插入调用日志
		DataTransferLogEntity transferLog = new DataTransferLogEntity();
		transferLog.setId(IdWorker.getId());
		transferLog.setThirdSystemId(thirdSystemEntity.getId());
		transferLog.setCallType("deleteMdmData");
		transferLog.setReqTime(new Date());
		transferLog.setReqParams(deleteParam.toString());
		transferLog.setRespState("failed");
		dataTransferLogService.saveOrUpdate(transferLog, false);
		
		if(ticket.equals(thirdSystemEntity.getTicket())) {
			//获取主模型
			QueryWrapper<DataModelEntity> masterDataModelWrapper = new QueryWrapper<>();
			masterDataModelWrapper.eq("model_code", deleteParam.getDataModelCode());
			DataModelEntity masterDataModelEntity = dataModelService.getOne(masterDataModelWrapper);
			
			List<String> mdmIds = deleteParam.getMdmIds();
			String mdmIdStr = "";
			List<JSONObject> resultDataList = null;
			if(mdmIds != null && mdmIds.size() > 0) {
				for(String mdmId:mdmIds) {
					mdmIdStr += mdmId + ",";
				}
				if(StringUtils.isNotBlank(mdmIdStr)) {
					mdmIdStr = mdmIdStr.substring(0, mdmIdStr.length()-1);
				}
				Map<String, Object> modelItemMap = new HashMap<String, Object>();
				modelItemMap.put("mdmIdStr", mdmIdStr);
				modelItemMap.put("tableName", masterDataModelEntity.getModelCode());
				resultDataList = dataModelItemService.queryMdmDataList(modelItemMap);
				
				if(resultDataList != null && resultDataList.size() > 0) {
					QueryWrapper<DataModelEntity> childDataModelWrapper = new QueryWrapper<>();
					childDataModelWrapper.eq("parent_id", masterDataModelEntity.getId());
					List<DataModelEntity> childDataModelList = dataModelService.list(childDataModelWrapper);
					if(childDataModelList != null && childDataModelList.size() > 0) {
						for(DataModelEntity childModel:childDataModelList) {
							for(JSONObject masterData:resultDataList) {
								Map<String, Object> childParamMap = new HashMap<String, Object>();
								childParamMap.put("parentId", masterData.get("id").toString());
								childParamMap.put("tableName", childModel.getModelCode());
								
								dataModelItemService.deleteChildMdmData(childParamMap);
							}
						}
					}
				}
				dataModelItemService.deleteMasterMdmData(modelItemMap);
				
				transferLog.setRespState("ok");
				dataTransferLogService.saveOrUpdate(transferLog, false);
				
				return CommonResponse.success();
			}else{
				throw new BusinessException("主数据ids不正确");
			}
		}else{
			throw new BusinessException("票据验证不通过");
		}
	}
}
