package com.ejianc.foundation.mdm.controller.sync;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.mdm.bean.DataModelEntity;
import com.ejianc.foundation.mdm.bean.DataModelItemEntity;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjOrgResponseVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjOrgVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjResponseVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjUpdateVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjUserResponseVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjUserVO;
import com.ejianc.foundation.mdm.service.IDataModelItemService;
import com.ejianc.foundation.mdm.service.IDataModelService;
import com.ejianc.foundation.mdm.utils.HttpTookitZzyj;
import com.ejianc.foundation.mdm.utils.ZzyjSyncConfig;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;

@RestController
@RequestMapping("/zzyj/sync")
public class ZzyjSyncController implements Serializable {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final long serialVersionUID = 1L;

	private final String hrHost = "http://hr.zzyjjt.com";
	private final String sysFlag = "EJCCS";
	private final String sysEtoken = "36A208CBD13488C8E51AB0E954D8EF23";

	@Autowired
	private IDataModelService dataModelService;
	@Autowired
	private IDataModelItemService dataModelItemService;

	public String getDateTime() {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return format.format(new Date());
	}

	/**
	 * 组织+部门
	 * 
	 * @return
	 */
	@RequestMapping(value = "/orgs", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> syncOrgs(HttpServletRequest request) {
		ZzyjSyncConfig zzyjSyncConfig = new ZzyjSyncConfig(hrHost, sysFlag, sysEtoken);
		logger.info(">>>>{}>>>>郑州一建宏景HR同步组织数据start...", getDateTime());
		try {
			String resp = HttpTookitZzyj.get(zzyjSyncConfig.getOrgUrl(), request);
			ZzyjOrgResponseVO zzyjOrgResponseVO = JSONObject.parseObject(resp, ZzyjOrgResponseVO.class);

			if (zzyjOrgResponseVO.isSuccess()) {
				logger.info(">>>>{}>>>>接收到郑州一建宏景HR组织数据条数:{},开始解析并进行入库操作...", getDateTime(), CollectionUtils.isNotEmpty(zzyjOrgResponseVO.getData()) ? zzyjOrgResponseVO.getData().size() : 0);
				if (CollectionUtils.isNotEmpty(zzyjOrgResponseVO.getData())) {
					List<ZzyjOrgVO> orgData = zzyjOrgResponseVO.getData();
					List<String> delOrgSourceIds = new ArrayList<>();
					List<String> delDeptSourceIds = new ArrayList<>();
					List<ZzyjUpdateVO> updateVOS = new ArrayList<>();
					if (CollectionUtils.isNotEmpty(orgData)) {
						// 组织、部门排序，先保存组织，再保存部门
						Collections.sort(orgData, (o1, o2) -> {
							int a1 = StringUtils.isNotEmpty(o1.getGrade()) ? Integer.parseInt(o1.getGrade()) : 0;
							int a2 = StringUtils.isNotEmpty(o2.getGrade()) ? Integer.parseInt(o2.getGrade()) : 0;
							return a1 - a2;
						});

						for (ZzyjOrgVO zzyjOrgVO : orgData) {
							boolean success = false;
							// 公司
							if ("UN".equals(zzyjOrgVO.getCodesetid())) {
								success = this.syncOrgVO(zzyjOrgVO, delOrgSourceIds);
							}
							// 部门UM
							else {
								success = this.syncDeptVO(zzyjOrgVO, delDeptSourceIds);
							}
							updateVOS.add(zzyjOrgVO.toUpdateVO(success));
						}
						// 删除公司
						if (CollectionUtils.isNotEmpty(delOrgSourceIds)) {
							String delOrgSourceIdStr = "";
							for(String delOrgSourceId:delOrgSourceIds) {
								delOrgSourceIdStr += "'"+delOrgSourceId+"',";
							}
							delOrgSourceIdStr = delOrgSourceIdStr.substring(0, delOrgSourceIdStr.length()-1);
							dataModelItemService.deleteMdmDataBySourceIds("orgmodel", delOrgSourceIdStr);
						}
						// 删除部门
						if (CollectionUtils.isNotEmpty(delDeptSourceIds)) {
							String delDeptSourceIdStr = "";
							for(String delDeptSourceId:delOrgSourceIds) {
								delDeptSourceIdStr += "'"+delDeptSourceId+"',";
							}
							delDeptSourceIdStr = delDeptSourceIdStr.substring(0, delDeptSourceIdStr.length()-1);
							dataModelItemService.deleteMdmDataBySourceIds("deptmodel", delDeptSourceIdStr);
						}

						// 回写一建同步成功标志
//						CommonResponse<ZzyjResponseVO> zzyjResponseVOCommonResponse = this.callBackUpdateInfo(ZzyjSyncConfig.ORG, updateVOS);
//						if (!zzyjResponseVOCommonResponse.isSuccess()) {
//							logger.info("郑州一建同步组织更新返回ERRORERRORERRORERRORERRORERROR:{}", zzyjResponseVOCommonResponse.getMsg());
//							return CommonResponse.error(zzyjResponseVOCommonResponse.getMsg());
//						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return CommonResponse.success(">>>>" + getDateTime() + ">>>>郑州一建同步宏景HR系统组织执行完毕!");
	}

	/**
	 * 人员同步
	 * 
	 * @return
	 */
	@RequestMapping(value = "/users")
	@ResponseBody
	public CommonResponse<String> syncUsers(HttpServletRequest request) {
		ZzyjSyncConfig zzyjSyncConfig = new ZzyjSyncConfig(hrHost, sysFlag, sysEtoken);
		logger.info(">>>>{}>>>>郑州一建宏景HR同步人员数据start...", getDateTime());
		try {
			String resp = HttpTookitZzyj.get(zzyjSyncConfig.getUserUrl(), request);
			ZzyjUserResponseVO zzyjUserResponseVO = JSONObject.parseObject(resp, ZzyjUserResponseVO.class);

			if (zzyjUserResponseVO.isSuccess()) {
				logger.info(">>>>{}>>>>接收到郑州一建宏景HR人员数据条数:{},开始解析并进行入库操作...", getDateTime(), CollectionUtils.isNotEmpty(zzyjUserResponseVO.getData()) ? zzyjUserResponseVO.getData().size() : 0);
				if (CollectionUtils.isNotEmpty(zzyjUserResponseVO.getData())) {
					List<String> delUserSourceIds = new ArrayList<>();
			        List<ZzyjUpdateVO> updateVOS = new ArrayList<>();
			        
			        QueryWrapper<DataModelEntity> masterDataModelWrapper = new QueryWrapper<>();
					masterDataModelWrapper.eq("model_code", "employeemodel");
					DataModelEntity dataModelEntity = dataModelService.getOne(masterDataModelWrapper);
					// 主模型字段
					QueryWrapper<DataModelItemEntity> masterDataModelItemWrapper = new QueryWrapper<>();
					masterDataModelItemWrapper.eq("data_model_id", dataModelEntity.getId());
					List<DataModelItemEntity> dataModelItemEntities = dataModelItemService.list(masterDataModelItemWrapper);
					
			        for (ZzyjUserVO syncVO : zzyjUserResponseVO.getData()) {
			        	if ("3".equals(syncVO.getEjccs())) {
			                delUserSourceIds.add(syncVO.getUnique_id());
			                updateVOS.add(syncVO.toUpdateVO(true));
			                continue;
			            }
			        	//查询所属组织
			        	JSONObject orgEntity = dataModelItemService.getObjectBySqlCondition("orgmodel", " and code='"+syncVO.getB0110_0()+"'");
			        	//查询所属部门
			        	JSONObject deptEntity = dataModelItemService.getObjectBySqlCondition("deptmodel", " and code='"+syncVO.getE0122_0()+"'");
			        	if(deptEntity != null) {
			        		if(orgEntity == null) {
			        			orgEntity = dataModelItemService.getObjectBySqlCondition("orgmodel", " and _master_data_id='"+deptEntity.getString("orgId")+"'");
			        		}
			        	}
			        	
			        	JSONObject employeeJson = syncVO.toEmployeeVO();
			        	JSONObject employeeObj = dataModelItemService.queryDataBySourceId("employeemodel", employeeJson.getString("sourceId"));
			        	String executeSql = "";
			        	if(employeeObj != null) { //修改
			        		String empOrgId = employeeObj.getString("orgId");
			        		String empDeptId = employeeObj.getString("deptId");
			        		
			        		employeeObj.put("userCode", employeeJson.getString("userCode"));
			        		employeeObj.put("mobilePhone", employeeJson.getString("mobilePhone"));
			        		employeeObj.put("employeeCode", employeeJson.getString("employeeCode"));
			        		employeeObj.put("employeeName", employeeJson.getString("employeeName"));
			        		employeeObj.put("orgId", orgEntity.getString("_master_data_id"));
			        		employeeObj.put("orgCode", employeeJson.getString("orgCode"));
			        		employeeObj.put("orgName", employeeJson.getString("orgName"));
			        		employeeObj.put("deptId", deptEntity != null ? deptEntity.getString("_master_data_id") : "");
			        		employeeObj.put("deptCode", employeeJson.getString("deptCode"));
			        		employeeObj.put("deptName", employeeJson.getString("deptName"));
			        		employeeObj.put("sex", employeeJson.getString("sex"));
			        		employeeObj.put("email", employeeJson.getString("email"));
			        		employeeObj.put("idCard", employeeJson.getString("idCard"));
			        		employeeObj.put("telephone", employeeJson.getString("telephone"));
			        		
			        		executeSql += "update employeemodel set _last_update_time = now(),_data_type=2,";
							for (DataModelItemEntity modelItem : dataModelItemEntities) {
								if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
									continue;
								}
								if(StringUtils.isNotBlank(employeeObj.getString(modelItem.getItemCode()))) {
									executeSql += "`" + modelItem.getItemCode() + "`='" + employeeObj.getString(modelItem.getItemCode()) + "',";
								}else{
									executeSql += "`" + modelItem.getItemCode() + "`=null,";
								}
							}
							executeSql = executeSql.substring(0, executeSql.length() - 1);
							executeSql += " where _source_id='" + employeeJson.getString("sourceId") + "'";

							dataModelItemService.executeUpdateSql(executeSql);
							
							//查询该人的主职信息
							boolean isMoveJob = false;
							if(StringUtils.isNotBlank(empOrgId) && !empOrgId.equals(orgEntity.getString("_master_data_id"))) {
								isMoveJob = true;
							}else{
								if(StringUtils.isNotBlank(empDeptId) && !empDeptId.equals(deptEntity.getString("_master_data_id"))) {
									isMoveJob = true;
								}
							}
							if(isMoveJob) {
								//更改之前的任职状态为调出
								String updatePreJobState = "update jobmodel set curState = 1,job_end_time=now(),_last_update_time=now(),_data_type=2 where employee_id='"+employeeObj.getString("_master_data_id")+"' and property = 1 and curState = 0 and org_id = '" + employeeObj.getString("orgId")+"'";
								dataModelItemService.executeUpdateSql(updatePreJobState);
								//新增的心得任职
								String pkId = IdWorker.getId()+"";
								String insertNewJobSql = "insert into jobmodel(_master_data_id,_last_update_time,_data_type,_source_id,orgId,orgCode,orgName,deptId,deptCode,deptName,jobStartTime,curState,property) values";
								insertNewJobSql+= "("+pkId+",now(),1,"+pkId+",'"+empOrgId+"','"+orgEntity.getString("code")+"','"+orgEntity.getString("name")+"','"+(deptEntity!=null?deptEntity.getString("_master_data_id"):"")+"','"+(deptEntity!=null?deptEntity.getString("code"):"")+"','"+(deptEntity!=null?deptEntity.getString("name"):"")+"',now(),0,1)";
								dataModelItemService.executeInsertSql(insertNewJobSql);
							}
			        	}
			        	
			        	if(StringUtils.isBlank(executeSql)) {
			        		if(orgEntity != null) {
			        			employeeJson.put("orgId", orgEntity.getString("_master_data_id"));
			        		}
			        		if(deptEntity != null) {
			        			employeeJson.put("deptId", deptEntity.getString("_master_data_id"));
			        		}
			        		Long employeeId = IdWorker.getId();
			        		executeSql = "insert into employeemodel";
							String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id,";
							String valueSql = " values(" + employeeId + ",now(),1,'" + employeeJson.getString("sourceId") + "',";
							for (DataModelItemEntity modelItem : dataModelItemEntities) {
								if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
									continue;
								}
								String itemCode = modelItem.getItemCode();
								fieldSql += "`" + itemCode + "`,";
								if(StringUtils.isNotBlank(employeeJson.getString(itemCode))) {
									valueSql += "'" + employeeJson.getString(itemCode) + "',";
								}else{
									valueSql += "null,";
								}
							}
							fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
							valueSql = valueSql.substring(0, valueSql.length() - 1);
							fieldSql = fieldSql + ")";
							valueSql = valueSql + ")";

							executeSql = executeSql + fieldSql + valueSql;
							dataModelItemService.executeInsertSql(executeSql);
							
							String pkId = IdWorker.getId()+"";
							String insertNewJobSql = "insert into jobmodel(_master_data_id,_last_update_time,_data_type,_source_id,_parent_id,orgId,orgCode,orgName,deptId,deptCode,deptName,jobStartTime,curState,property) values";
							insertNewJobSql+= "("+pkId+",now(),1,"+pkId+","+employeeId+",'"+orgEntity.getString("_master_data_id")+"','"+orgEntity.getString("code")+"','"+orgEntity.getString("name")+"','"+(deptEntity!=null?deptEntity.getString("_master_data_id"):"")+"','"+(deptEntity!=null?deptEntity.getString("code"):"")+"','"+(deptEntity!=null?deptEntity.getString("name"):"")+"',now(),0,1)";
							dataModelItemService.executeInsertSql(insertNewJobSql);
			        	}
			        	
			        	updateVOS.add(syncVO.toUpdateVO(true));
					}
			        
			       // 删除人员
					if (CollectionUtils.isNotEmpty(delUserSourceIds)) {
						String delUserSourceIdStr = "";
						for(String delUserSourceId:delUserSourceIds) {
							delUserSourceIdStr += "'"+delUserSourceId+"',";
						}
						delUserSourceIdStr = delUserSourceIdStr.substring(0, delUserSourceIdStr.length()-1);
						dataModelItemService.deleteMdmDataBySourceIds("employeemodel", delUserSourceIdStr);
					}

					// 回写一建同步成功标志
//					CommonResponse<ZzyjResponseVO> zzyjResponseVOCommonResponse = this.callBackUpdateInfo(ZzyjSyncConfig.ORG, updateVOS);
//					if (!zzyjResponseVOCommonResponse.isSuccess()) {
//						logger.info("郑州一建同步组织更新返回ERRORERRORERRORERRORERRORERROR:{}", zzyjResponseVOCommonResponse.getMsg());
//						return CommonResponse.error(zzyjResponseVOCommonResponse.getMsg());
//					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return CommonResponse.success(">>>>" + getDateTime() + ">>>>郑州一建同步宏景HR系统人员执行完毕!");
	}

	// 会写郑州一建
	private CommonResponse<ZzyjResponseVO> callBackUpdateInfo(String type, List<ZzyjUpdateVO> zzyjUpdateVOS) {
		ZzyjSyncConfig zzyjSyncConfig = new ZzyjSyncConfig(hrHost, sysFlag, sysEtoken);
		String jsonString = JSONObject.toJSONString(zzyjUpdateVOS);
		try {
			String updStr = HttpTookitZzyj.postParameters(zzyjSyncConfig.getUpdateUrl(), zzyjSyncConfig.getUpdateParam(type, jsonString));
			ZzyjResponseVO zzyjResponseVO = JSONObject.parseObject(updStr, ZzyjResponseVO.class);
			if (!zzyjResponseVO.isSuccess()) {
				logger.info(">>>>>>回写郑州一建更新标识失败:" + zzyjResponseVO.getMsg());
				return CommonResponse.error(zzyjResponseVO.getMsg());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		logger.info(">>>>>>回写郑州一建" + type + "信息完毕!");
		return CommonResponse.success(">>>>>>回写郑州一建" + type + "信息完毕!");
	}

	private boolean syncOrgVO(ZzyjOrgVO zzyjOrgVO, List<String> delOrgSourceIds) {
		JSONObject orgJson = zzyjOrgVO.toOrgVO();
		if ("3".equals(zzyjOrgVO.getEjccs())) {
			delOrgSourceIds.add(zzyjOrgVO.getUnique_id());
			return true;
		} else {
			JSONObject orgObj = dataModelItemService.queryDataBySourceId("orgmodel", orgJson.getString("sourceId"));
			String masterDataId = "";
			if (orgObj == null) {
				masterDataId = IdWorker.getId() + "";
			} else {
				masterDataId = orgObj.getString("_master_data_id");
			}

			String innerCode = "";
			String parentId = "";
			if (StringUtils.isNotEmpty(zzyjOrgVO.getParentid()) && !zzyjOrgVO.getParentid().equals(zzyjOrgVO.getB0110_0())) {
				JSONObject orgEntity = dataModelItemService.getObjectBySqlCondition("orgmodel", "and code='" + zzyjOrgVO.getParentid()+"'");
				if (orgEntity != null) {
					innerCode = orgEntity.getString("innerCode") + "|" + masterDataId;
					parentId = orgEntity.getString("_master_data_id");
				} else {
					innerCode = masterDataId;
				}
			} else {
				innerCode = masterDataId;
			}
			QueryWrapper<DataModelEntity> masterDataModelWrapper = new QueryWrapper<>();
			masterDataModelWrapper.eq("model_code", "orgmodel");
			DataModelEntity dataModelEntity = dataModelService.getOne(masterDataModelWrapper);
			// 主模型字段
			QueryWrapper<DataModelItemEntity> masterDataModelItemWrapper = new QueryWrapper<>();
			masterDataModelItemWrapper.eq("data_model_id", dataModelEntity.getId());
			List<DataModelItemEntity> dataModelItemEntities = dataModelItemService.list(masterDataModelItemWrapper);

			String executeSql = "";
			if (orgObj != null) {
				orgObj.put("name", orgJson.getString("name"));
				orgObj.put("shortName", orgJson.getString("shortName"));
				orgObj.put("orgType", orgJson.getString("orgType"));
				orgObj.put("innerCode", innerCode);
				orgObj.put("parentId", parentId);
				orgObj.put("sequence", orgJson.getString("sequence"));
				orgObj.put("telephone", orgJson.getString("telephone"));

				executeSql += "update orgmodel set _last_update_time = now(),_data_type=2,";
				for (DataModelItemEntity modelItem : dataModelItemEntities) {
					if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
						continue;
					}
					if(StringUtils.isNotBlank(orgObj.getString(modelItem.getItemCode()))) {
						executeSql += "`" + modelItem.getItemCode() + "`='" + (orgObj.getString(modelItem.getItemCode())!=null?orgObj.getString(modelItem.getItemCode()):"") + "',";
					}else{
						executeSql += "`" + modelItem.getItemCode() + "`=null,";
					}
				}
				executeSql = executeSql.substring(0, executeSql.length() - 1);
				executeSql += " where _source_id='" + orgJson.getString("sourceId") + "'";

				dataModelItemService.executeUpdateSql(executeSql);
			}

			if (StringUtils.isBlank(executeSql)) {
				orgJson.put("innerCode", innerCode);
				orgJson.put("parentId", parentId);

				executeSql = "insert into orgmodel";
				String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id,enabled ";
				String valueSql = " values(" + IdWorker.getId() + ",now(),1,'" + orgJson.getString("sourceId") + "','启用' ";
				for (DataModelItemEntity modelItem : dataModelItemEntities) {
					if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
						continue;
					}
					String itemCode = modelItem.getItemCode();
					fieldSql += "`" + itemCode + "`,";
					if(StringUtils.isNotBlank(orgJson.getString(itemCode))) {
						valueSql += "'" + (orgJson.getString(itemCode)!=null?orgJson.getString(itemCode):"") + "',";
					}else{
						valueSql += "null,";
					}
				}
				fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
				valueSql = valueSql.substring(0, valueSql.length() - 1);
				fieldSql = fieldSql + ")";
				valueSql = valueSql + ")";

				executeSql = executeSql + fieldSql + valueSql;
				dataModelItemService.executeInsertSql(executeSql);
			}
			return true;
		}
	}

	private boolean syncDeptVO(ZzyjOrgVO zzyjOrgVO, List<String> delDeptSourceIds) {
		JSONObject deptJson = zzyjOrgVO.toDeptVO();
		if("3".equals(zzyjOrgVO.getEjccs())) {
			delDeptSourceIds.add(zzyjOrgVO.getUnique_id());
            return true;
		}else{
			JSONObject deptObj = dataModelItemService.queryDataBySourceId("deptmodel", deptJson.getString("sourceId"));
			String masterDataId = "";
			if (deptObj == null) {
				masterDataId = IdWorker.getId() + "";
			} else {
				masterDataId = deptObj.getString("_master_data_id");
			}

			String innerCode = "";
			String parentId = "";
			if (StringUtils.isNotEmpty(zzyjOrgVO.getParentid()) && !zzyjOrgVO.getParentid().equals(zzyjOrgVO.getB0110_0())) {
				JSONObject deptEntity = dataModelItemService.getObjectBySqlCondition("deptmodel", "and code='" + zzyjOrgVO.getParentid()+"'");
				if (deptEntity != null) {
					innerCode = deptEntity.getString("innerCode") + "|" + masterDataId;
					parentId = deptEntity.getString("_master_data_id");
				} else {
					innerCode = masterDataId;
				}
			} else {
				innerCode = masterDataId;
			}
			QueryWrapper<DataModelEntity> masterDataModelWrapper = new QueryWrapper<>();
			masterDataModelWrapper.eq("model_code", "deptmodel");
			DataModelEntity dataModelEntity = dataModelService.getOne(masterDataModelWrapper);
			// 主模型字段
			QueryWrapper<DataModelItemEntity> masterDataModelItemWrapper = new QueryWrapper<>();
			masterDataModelItemWrapper.eq("data_model_id", dataModelEntity.getId());
			List<DataModelItemEntity> dataModelItemEntities = dataModelItemService.list(masterDataModelItemWrapper);

			String executeSql = "";
			if (deptObj != null) {
				deptObj.put("name", deptJson.getString("name"));
				deptObj.put("shortName", deptJson.getString("shortName"));
				deptObj.put("sequence", deptJson.getString("sequence"));
				deptObj.put("telephone", deptJson.getString("telephone"));

				executeSql += "update deptmodel set _last_update_time = now(),_data_type=2,";
				for (DataModelItemEntity modelItem : dataModelItemEntities) {
					if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
						continue;
					}
					if(StringUtils.isNotBlank(deptObj.getString(modelItem.getItemCode()))) {
						executeSql += "`" + modelItem.getItemCode() + "`='" + (deptObj.getString(modelItem.getItemCode())!=null?deptObj.getString(modelItem.getItemCode()):"") + "',";
					}else{
						executeSql += "`" + modelItem.getItemCode() + "`=null,";
					}
				}
				executeSql = executeSql.substring(0, executeSql.length() - 1);
				executeSql += " where _source_id='" + deptJson.getString("sourceId") + "'";

				dataModelItemService.executeUpdateSql(executeSql);
			}

			if (StringUtils.isBlank(executeSql)) {
				deptJson.put("innerCode", innerCode);
				deptJson.put("parentId", parentId);

				executeSql = "insert into deptmodel";
				String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id,";
				String valueSql = " values(" + IdWorker.getId() + ",now(),1,'" + deptJson.getString("sourceId") + "',";
				for (DataModelItemEntity modelItem : dataModelItemEntities) {
					if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
						continue;
					}
					String itemCode = modelItem.getItemCode();
					fieldSql += "`" + itemCode + "`,";
					if(StringUtils.isNotBlank(deptJson.getString(itemCode))) {
						valueSql += "'" + (deptJson.getString(itemCode)!=null?deptJson.getString(itemCode):"") + "',";
					}else{
						valueSql += "null,";
					}
				}
				fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
				valueSql = valueSql.substring(0, valueSql.length() - 1);
				fieldSql = fieldSql + ")";
				valueSql = valueSql + ")";

				executeSql = executeSql + fieldSql + valueSql;
				dataModelItemService.executeInsertSql(executeSql);
			}
			return true;
		}
	}

}
