/**
 * Copyright 2022 json.cn
 */
package com.ejianc.foundation.mdm.controller.sync.vo;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * ZzyjOrgVO
 */
public class ZzyjOrgVO implements Serializable {

	private static final long serialVersionUID = 1L;

	private String codesetid;
	private String parentdesc;
	private String parentguidkey;
	private String origincodeitemid;
	private String parentid;
	private String unique_id;
	private String sys_flag;
	private String flag;
	private String levela0000;
	private String d0104;
	private String b0110;
	private String morrowsoft;
	private String b0110_0;
	private String grade;
	private String corcode;
	private String codeitemdesc;
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date sdate;
	private String a0000;
	private String b0125;

	private String ejc;

	private String ejccs;

	public String getEjc() {
		return ejc;
	}

	public void setEjc(String ejc) {
		this.ejc = ejc;
	}

	public String getEjccs() {
		return ejccs;
	}

	public void setEjccs(String ejccs) {
		this.ejccs = ejccs;
	}

	public void setCodesetid(String codesetid) {
		this.codesetid = codesetid;
	}

	public String getCodesetid() {
		return codesetid;
	}

	public void setParentdesc(String parentdesc) {
		this.parentdesc = parentdesc;
	}

	public String getParentdesc() {
		return parentdesc;
	}

	public void setParentguidkey(String parentguidkey) {
		this.parentguidkey = parentguidkey;
	}

	public String getParentguidkey() {
		return parentguidkey;
	}

	public void setOrigincodeitemid(String origincodeitemid) {
		this.origincodeitemid = origincodeitemid;
	}

	public String getOrigincodeitemid() {
		return origincodeitemid;
	}

	public void setParentid(String parentid) {
		this.parentid = parentid;
	}

	public String getParentid() {
		return parentid;
	}

	public void setUnique_id(String unique_id) {
		this.unique_id = unique_id;
	}

	public String getUnique_id() {
		return unique_id;
	}

	public void setSys_flag(String sys_flag) {
		this.sys_flag = sys_flag;
	}

	public String getSys_flag() {
		return sys_flag;
	}

	public void setFlag(String flag) {
		this.flag = flag;
	}

	public String getFlag() {
		return flag;
	}

	public void setLevela0000(String levela0000) {
		this.levela0000 = levela0000;
	}

	public String getLevela0000() {
		return levela0000;
	}

	public void setD0104(String d0104) {
		this.d0104 = d0104;
	}

	public String getD0104() {
		return d0104;
	}

	public void setB0110(String b0110) {
		this.b0110 = b0110;
	}

	public String getB0110() {
		return b0110;
	}

	public void setMorrowsoft(String morrowsoft) {
		this.morrowsoft = morrowsoft;
	}

	public String getMorrowsoft() {
		return morrowsoft;
	}

	public void setB0110_0(String b0110_0) {
		this.b0110_0 = b0110_0;
	}

	public String getB0110_0() {
		return b0110_0;
	}

	public void setGrade(String grade) {
		this.grade = grade;
	}

	public String getGrade() {
		return grade;
	}

	public void setCorcode(String corcode) {
		this.corcode = corcode;
	}

	public String getCorcode() {
		return corcode;
	}

	public void setCodeitemdesc(String codeitemdesc) {
		this.codeitemdesc = codeitemdesc;
	}

	public String getCodeitemdesc() {
		return codeitemdesc;
	}

	public void setSdate(Date sdate) {
		this.sdate = sdate;
	}

	public Date getSdate() {
		return sdate;
	}

	public void setA0000(String a0000) {
		this.a0000 = a0000;
	}

	public String getA0000() {
		return a0000;
	}

	public String getB0125() {
		return b0125;
	}

	public void setB0125(String b0125) {
		this.b0125 = b0125;
	}

	public ZzyjUpdateVO toUpdateVO(boolean isSucc) {
		return new ZzyjUpdateVO(this.unique_id, this.ejccs, isSucc);
	}

	public JSONObject toOrgVO() {
		JSONObject orgObject = new JSONObject();
		orgObject.put("code", this.getB0110_0());// 组织编号
		orgObject.put("sourceId", this.getUnique_id());// 来源id
		orgObject.put("name", this.getCodeitemdesc()); // 组织名称
		orgObject.put("shortName", this.getCodeitemdesc()); // 组织简称
		orgObject.put("state", 1);
		orgObject.put("sequence", this.getA0000());
		orgObject.put("telephone", this.getB0125());
		// 公司类型
		// 益企联------1：集团 ， 2：分（子）公司，3：经理部，4：虚拟组织，5：项目部
		if ("1".equals(this.getB0110_0())) {
			orgObject.put("orgType", "集团");
		} else if ("2".equals(this.getGrade())) {
			orgObject.put("orgType", "虚拟组织");
		} else if (StringUtils.isNotEmpty(this.getB0110_0()) && this.getB0110_0().startsWith("104")) {
			orgObject.put("orgType", "经理部");
		} else {
			orgObject.put("orgType", "分（子）公司");
		}
		return orgObject;
	}

	public JSONObject toDeptVO() {
		JSONObject deptObject = new JSONObject();
		deptObject.put("code", this.getB0110_0()); // 部门编码
		deptObject.put("sourceId", this.getUnique_id()); // 来源ID
		deptObject.put("name", this.getCodeitemdesc()); // 部门名称
		deptObject.put("shortName", this.getCodeitemdesc()); // 部门简称
		deptObject.put("state", 1);
		deptObject.put("type", 1);
		deptObject.put("sequence", this.getA0000());
		deptObject.put("telephone", this.getB0125());
		return deptObject;
	}
}