package com.ejianc.foundation.mdm.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.mdm.bean.DataModelItemEntity;

public class MdmUtils {
	
	public static void parseJSONObject(List<JSONObject> resultDataList, List<DataModelItemEntity> modelItemList) {
		if(resultDataList != null && resultDataList.size() > 0) {
			for(JSONObject resultData:resultDataList) {
				if(modelItemList != null && modelItemList.size() > 0) {
					for(DataModelItemEntity modelItem:modelItemList) {
						if("datetime".equals(modelItem.getDataType()) || "date".equals(modelItem.getDataType())) {
							String timestr = resultData.getString(modelItem.getItemCode());
							SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
							try {
								String str = format.format(format.parse(timestr));
								resultData.put(modelItem.getItemCode(), str);
							} catch (ParseException e) {
								resultData.put(modelItem.getItemCode(), timestr);
							}
						}
					}
				}
				
				String timestr = resultData.getString("_last_update_time");
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				try {
					String str = format.format(format.parse(timestr));
					resultData.put("_last_update_time", str);
				} catch (ParseException e) {
					resultData.put("_last_update_time", timestr);
				}
			}
		}
	}
}
