/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.mdm.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.mdm.bean.DataCleanRuleDetailEntity;
import com.ejianc.foundation.mdm.bean.DataCleanRuleEntity;
import com.ejianc.foundation.mdm.bean.DataModelEntity;
import com.ejianc.foundation.mdm.bean.DataModelItemEntity;
import com.ejianc.foundation.mdm.bean.DataTransferLogEntity;
import com.ejianc.foundation.mdm.bean.ThirdSystemEntity;
import com.ejianc.foundation.mdm.param.DeleteParam;
import com.ejianc.foundation.mdm.param.InsertParam;
import com.ejianc.foundation.mdm.param.ListByIdsParam;
import com.ejianc.foundation.mdm.param.ListParam;
import com.ejianc.foundation.mdm.service.IDataCleanRuleDetailService;
import com.ejianc.foundation.mdm.service.IDataCleanRuleService;
import com.ejianc.foundation.mdm.service.IDataModelItemService;
import com.ejianc.foundation.mdm.service.IDataModelService;
import com.ejianc.foundation.mdm.service.IDataTransferLogService;
import com.ejianc.foundation.mdm.service.IThirdSystemService;
import com.ejianc.foundation.mdm.utils.MdmUtils;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.Validate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/mdm/"})
public class MdmApiController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IThirdSystemService thirdSystemService;
    @Autowired
    private IDataModelService dataModelService;
    @Autowired
    private IDataModelItemService dataModelItemService;
    @Autowired
    private IDataTransferLogService dataTransferLogService;
    @Autowired
    private IDataCleanRuleService dataCleanRuleService;
    @Autowired
    private IDataCleanRuleDetailService dataCleanRuleDetailService;

    @RequestMapping(value={"/queryListByMdmIds"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryListByMdmIds(@RequestBody ListByIdsParam listByIdsParam, HttpServletRequest request) {
        QueryWrapper thirdSystemWrapper = new QueryWrapper();
        thirdSystemWrapper.eq((Object)"system_code", (Object)listByIdsParam.getSystemCode());
        ThirdSystemEntity thirdSystemEntity = (ThirdSystemEntity)((Object)this.thirdSystemService.getOne((Wrapper)thirdSystemWrapper));
        if (thirdSystemEntity == null) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef\uff1a\u8be5\u7cfb\u7edf\u7f16\u53f7\u672a\u5728\u4e3b\u6570\u636e\u7cfb\u7edf\u4e2d\u6ce8\u518c");
        }
        DataTransferLogEntity transferLog = new DataTransferLogEntity();
        transferLog.setId(IdWorker.getId());
        transferLog.setThirdSystemId(thirdSystemEntity.getId());
        transferLog.setCallType("queryListByMdmIds");
        transferLog.setReqTime(new Date());
        transferLog.setReqParams(listByIdsParam.toString());
        transferLog.setRespState("failed");
        this.dataTransferLogService.saveOrUpdate((Object)transferLog, false);
        JSONObject responseData = new JSONObject();
        QueryWrapper masterDataModelWrapper = new QueryWrapper();
        masterDataModelWrapper.eq((Object)"model_code", (Object)listByIdsParam.getDataModelCode());
        DataModelEntity masterDataModelEntity = (DataModelEntity)((Object)this.dataModelService.getOne((Wrapper)masterDataModelWrapper));
        List mdmIds = listByIdsParam.getMdmIds();
        String mdmIdStr = "";
        List<JSONObject> resultDataList = null;
        if (mdmIds != null && mdmIds.size() > 0) {
            for (String mdmId : mdmIds) {
                mdmIdStr = mdmIdStr + mdmId + ",";
            }
            if (StringUtils.isNotBlank((CharSequence)mdmIdStr)) {
                mdmIdStr = mdmIdStr.substring(0, mdmIdStr.length() - 1);
            }
            HashMap<String, Object> modelItemMap = new HashMap<String, Object>();
            modelItemMap.put("mdmIdStr", mdmIdStr);
            modelItemMap.put("tableName", masterDataModelEntity.getModelCode());
            resultDataList = this.dataModelItemService.queryMdmDataList(modelItemMap);
            QueryWrapper masterDataModelItemWrapper = new QueryWrapper();
            masterDataModelItemWrapper.eq((Object)"data_model_id", (Object)masterDataModelEntity.getId());
            List dataModelItemEntities = this.dataModelItemService.list((Wrapper)masterDataModelItemWrapper);
            MdmUtils.parseJSONObject(resultDataList, dataModelItemEntities);
            if (resultDataList != null && resultDataList.size() > 0) {
                QueryWrapper childDataModelWrapper = new QueryWrapper();
                childDataModelWrapper.eq((Object)"parent_id", (Object)masterDataModelEntity.getId());
                List childDataModelList = this.dataModelService.list((Wrapper)childDataModelWrapper);
                if (childDataModelList != null && childDataModelList.size() > 0) {
                    for (DataModelEntity childModel : childDataModelList) {
                        QueryWrapper childDataModelItemWrapper = new QueryWrapper();
                        childDataModelItemWrapper.eq((Object)"data_model_id", (Object)childModel.getId());
                        List childDataModelItemEntities = this.dataModelItemService.list((Wrapper)childDataModelItemWrapper);
                        for (JSONObject masterData : resultDataList) {
                            HashMap<String, Object> childParamMap = new HashMap<String, Object>();
                            childParamMap.put("parentId", masterData.get((Object)"_master_data_id").toString());
                            childParamMap.put("tableName", childModel.getModelCode());
                            List<JSONObject> childDataList = this.dataModelItemService.queryMdmChildDataList(childParamMap);
                            MdmUtils.parseJSONObject(childDataList, childDataModelItemEntities);
                            masterData.put(childModel.getModelCode(), childDataList);
                        }
                    }
                }
            }
            responseData.put(masterDataModelEntity.getModelCode(), resultDataList);
            transferLog.setCallResp(JSON.toJSONString((Object)responseData));
            transferLog.setRespState("ok");
            this.dataTransferLogService.saveOrUpdate((Object)transferLog, false);
            return CommonResponse.success((Object)responseData);
        }
        throw new BusinessException("\u4e3b\u6570\u636eids\u4e0d\u6b63\u786e");
    }

    @RequestMapping(value={"/queryListByConditions"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryListByConditions(@RequestBody ListParam listParam, HttpServletRequest request) {
        QueryWrapper thirdSystemWrapper = new QueryWrapper();
        thirdSystemWrapper.eq((Object)"system_code", (Object)listParam.getSystemCode());
        ThirdSystemEntity thirdSystemEntity = (ThirdSystemEntity)((Object)this.thirdSystemService.getOne((Wrapper)thirdSystemWrapper));
        if (thirdSystemEntity == null) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef\uff1a\u8be5\u7cfb\u7edf\u7f16\u53f7\u672a\u5728\u4e3b\u6570\u636e\u7cfb\u7edf\u4e2d\u6ce8\u518c");
        }
        DataTransferLogEntity transferLog = new DataTransferLogEntity();
        transferLog.setId(IdWorker.getId());
        transferLog.setThirdSystemId(thirdSystemEntity.getId());
        transferLog.setCallType("queryListByConditions");
        transferLog.setReqTime(new Date());
        transferLog.setReqParams(listParam.toString());
        transferLog.setRespState("failed");
        this.dataTransferLogService.saveOrUpdate((Object)transferLog, false);
        JSONObject responseData = new JSONObject();
        QueryWrapper masterDataModelWrapper = new QueryWrapper();
        masterDataModelWrapper.eq((Object)"model_code", (Object)listParam.getDataModelCode());
        DataModelEntity masterDataModelEntity = (DataModelEntity)((Object)this.dataModelService.getOne((Wrapper)masterDataModelWrapper));
        HashMap<String, Object> modelItemMap = new HashMap<String, Object>();
        if (-1 != listParam.getPageIndex()) {
            modelItemMap.put("pageIndex", listParam.getPageIndex() == null ? 0 : listParam.getPageIndex());
            modelItemMap.put("pageSize", listParam.getPageSize() == null ? 500 : listParam.getPageSize());
        }
        modelItemMap.put("lastUpdateTime", listParam.getLastUpdateTime());
        modelItemMap.put("tableName", masterDataModelEntity.getModelCode());
        List<JSONObject> resultDataList = this.dataModelItemService.queryMdmDataList(modelItemMap);
        Long dataTotal = this.dataModelItemService.queryMdmDataCount(modelItemMap);
        QueryWrapper masterDataModelItemWrapper = new QueryWrapper();
        masterDataModelItemWrapper.eq((Object)"data_model_id", (Object)masterDataModelEntity.getId());
        List dataModelItemEntities = this.dataModelItemService.list((Wrapper)masterDataModelItemWrapper);
        MdmUtils.parseJSONObject(resultDataList, dataModelItemEntities);
        if (resultDataList != null && resultDataList.size() > 0) {
            QueryWrapper childDataModelWrapper = new QueryWrapper();
            childDataModelWrapper.eq((Object)"parent_id", (Object)masterDataModelEntity.getId());
            List childDataModelList = this.dataModelService.list((Wrapper)childDataModelWrapper);
            if (childDataModelList != null && childDataModelList.size() > 0) {
                for (DataModelEntity childModel : childDataModelList) {
                    QueryWrapper childDataModelItemWrapper = new QueryWrapper();
                    childDataModelItemWrapper.eq((Object)"data_model_id", (Object)childModel.getId());
                    List childDataModelItemEntities = this.dataModelItemService.list((Wrapper)childDataModelItemWrapper);
                    for (JSONObject masterData : resultDataList) {
                        HashMap<String, Object> childParamMap = new HashMap<String, Object>();
                        childParamMap.put("parentId", masterData.get((Object)"_master_data_id").toString());
                        childParamMap.put("tableName", childModel.getModelCode());
                        List<JSONObject> childDataList = this.dataModelItemService.queryMdmChildDataList(childParamMap);
                        MdmUtils.parseJSONObject(childDataList, childDataModelItemEntities);
                        masterData.put(childModel.getModelCode(), childDataList);
                    }
                }
            }
        }
        responseData.put("total", (Object)dataTotal);
        responseData.put(masterDataModelEntity.getModelCode(), resultDataList);
        transferLog.setCallResp(JSON.toJSONString((Object)responseData));
        transferLog.setRespState("ok");
        this.dataTransferLogService.saveOrUpdate((Object)transferLog, false);
        return CommonResponse.success((Object)responseData);
    }

    private Map<String, String> executeInsertMdmData(List<Map<String, String>> errorList, DataModelEntity masterDataModelEntity, List<DataModelItemEntity> dataModelItemEntities, JSONObject saveData, List<DataCleanRuleDetailEntity> cleanRuleDetailList) {
        String sourceId = saveData.getString("sourceId");
        HashMap<String, String> errorMap = new HashMap<String, String>();
        if (cleanRuleDetailList != null && cleanRuleDetailList.size() > 0) {
            for (DataCleanRuleDetailEntity cleanRuleDetail : cleanRuleDetailList) {
                String ruleType = cleanRuleDetail.getRuleType();
                DataModelItemEntity dataModelItem = (DataModelItemEntity)((Object)this.dataModelItemService.getById(cleanRuleDetail.getDataModelItemId()));
                String value = saveData.getString(dataModelItem.getItemCode());
                switch (ruleType) {
                    case "1": {
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        paramMap.put("repeatSql", dataModelItem.getItemCode() + "=" + value);
                        paramMap.put("sourceId", sourceId);
                        paramMap.put("tableName", masterDataModelEntity.getModelCode());
                        JSONObject jsonObject = this.dataModelItemService.queryDataIsExist(paramMap);
                        if (jsonObject == null) break;
                        errorMap.put(dataModelItem.getItemCode(), dataModelItem.getItemName() + "\u5b57\u6bb5\u4e0d\u80fd\u91cd\u590d");
                        break;
                    }
                    case "2": {
                        if (!StringUtils.isBlank((CharSequence)value)) break;
                        errorMap.put(dataModelItem.getItemCode(), dataModelItem.getItemName() + "\u4e0d\u80fd\u4e3a\u7a7a");
                        break;
                    }
                    case "3": {
                        if (Validate.isEmail((String)value)) break;
                        errorMap.put(dataModelItem.getItemCode(), dataModelItem.getItemName() + "\u90ae\u7bb1\u4e0d\u5408\u6cd5");
                        break;
                    }
                    case "4": {
                        try {
                            Integer.parseInt(value);
                        }
                        catch (Exception e) {
                            errorMap.put(dataModelItem.getItemCode(), dataModelItem.getItemName() + "\u5fc5\u987b\u662f\u6574\u6570");
                        }
                        break;
                    }
                    case "5": {
                        if (Pattern.matches("^[-\\+]?[.\\d]*$", value)) break;
                        errorMap.put(dataModelItem.getItemCode(), dataModelItem.getItemName() + "\u5fc5\u987b\u662f\u91d1\u989d\u683c\u5f0f");
                        break;
                    }
                    case "6": {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        try {
                            format.parse(value);
                        }
                        catch (Exception e) {
                            errorMap.put(dataModelItem.getItemCode(), dataModelItem.getItemName() + "\u5fc5\u987b\u662f\u65e5\u671f\u683c\u5f0f");
                        }
                        break;
                    }
                    case "7": {
                        HashMap<String, String> referParamMap = new HashMap<String, String>();
                        referParamMap.put("tableName", dataModelItem.getReferCode());
                        referParamMap.put("_source_id", value);
                        JSONObject referObject = this.dataModelItemService.queryReferData(referParamMap);
                        if (referObject != null) break;
                        errorMap.put(dataModelItem.getItemCode(), dataModelItem.getItemName() + "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u53c2\u7167\u6570\u636e");
                    }
                }
                if (errorMap.isEmpty()) continue;
                errorMap.put("errorData", JSON.toJSONString((Object)saveData));
                errorList.add(errorMap);
                break;
            }
        }
        if (errorMap.isEmpty()) {
            String executeSql = "";
            JSONObject uniqueData = this.dataModelItemService.queryDataBySourceId(masterDataModelEntity.getModelCode(), sourceId);
            if (uniqueData != null) {
                executeSql = executeSql + "update " + masterDataModelEntity.getModelCode() + " set _last_update_time = now(),_data_type=2,";
                for (DataModelItemEntity modelItem : dataModelItemEntities) {
                    if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) continue;
                    if (StringUtils.isNotBlank((CharSequence)saveData.getString(modelItem.getItemCode()))) {
                        executeSql = executeSql + "`" + modelItem.getItemCode() + "`='" + saveData.getString(modelItem.getItemCode()) + "',";
                        continue;
                    }
                    executeSql = executeSql + "`" + modelItem.getItemCode() + "`=null,";
                }
                executeSql = executeSql.substring(0, executeSql.length() - 1);
                executeSql = executeSql + " where _source_id='" + sourceId + "'";
                this.dataModelItemService.executeUpdateSql(executeSql);
            }
            if (StringUtils.isBlank((CharSequence)executeSql)) {
                String masterDataId = IdWorker.getId() + "";
                executeSql = "insert into " + masterDataModelEntity.getModelCode();
                String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id,";
                String valueSql = " values(" + masterDataId + ",now(),1,'" + sourceId + "',";
                for (DataModelItemEntity modelItem : dataModelItemEntities) {
                    if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) continue;
                    String itemCode = modelItem.getItemCode();
                    fieldSql = fieldSql + "`" + itemCode + "`,";
                    if (StringUtils.isNotBlank((CharSequence)saveData.getString(itemCode))) {
                        valueSql = valueSql + "'" + saveData.getString(itemCode) + "',";
                        continue;
                    }
                    valueSql = valueSql + "null,";
                }
                fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
                valueSql = valueSql.substring(0, valueSql.length() - 1);
                fieldSql = fieldSql + ")";
                valueSql = valueSql + ")";
                executeSql = executeSql + fieldSql + valueSql;
                saveData.put("masterDataId", (Object)masterDataId);
                this.dataModelItemService.executeInsertSql(executeSql);
            }
        }
        return errorMap;
    }

    @RequestMapping(value={"/insertOrUpdateMdmData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> insertOrUpdateMdmData(@RequestBody InsertParam insertParam, HttpServletRequest request) {
        QueryWrapper thirdSystemWrapper = new QueryWrapper();
        thirdSystemWrapper.eq((Object)"system_code", (Object)insertParam.getSystemCode());
        ThirdSystemEntity thirdSystemEntity = (ThirdSystemEntity)((Object)this.thirdSystemService.getOne((Wrapper)thirdSystemWrapper));
        if (thirdSystemEntity == null) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef\uff1a\u8be5\u7cfb\u7edf\u7f16\u53f7\u672a\u5728\u4e3b\u6570\u636e\u7cfb\u7edf\u4e2d\u6ce8\u518c");
        }
        DataTransferLogEntity transferLog = new DataTransferLogEntity();
        transferLog.setId(IdWorker.getId());
        transferLog.setThirdSystemId(thirdSystemEntity.getId());
        transferLog.setCallType("insertOrUpdateMdmData");
        transferLog.setReqTime(new Date());
        transferLog.setReqParams(insertParam.toString());
        transferLog.setRespState("failed");
        this.dataTransferLogService.saveOrUpdate((Object)transferLog, false);
        JSONObject responseData = new JSONObject();
        QueryWrapper masterDataModelWrapper = new QueryWrapper();
        masterDataModelWrapper.eq((Object)"model_code", (Object)insertParam.getDataModelCode());
        DataModelEntity masterDataModelEntity = (DataModelEntity)((Object)this.dataModelService.getOne((Wrapper)masterDataModelWrapper));
        QueryWrapper masterDataModelItemWrapper = new QueryWrapper();
        masterDataModelItemWrapper.eq((Object)"data_model_id", (Object)masterDataModelEntity.getId());
        List dataModelItemEntities = this.dataModelItemService.list((Wrapper)masterDataModelItemWrapper);
        QueryWrapper cleanRuleWrapper = new QueryWrapper();
        cleanRuleWrapper.eq((Object)"data_model_id", (Object)masterDataModelEntity.getId());
        DataCleanRuleEntity dataCleanRuleEntity = (DataCleanRuleEntity)((Object)this.dataCleanRuleService.getOne((Wrapper)cleanRuleWrapper));
        List cleanRuleDetailList = null;
        if (dataCleanRuleEntity != null) {
            QueryWrapper cleanRuleDetailWrapper = new QueryWrapper();
            cleanRuleDetailWrapper.eq((Object)"rule_id", (Object)dataCleanRuleEntity.getId());
            cleanRuleDetailList = this.dataCleanRuleDetailService.list((Wrapper)cleanRuleDetailWrapper);
        }
        List saveDatas = insertParam.getSaveData();
        ArrayList<Map<String, String>> errorList = new ArrayList<Map<String, String>>();
        ArrayList<JSONObject> resultDatas = new ArrayList<JSONObject>();
        if (saveDatas != null && saveDatas.size() > 0) {
            for (JSONObject saveData : saveDatas) {
                Map<String, String> errorMap = this.executeInsertMdmData(errorList, masterDataModelEntity, dataModelItemEntities, saveData, cleanRuleDetailList);
                if (!errorMap.isEmpty()) continue;
                QueryWrapper childDataModelWrapper = new QueryWrapper();
                childDataModelWrapper.eq((Object)"parent_id", (Object)masterDataModelEntity.getId());
                List childDataModelList = this.dataModelService.list((Wrapper)childDataModelWrapper);
                if (childDataModelList != null && childDataModelList.size() > 0) {
                    for (DataModelEntity childDataModelEntity : childDataModelList) {
                        QueryWrapper childMasterDataModelItemWrapper = new QueryWrapper();
                        childMasterDataModelItemWrapper.eq((Object)"data_model_id", (Object)childDataModelEntity.getId());
                        List childDataModelItemEntities = this.dataModelItemService.list((Wrapper)childMasterDataModelItemWrapper);
                        JSONArray childList = saveData.getJSONArray(childDataModelEntity.getModelCode());
                        if (childList == null || childList.size() <= 0) continue;
                        for (int i = 0; i < childList.size(); ++i) {
                            JSONObject childSaveData = childList.getJSONObject(i);
                            QueryWrapper childCleanRuleWrapper = new QueryWrapper();
                            cleanRuleWrapper.eq((Object)"data_model_id", (Object)childDataModelEntity.getId());
                            DataCleanRuleEntity childDataCleanRuleEntity = (DataCleanRuleEntity)((Object)this.dataCleanRuleService.getOne((Wrapper)childCleanRuleWrapper));
                            List childCleanRuleDetailList = null;
                            if (childDataCleanRuleEntity != null) {
                                QueryWrapper cleanRuleDetailWrapper = new QueryWrapper();
                                cleanRuleDetailWrapper.eq((Object)"rule_id", (Object)childDataCleanRuleEntity.getId());
                                childCleanRuleDetailList = this.dataCleanRuleDetailService.list((Wrapper)cleanRuleDetailWrapper);
                            }
                            ArrayList<Map<String, String>> childErrorList = new ArrayList<Map<String, String>>();
                            this.executeInsertMdmData(childErrorList, childDataModelEntity, childDataModelItemEntities, childSaveData, childCleanRuleDetailList);
                        }
                    }
                }
                resultDatas.add(saveData);
            }
        }
        responseData.put(insertParam.getDataModelCode(), resultDatas);
        transferLog.setCallResp(JSON.toJSONString((Object)responseData));
        transferLog.setRespState("ok");
        this.dataTransferLogService.saveOrUpdate((Object)transferLog, false);
        if (errorList.size() > 0) {
            return CommonResponse.error((String)((Object)errorList).toString(), (Object)responseData);
        }
        return CommonResponse.success((Object)responseData);
    }

    @RequestMapping(value={"/deleteMdmData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> deleteMdmData(@RequestBody DeleteParam deleteParam, HttpServletRequest request) {
        QueryWrapper thirdSystemWrapper = new QueryWrapper();
        thirdSystemWrapper.eq((Object)"system_code", (Object)deleteParam.getSystemCode());
        ThirdSystemEntity thirdSystemEntity = (ThirdSystemEntity)((Object)this.thirdSystemService.getOne((Wrapper)thirdSystemWrapper));
        if (thirdSystemEntity == null) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef\uff1a\u8be5\u7cfb\u7edf\u7f16\u53f7\u672a\u5728\u4e3b\u6570\u636e\u7cfb\u7edf\u4e2d\u6ce8\u518c");
        }
        DataTransferLogEntity transferLog = new DataTransferLogEntity();
        transferLog.setId(IdWorker.getId());
        transferLog.setThirdSystemId(thirdSystemEntity.getId());
        transferLog.setCallType("deleteMdmData");
        transferLog.setReqTime(new Date());
        transferLog.setReqParams(deleteParam.toString());
        transferLog.setRespState("failed");
        this.dataTransferLogService.saveOrUpdate((Object)transferLog, false);
        QueryWrapper masterDataModelWrapper = new QueryWrapper();
        masterDataModelWrapper.eq((Object)"model_code", (Object)deleteParam.getDataModelCode());
        DataModelEntity masterDataModelEntity = (DataModelEntity)((Object)this.dataModelService.getOne((Wrapper)masterDataModelWrapper));
        List mdmIds = deleteParam.getMdmIds();
        String mdmIdStr = "";
        List<JSONObject> resultDataList = null;
        if (mdmIds != null && mdmIds.size() > 0) {
            for (String mdmId : mdmIds) {
                mdmIdStr = mdmIdStr + mdmId + ",";
            }
            if (StringUtils.isNotBlank((CharSequence)mdmIdStr)) {
                mdmIdStr = mdmIdStr.substring(0, mdmIdStr.length() - 1);
            }
            HashMap<String, Object> modelItemMap = new HashMap<String, Object>();
            modelItemMap.put("mdmIdStr", mdmIdStr);
            modelItemMap.put("tableName", masterDataModelEntity.getModelCode());
            resultDataList = this.dataModelItemService.queryMdmDataList(modelItemMap);
            if (resultDataList != null && resultDataList.size() > 0) {
                QueryWrapper childDataModelWrapper = new QueryWrapper();
                childDataModelWrapper.eq((Object)"parent_id", (Object)masterDataModelEntity.getId());
                List childDataModelList = this.dataModelService.list((Wrapper)childDataModelWrapper);
                if (childDataModelList != null && childDataModelList.size() > 0) {
                    for (DataModelEntity childModel : childDataModelList) {
                        for (JSONObject masterData : resultDataList) {
                            HashMap<String, Object> childParamMap = new HashMap<String, Object>();
                            childParamMap.put("parentId", masterData.get((Object)"id").toString());
                            childParamMap.put("tableName", childModel.getModelCode());
                            this.dataModelItemService.deleteChildMdmData(childParamMap);
                        }
                    }
                }
            }
            this.dataModelItemService.deleteMasterMdmData(modelItemMap);
            transferLog.setRespState("ok");
            this.dataTransferLogService.saveOrUpdate((Object)transferLog, false);
            return CommonResponse.success();
        }
        throw new BusinessException("\u4e3b\u6570\u636eids\u4e0d\u6b63\u786e");
    }
}

