/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.mdm.controller.sync;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.dataexchange.api.IProManageApi;
import com.ejianc.business.dataexchange.vo.ProManageVO;
import com.ejianc.foundation.mdm.bean.DataModelEntity;
import com.ejianc.foundation.mdm.bean.DataModelItemEntity;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjOrgResponseVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjOrgVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjResponseVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjUpdateVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjUserResponseVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjUserVO;
import com.ejianc.foundation.mdm.service.IDataModelItemService;
import com.ejianc.foundation.mdm.service.IDataModelService;
import com.ejianc.foundation.mdm.utils.HttpTookitZzyj;
import com.ejianc.foundation.mdm.utils.ZzyjSyncConfig;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/zzyj/sync"})
public class ZzyjSyncController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    private final String hrHost = "http://hr.zzyjjt.com";
    private final String sysFlag = "EJCCS";
    private final String sysEtoken = "36A208CBD13488C8E51AB0E954D8EF23";
    @Autowired
    private IDataModelService dataModelService;
    @Autowired
    private IDataModelItemService dataModelItemService;
    @Autowired
    private IProManageApi proManageApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    public String getDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(new Date());
    }

    @RequestMapping(value={"/orgs"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncOrgs(HttpServletRequest request) {
        ZzyjSyncConfig zzyjSyncConfig = new ZzyjSyncConfig("http://hr.zzyjjt.com", "EJCCS", "36A208CBD13488C8E51AB0E954D8EF23");
        this.logger.info(">>>>{}>>>>\u90d1\u5dde\u4e00\u5efa\u5b8f\u666fHR\u540c\u6b65\u7ec4\u7ec7\u6570\u636estart...", (Object)this.getDateTime());
        try {
            String resp = HttpTookitZzyj.get(zzyjSyncConfig.getOrgUrl(), request);
            ZzyjOrgResponseVO zzyjOrgResponseVO = (ZzyjOrgResponseVO)JSONObject.parseObject((String)resp, ZzyjOrgResponseVO.class);
            if (zzyjOrgResponseVO.isSuccess()) {
                this.logger.info(">>>>{}>>>>\u63a5\u6536\u5230\u90d1\u5dde\u4e00\u5efa\u5b8f\u666fHR\u7ec4\u7ec7\u6570\u636e\u6761\u6570:{},\u5f00\u59cb\u89e3\u6790\u5e76\u8fdb\u884c\u5165\u5e93\u64cd\u4f5c...", (Object)this.getDateTime(), (Object)(CollectionUtils.isNotEmpty(zzyjOrgResponseVO.getData()) ? zzyjOrgResponseVO.getData().size() : 0));
                if (CollectionUtils.isNotEmpty(zzyjOrgResponseVO.getData())) {
                    List orgData = zzyjOrgResponseVO.getData();
                    ArrayList<String> delOrgSourceIds = new ArrayList<String>();
                    ArrayList<String> delDeptSourceIds = new ArrayList<String>();
                    ArrayList<ZzyjUpdateVO> updateVOS = new ArrayList<ZzyjUpdateVO>();
                    if (CollectionUtils.isNotEmpty(orgData)) {
                        Collections.sort(orgData, (o1, o2) -> {
                            int a1 = StringUtils.isNotEmpty((CharSequence)o1.getGrade()) ? Integer.parseInt(o1.getGrade()) : 0;
                            int a2 = StringUtils.isNotEmpty((CharSequence)o2.getGrade()) ? Integer.parseInt(o2.getGrade()) : 0;
                            return a1 - a2;
                        });
                        for (ZzyjOrgVO zzyjOrgVO : orgData) {
                            boolean success = false;
                            success = "UN".equals(zzyjOrgVO.getCodesetid()) ? this.syncOrgVO(zzyjOrgVO, delOrgSourceIds) : ("UM".equals(zzyjOrgVO.getCodesetid()) && ("\u9879\u76ee".equals(zzyjOrgVO.getB010a()) || StringUtils.isBlank((CharSequence)zzyjOrgVO.getB010a())) ? this.syncOrgVO(zzyjOrgVO, delOrgSourceIds) : this.syncDeptVO(zzyjOrgVO, delDeptSourceIds));
                            updateVOS.add(zzyjOrgVO.toUpdateVO(success));
                        }
                        if (CollectionUtils.isNotEmpty(delOrgSourceIds)) {
                            String delOrgSourceIdStr = "";
                            for (String delOrgSourceId : delOrgSourceIds) {
                                delOrgSourceIdStr = delOrgSourceIdStr + "'" + delOrgSourceId + "',";
                            }
                            delOrgSourceIdStr = delOrgSourceIdStr.substring(0, delOrgSourceIdStr.length() - 1);
                            this.dataModelItemService.deleteMdmDataBySourceIds("orgmodel", delOrgSourceIdStr);
                        }
                        if (CollectionUtils.isNotEmpty(delDeptSourceIds)) {
                            String delDeptSourceIdStr = "";
                            for (String delDeptSourceId : delOrgSourceIds) {
                                delDeptSourceIdStr = delDeptSourceIdStr + "'" + delDeptSourceId + "',";
                            }
                            delDeptSourceIdStr = delDeptSourceIdStr.substring(0, delDeptSourceIdStr.length() - 1);
                            this.dataModelItemService.deleteMdmDataBySourceIds("deptmodel", delDeptSourceIdStr);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CommonResponse.success((String)(">>>>" + this.getDateTime() + ">>>>\u90d1\u5dde\u4e00\u5efa\u540c\u6b65\u5b8f\u666fHR\u7cfb\u7edf\u7ec4\u7ec7\u6267\u884c\u5b8c\u6bd5!"));
    }

    @RequestMapping(value={"/users"})
    @ResponseBody
    public CommonResponse<String> syncUsers(HttpServletRequest request) {
        ZzyjSyncConfig zzyjSyncConfig = new ZzyjSyncConfig("http://hr.zzyjjt.com", "EJCCS", "36A208CBD13488C8E51AB0E954D8EF23");
        this.logger.info(">>>>{}>>>>\u90d1\u5dde\u4e00\u5efa\u5b8f\u666fHR\u540c\u6b65\u4eba\u5458\u6570\u636estart...", (Object)this.getDateTime());
        try {
            String resp = HttpTookitZzyj.get(zzyjSyncConfig.getUserUrl(), request);
            ZzyjUserResponseVO zzyjUserResponseVO = (ZzyjUserResponseVO)JSONObject.parseObject((String)resp, ZzyjUserResponseVO.class);
            if (zzyjUserResponseVO.isSuccess()) {
                this.logger.info(">>>>{}>>>>\u63a5\u6536\u5230\u90d1\u5dde\u4e00\u5efa\u5b8f\u666fHR\u4eba\u5458\u6570\u636e\u6761\u6570:{},\u5f00\u59cb\u89e3\u6790\u5e76\u8fdb\u884c\u5165\u5e93\u64cd\u4f5c...", (Object)this.getDateTime(), (Object)(CollectionUtils.isNotEmpty(zzyjUserResponseVO.getData()) ? zzyjUserResponseVO.getData().size() : 0));
                if (CollectionUtils.isNotEmpty(zzyjUserResponseVO.getData())) {
                    ArrayList<String> delUserSourceIds = new ArrayList<String>();
                    ArrayList<ZzyjUpdateVO> updateVOS = new ArrayList<ZzyjUpdateVO>();
                    QueryWrapper masterDataModelWrapper = new QueryWrapper();
                    masterDataModelWrapper.eq((Object)"model_code", (Object)"employeemodel");
                    DataModelEntity dataModelEntity = (DataModelEntity)((Object)this.dataModelService.getOne((Wrapper)masterDataModelWrapper));
                    QueryWrapper masterDataModelItemWrapper = new QueryWrapper();
                    masterDataModelItemWrapper.eq((Object)"data_model_id", (Object)dataModelEntity.getId());
                    List dataModelItemEntities = this.dataModelItemService.list((Wrapper)masterDataModelItemWrapper);
                    for (ZzyjUserVO syncVO : zzyjUserResponseVO.getData()) {
                        if ("3".equals(syncVO.getEjccs())) {
                            delUserSourceIds.add(syncVO.getUnique_id());
                            updateVOS.add(syncVO.toUpdateVO(true));
                            continue;
                        }
                        JSONObject orgEntity = this.dataModelItemService.getObjectBySqlCondition("orgmodel", " and code='" + syncVO.getB0110_0() + "'");
                        JSONObject deptEntity = this.dataModelItemService.getObjectBySqlCondition("deptmodel", " and code='" + syncVO.getE0122_0() + "'");
                        if (deptEntity != null && orgEntity == null) {
                            orgEntity = this.dataModelItemService.getObjectBySqlCondition("orgmodel", " and _master_data_id='" + deptEntity.getString("orgId") + "'");
                        }
                        JSONObject employeeJson = syncVO.toEmployeeVO();
                        JSONObject employeeObj = this.dataModelItemService.queryDataBySourceId("employeemodel", employeeJson.getString("sourceId"));
                        String executeSql = "";
                        if (employeeObj != null) {
                            String empOrgId = employeeObj.getString("orgId");
                            String empDeptId = employeeObj.getString("deptId");
                            employeeObj.put("userCode", (Object)employeeJson.getString("userCode"));
                            employeeObj.put("mobilePhone", (Object)employeeJson.getString("mobilePhone"));
                            employeeObj.put("employeeCode", (Object)employeeJson.getString("employeeCode"));
                            employeeObj.put("employeeName", (Object)employeeJson.getString("employeeName"));
                            if (orgEntity.getString("_master_data_id") != null) {
                                employeeObj.put("orgId", (Object)orgEntity.getString("_master_data_id"));
                            }
                            employeeObj.put("orgCode", (Object)employeeJson.getString("orgCode"));
                            employeeObj.put("orgName", (Object)employeeJson.getString("orgName"));
                            employeeObj.put("deptId", (Object)(deptEntity != null ? deptEntity.getString("_master_data_id") : ""));
                            employeeObj.put("deptCode", (Object)employeeJson.getString("deptCode"));
                            employeeObj.put("deptName", (Object)employeeJson.getString("deptName"));
                            employeeObj.put("sex", (Object)employeeJson.getString("sex"));
                            employeeObj.put("email", (Object)employeeJson.getString("email"));
                            employeeObj.put("idCard", (Object)employeeJson.getString("idCard"));
                            employeeObj.put("telephone", (Object)employeeJson.getString("telephone"));
                            employeeObj.put("sequence", (Object)employeeJson.getString("sequence"));
                            executeSql = executeSql + "update employeemodel set _last_update_time = now(),_data_type=2,";
                            for (DataModelItemEntity modelItem : dataModelItemEntities) {
                                if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) continue;
                                if (StringUtils.isNotBlank((CharSequence)employeeObj.getString(modelItem.getItemCode()))) {
                                    executeSql = executeSql + "`" + modelItem.getItemCode() + "`='" + employeeObj.getString(modelItem.getItemCode()) + "',";
                                    continue;
                                }
                                executeSql = executeSql + "`" + modelItem.getItemCode() + "`=null,";
                            }
                            executeSql = executeSql.substring(0, executeSql.length() - 1);
                            executeSql = executeSql + " where _source_id='" + employeeJson.getString("sourceId") + "'";
                            this.dataModelItemService.executeUpdateSql(executeSql);
                            boolean isMoveJob = false;
                            if (StringUtils.isNotBlank((CharSequence)empOrgId) && !empOrgId.equals(orgEntity.getString("_master_data_id"))) {
                                isMoveJob = true;
                            } else if (StringUtils.isNotBlank((CharSequence)empDeptId) && deptEntity != null && !empDeptId.equals(deptEntity.getString("_master_data_id"))) {
                                isMoveJob = true;
                            } else if (StringUtils.isNotBlank((CharSequence)empDeptId) && deptEntity == null) {
                                isMoveJob = true;
                            } else if (StringUtils.isBlank((CharSequence)empDeptId) && deptEntity != null) {
                                isMoveJob = true;
                            }
                            if (isMoveJob) {
                                String updatePreJobState = "update jobmodel set curState = 1,jobStartEndTime=now(),_last_update_time=now(),_data_type=2 where _parent_id='" + employeeObj.getString("_master_data_id") + "' and property = 1 and curState = 0 and orgId = '" + employeeObj.getString("orgId") + "'";
                                this.dataModelItemService.executeUpdateSql(updatePreJobState);
                                String pkId = IdWorker.getId() + "";
                                String insertNewJobSql = "insert into jobmodel(_master_data_id,_last_update_time,_data_type,_source_id,orgId,orgCode,orgName,deptId,deptCode,deptName,jobStartTime,curState,property) values";
                                insertNewJobSql = insertNewJobSql + "(" + pkId + ",now(),1," + pkId + ",'" + empOrgId + "','" + orgEntity.getString("code") + "','" + orgEntity.getString("name") + "','" + (deptEntity != null ? deptEntity.getString("_master_data_id") : "") + "','" + (deptEntity != null ? deptEntity.getString("code") : "") + "','" + (deptEntity != null ? deptEntity.getString("name") : "") + "',now(),0,1)";
                                this.dataModelItemService.executeInsertSql(insertNewJobSql);
                            }
                        }
                        if (StringUtils.isBlank((CharSequence)executeSql)) {
                            if (orgEntity != null) {
                                employeeJson.put("orgId", (Object)orgEntity.getString("_master_data_id"));
                            }
                            if (deptEntity != null) {
                                employeeJson.put("deptId", (Object)deptEntity.getString("_master_data_id"));
                            }
                            Long employeeId = IdWorker.getId();
                            executeSql = "insert into employeemodel";
                            String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id,";
                            String valueSql = " values(" + employeeId + ",now(),1,'" + employeeJson.getString("sourceId") + "',";
                            for (DataModelItemEntity modelItem : dataModelItemEntities) {
                                if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) continue;
                                String itemCode = modelItem.getItemCode();
                                fieldSql = fieldSql + "`" + itemCode + "`,";
                                if (StringUtils.isNotBlank((CharSequence)employeeJson.getString(itemCode))) {
                                    valueSql = valueSql + "'" + employeeJson.getString(itemCode) + "',";
                                    continue;
                                }
                                valueSql = valueSql + "null,";
                            }
                            fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
                            valueSql = valueSql.substring(0, valueSql.length() - 1);
                            fieldSql = fieldSql + ")";
                            valueSql = valueSql + ")";
                            executeSql = executeSql + fieldSql + valueSql;
                            this.dataModelItemService.executeInsertSql(executeSql);
                            String pkId = IdWorker.getId() + "";
                            String insertNewJobSql = "insert into jobmodel(_master_data_id,_last_update_time,_data_type,_source_id,_parent_id,orgId,orgCode,orgName,deptId,deptCode,deptName,jobStartTime,curState,property) values";
                            insertNewJobSql = insertNewJobSql + "(" + pkId + ",now(),1," + pkId + "," + employeeId + ",'" + orgEntity.getString("_master_data_id") + "','" + orgEntity.getString("code") + "','" + orgEntity.getString("name") + "','" + (deptEntity != null ? deptEntity.getString("_master_data_id") : "") + "','" + (deptEntity != null ? deptEntity.getString("code") : "") + "','" + (deptEntity != null ? deptEntity.getString("name") : "") + "',now(),0,1)";
                            this.dataModelItemService.executeInsertSql(insertNewJobSql);
                        }
                        updateVOS.add(syncVO.toUpdateVO(true));
                    }
                    if (CollectionUtils.isNotEmpty(delUserSourceIds)) {
                        String delUserSourceIdStr = "";
                        for (String delUserSourceId : delUserSourceIds) {
                            delUserSourceIdStr = delUserSourceIdStr + "'" + delUserSourceId + "',";
                        }
                        delUserSourceIdStr = delUserSourceIdStr.substring(0, delUserSourceIdStr.length() - 1);
                        this.dataModelItemService.deleteMdmDataBySourceIds("employeemodel", delUserSourceIdStr);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CommonResponse.success((String)(">>>>" + this.getDateTime() + ">>>>\u90d1\u5dde\u4e00\u5efa\u540c\u6b65\u5b8f\u666fHR\u7cfb\u7edf\u4eba\u5458\u6267\u884c\u5b8c\u6bd5!"));
    }

    @RequestMapping(value={"/jobs"})
    @ResponseBody
    public CommonResponse<String> syncJobs(HttpServletRequest request) {
        ZzyjSyncConfig zzyjSyncConfig = new ZzyjSyncConfig("http://hr.zzyjjt.com", "EJCCS", "36A208CBD13488C8E51AB0E954D8EF23");
        this.logger.info(">>>>{}>>>>\u90d1\u5dde\u4e00\u5efa\u5b8f\u666fHR\u540c\u6b65\u517c\u804c\u6570\u636estart...", (Object)this.getDateTime());
        try {
            Integer pageIndex = 1;
            while (true) {
                String resp = HttpTookitZzyj.get(zzyjSyncConfig.getJobUrl() + "&pageIndex=" + pageIndex + "&pageSize=1000", request);
                pageIndex = pageIndex + 1000;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.success((String)(">>>>" + this.getDateTime() + ">>>>\u90d1\u5dde\u4e00\u5efa\u540c\u6b65\u5b8f\u666fHR\u7cfb\u7edf\u517c\u804c\u6267\u884c\u5b8c\u6bd5!"));
        }
    }

    private CommonResponse<ZzyjResponseVO> callBackUpdateInfo(String type, List<ZzyjUpdateVO> zzyjUpdateVOS) {
        ZzyjSyncConfig zzyjSyncConfig = new ZzyjSyncConfig("http://hr.zzyjjt.com", "EJCCS", "36A208CBD13488C8E51AB0E954D8EF23");
        String jsonString = JSONObject.toJSONString(zzyjUpdateVOS);
        try {
            String updStr = HttpTookitZzyj.postParameters(zzyjSyncConfig.getUpdateUrl(), zzyjSyncConfig.getUpdateParam(type, jsonString));
            ZzyjResponseVO zzyjResponseVO = (ZzyjResponseVO)JSONObject.parseObject((String)updStr, ZzyjResponseVO.class);
            if (!zzyjResponseVO.isSuccess()) {
                this.logger.info(">>>>>>\u56de\u5199\u90d1\u5dde\u4e00\u5efa\u66f4\u65b0\u6807\u8bc6\u5931\u8d25:" + zzyjResponseVO.getMsg());
                return CommonResponse.error((String)zzyjResponseVO.getMsg());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.info(">>>>>>\u56de\u5199\u90d1\u5dde\u4e00\u5efa" + type + "\u4fe1\u606f\u5b8c\u6bd5!");
        return CommonResponse.success((String)(">>>>>>\u56de\u5199\u90d1\u5dde\u4e00\u5efa" + type + "\u4fe1\u606f\u5b8c\u6bd5!"));
    }

    private boolean syncOrgVO(ZzyjOrgVO zzyjOrgVO, List<String> delOrgSourceIds) {
        JSONObject orgJson = zzyjOrgVO.toOrgVO();
        if ("3".equals(zzyjOrgVO.getEjccs())) {
            delOrgSourceIds.add(zzyjOrgVO.getUnique_id());
            return true;
        }
        JSONObject orgObj = this.dataModelItemService.queryDataBySourceId("orgmodel", orgJson.getString("sourceId"));
        String masterDataId = "";
        masterDataId = orgObj == null ? IdWorker.getId() + "" : orgObj.getString("_master_data_id");
        String innerCode = "";
        String parentId = "";
        if (StringUtils.isNotEmpty((CharSequence)zzyjOrgVO.getParentid()) && !zzyjOrgVO.getParentid().equals(zzyjOrgVO.getB0110_0())) {
            JSONObject orgEntity = this.dataModelItemService.getObjectBySqlCondition("orgmodel", "and code='" + zzyjOrgVO.getParentid() + "'");
            if (orgEntity != null) {
                innerCode = orgEntity.getString("innerCode") + "|" + masterDataId;
                parentId = orgEntity.getString("_master_data_id");
            } else {
                innerCode = masterDataId;
            }
        } else {
            innerCode = masterDataId;
        }
        QueryWrapper masterDataModelWrapper = new QueryWrapper();
        masterDataModelWrapper.eq((Object)"model_code", (Object)"orgmodel");
        DataModelEntity dataModelEntity = (DataModelEntity)((Object)this.dataModelService.getOne((Wrapper)masterDataModelWrapper));
        QueryWrapper masterDataModelItemWrapper = new QueryWrapper();
        masterDataModelItemWrapper.eq((Object)"data_model_id", (Object)dataModelEntity.getId());
        List dataModelItemEntities = this.dataModelItemService.list((Wrapper)masterDataModelItemWrapper);
        String executeSql = "";
        if (orgObj != null) {
            orgObj.put("name", (Object)orgJson.getString("name"));
            orgObj.put("shortName", (Object)orgJson.getString("shortName"));
            orgObj.put("orgType", (Object)orgJson.getString("orgType"));
            orgObj.put("innerCode", (Object)innerCode);
            orgObj.put("parentId", (Object)parentId);
            orgObj.put("sequence", (Object)orgJson.getString("sequence"));
            orgObj.put("telephone", (Object)orgJson.getString("telephone"));
            executeSql = executeSql + "update orgmodel set _last_update_time = now(),_data_type=2,";
            for (DataModelItemEntity modelItem : dataModelItemEntities) {
                if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) continue;
                if (StringUtils.isNotBlank((CharSequence)orgObj.getString(modelItem.getItemCode()))) {
                    executeSql = executeSql + "`" + modelItem.getItemCode() + "`='" + (orgObj.getString(modelItem.getItemCode()) != null ? orgObj.getString(modelItem.getItemCode()) : "") + "',";
                    continue;
                }
                executeSql = executeSql + "`" + modelItem.getItemCode() + "`=null,";
            }
            executeSql = executeSql.substring(0, executeSql.length() - 1);
            executeSql = executeSql + " where _source_id='" + orgJson.getString("sourceId") + "'";
            this.dataModelItemService.executeUpdateSql(executeSql);
        }
        if (StringUtils.isBlank((CharSequence)executeSql)) {
            orgJson.put("innerCode", (Object)innerCode);
            orgJson.put("parentId", (Object)parentId);
            executeSql = "insert into orgmodel";
            String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id,enabled, ";
            String valueSql = " values(" + masterDataId + ",now(),1,'" + orgJson.getString("sourceId") + "','\u542f\u7528', ";
            for (DataModelItemEntity modelItem : dataModelItemEntities) {
                if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode()) || "enabled".equals(modelItem.getItemCode())) continue;
                String itemCode = modelItem.getItemCode();
                fieldSql = fieldSql + "`" + itemCode + "`,";
                if (StringUtils.isNotBlank((CharSequence)orgJson.getString(itemCode))) {
                    valueSql = valueSql + "'" + (orgJson.getString(itemCode) != null ? orgJson.getString(itemCode) : "") + "',";
                    continue;
                }
                valueSql = valueSql + "null,";
            }
            fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
            valueSql = valueSql.substring(0, valueSql.length() - 1);
            fieldSql = fieldSql + ")";
            valueSql = valueSql + ")";
            executeSql = executeSql + fieldSql + valueSql;
            this.dataModelItemService.executeInsertSql(executeSql);
        }
        return true;
    }

    private boolean syncDeptVO(ZzyjOrgVO zzyjOrgVO, List<String> delDeptSourceIds) {
        JSONObject orgObj;
        JSONObject deptJson = zzyjOrgVO.toDeptVO();
        if ("3".equals(zzyjOrgVO.getEjccs())) {
            delDeptSourceIds.add(zzyjOrgVO.getUnique_id());
            return true;
        }
        JSONObject deptObj = this.dataModelItemService.queryDataBySourceId("deptmodel", deptJson.getString("sourceId"));
        String masterDataId = "";
        masterDataId = deptObj == null ? IdWorker.getId() + "" : deptObj.getString("_master_data_id");
        String innerCode = "";
        String parentId = "";
        if (StringUtils.isNotEmpty((CharSequence)zzyjOrgVO.getParentid()) && !zzyjOrgVO.getParentid().equals(zzyjOrgVO.getB0110_0())) {
            JSONObject deptEntity = this.dataModelItemService.getObjectBySqlCondition("deptmodel", "and code='" + zzyjOrgVO.getParentid() + "'");
            if (deptEntity != null) {
                innerCode = deptEntity.getString("innerCode") + "|" + masterDataId;
                parentId = deptEntity.getString("_master_data_id");
            } else {
                innerCode = masterDataId;
            }
        } else {
            innerCode = masterDataId;
        }
        QueryWrapper masterDataModelWrapper = new QueryWrapper();
        masterDataModelWrapper.eq((Object)"model_code", (Object)"deptmodel");
        DataModelEntity dataModelEntity = (DataModelEntity)((Object)this.dataModelService.getOne((Wrapper)masterDataModelWrapper));
        QueryWrapper masterDataModelItemWrapper = new QueryWrapper();
        masterDataModelItemWrapper.eq((Object)"data_model_id", (Object)dataModelEntity.getId());
        List dataModelItemEntities = this.dataModelItemService.list((Wrapper)masterDataModelItemWrapper);
        String executeSql = "";
        if (deptObj != null) {
            deptObj.put("name", (Object)deptJson.getString("name"));
            deptObj.put("shortName", (Object)deptJson.getString("shortName"));
            deptObj.put("sequence", (Object)deptJson.getString("sequence"));
            deptObj.put("telephone", (Object)deptJson.getString("telephone"));
            orgObj = this.dataModelItemService.getObjectBySqlCondition("orgmodel", " and code='" + deptJson.getString("parentid") + "'");
            if (orgObj != null) {
                deptObj.put("orgId", (Object)orgObj.getString("_master_data_id"));
            }
            executeSql = executeSql + "update deptmodel set _last_update_time = now(),_data_type=2,";
            for (DataModelItemEntity modelItem : dataModelItemEntities) {
                if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) continue;
                if (StringUtils.isNotBlank((CharSequence)deptObj.getString(modelItem.getItemCode()))) {
                    executeSql = executeSql + "`" + modelItem.getItemCode() + "`='" + (deptObj.getString(modelItem.getItemCode()) != null ? deptObj.getString(modelItem.getItemCode()) : "") + "',";
                    continue;
                }
                executeSql = executeSql + "`" + modelItem.getItemCode() + "`=null,";
            }
            executeSql = executeSql.substring(0, executeSql.length() - 1);
            executeSql = executeSql + " where _source_id='" + deptJson.getString("sourceId") + "'";
            this.dataModelItemService.executeUpdateSql(executeSql);
        }
        if (StringUtils.isBlank((CharSequence)executeSql)) {
            deptJson.put("innerCode", (Object)innerCode);
            deptJson.put("parentId", (Object)parentId);
            orgObj = this.dataModelItemService.getObjectBySqlCondition("orgmodel", " and code='" + deptJson.getString("parentid") + "'");
            if (orgObj != null) {
                deptJson.put("orgId", (Object)orgObj.getString("_master_data_id"));
            }
            executeSql = "insert into deptmodel";
            String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id,";
            String valueSql = " values(" + masterDataId + ",now(),1,'" + deptJson.getString("sourceId") + "',";
            for (DataModelItemEntity modelItem : dataModelItemEntities) {
                if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) continue;
                String itemCode = modelItem.getItemCode();
                fieldSql = fieldSql + "`" + itemCode + "`,";
                if (StringUtils.isNotBlank((CharSequence)deptJson.getString(itemCode))) {
                    valueSql = valueSql + "'" + (deptJson.getString(itemCode) != null ? deptJson.getString(itemCode) : "") + "',";
                    continue;
                }
                valueSql = valueSql + "null,";
            }
            fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
            valueSql = valueSql.substring(0, valueSql.length() - 1);
            fieldSql = fieldSql + ")";
            valueSql = valueSql + ")";
            executeSql = executeSql + fieldSql + valueSql;
            this.dataModelItemService.executeInsertSql(executeSql);
        }
        return true;
    }

    @RequestMapping(value={"/posts"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncPosts(HttpServletRequest request) {
        this.logger.info(">>>>{}>>>>\u90d1\u5dde\u4e00\u5efa\u5b8f\u666fHR\u540c\u6b65\u4eba\u5458\u6570\u636estart...", (Object)this.getDateTime());
        try {
            CommonResponse postResponse = this.proManageApi.queryProManageInfo();
            if (postResponse.isSuccess()) {
                this.logger.info(">>>>{}>>>>\u63a5\u6536\u5230\u90d1\u5dde\u4e00\u5efa\u5b8f\u666fHR\u5c97\u4f4d\u6570\u636e\u6761\u6570:{},\u5f00\u59cb\u89e3\u6790\u5e76\u8fdb\u884c\u5165\u5e93\u64cd\u4f5c...", (Object)this.getDateTime(), (Object)(CollectionUtils.isNotEmpty((Collection)((Collection)postResponse.getData())) ? ((List)postResponse.getData()).size() : 0));
                if (CollectionUtils.isNotEmpty((Collection)((Collection)postResponse.getData()))) {
                    ArrayList<String> delPostSourceIds = new ArrayList<String>();
                    QueryWrapper masterDataModelWrapper = new QueryWrapper();
                    masterDataModelWrapper.eq((Object)"model_code", (Object)"postmodel");
                    DataModelEntity dataModelEntity = (DataModelEntity)((Object)this.dataModelService.getOne((Wrapper)masterDataModelWrapper));
                    QueryWrapper masterDataModelItemWrapper = new QueryWrapper();
                    masterDataModelItemWrapper.eq((Object)"data_model_id", (Object)dataModelEntity.getId());
                    List dataModelItemEntities = this.dataModelItemService.list((Wrapper)masterDataModelItemWrapper);
                    for (ProManageVO syncVO : (List)postResponse.getData()) {
                        if (syncVO.getEndDate() == null) {
                            delPostSourceIds.add(syncVO.getCodeitemid());
                            continue;
                        }
                        if (syncVO.getEndDate().getTime() < new Date().getTime()) {
                            delPostSourceIds.add(syncVO.getCodeitemid());
                            continue;
                        }
                        JSONObject postObj = this.dataModelItemService.queryDataBySourceId("postmodel", syncVO.getCodeitemid());
                        String masterDataId = "";
                        masterDataId = postObj == null ? IdWorker.getId() + "" : postObj.getString("_master_data_id");
                        String innerCode = "";
                        String parentId = "";
                        if (StringUtils.isNotEmpty((CharSequence)syncVO.getParentid()) && !syncVO.getParentid().equals(syncVO.getCodeitemid())) {
                            JSONObject orgEntity = this.dataModelItemService.getObjectBySqlCondition("postmodel", "and code='" + syncVO.getParentid() + "'");
                            if (orgEntity != null) {
                                innerCode = orgEntity.getString("innerCode") + "|" + masterDataId;
                                parentId = orgEntity.getString("_master_data_id");
                            } else {
                                innerCode = masterDataId;
                            }
                        } else {
                            innerCode = masterDataId;
                        }
                        String executeSql = "";
                        if (postObj != null) {
                            postObj.put("name", (Object)syncVO.getCodeitemdesc());
                            postObj.put("code", (Object)syncVO.getCodeitemid());
                            postObj.put("innerCode", (Object)innerCode);
                            postObj.put("parentId", (Object)parentId);
                            postObj.put("sequence", (Object)syncVO.getA0000());
                            executeSql = executeSql + "update postmodel set _last_update_time = now(),_data_type=2,";
                            for (DataModelItemEntity modelItem : dataModelItemEntities) {
                                if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) continue;
                                if (StringUtils.isNotBlank((CharSequence)postObj.getString(modelItem.getItemCode()))) {
                                    executeSql = executeSql + "`" + modelItem.getItemCode() + "`='" + (postObj.getString(modelItem.getItemCode()) != null ? postObj.getString(modelItem.getItemCode()) : "") + "',";
                                    continue;
                                }
                                executeSql = executeSql + "`" + modelItem.getItemCode() + "`=null,";
                            }
                            executeSql = executeSql.substring(0, executeSql.length() - 1);
                            executeSql = executeSql + " where _source_id='" + syncVO.getCodeitemid() + "'";
                            this.dataModelItemService.executeUpdateSql(executeSql);
                        }
                        if (!StringUtils.isBlank((CharSequence)executeSql)) continue;
                        postObj = new JSONObject();
                        postObj.put("name", (Object)syncVO.getCodeitemdesc());
                        postObj.put("code", (Object)syncVO.getCodeitemid());
                        postObj.put("innerCode", (Object)innerCode);
                        postObj.put("parentId", (Object)parentId);
                        postObj.put("sequence", (Object)syncVO.getA0000());
                        executeSql = "insert into postmodel";
                        String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id, ";
                        String valueSql = " values(" + masterDataId + ",now(),1,'" + syncVO.getCodeitemid() + "', ";
                        for (DataModelItemEntity modelItem : dataModelItemEntities) {
                            if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) continue;
                            String itemCode = modelItem.getItemCode();
                            fieldSql = fieldSql + "`" + itemCode + "`,";
                            if (StringUtils.isNotBlank((CharSequence)postObj.getString(itemCode))) {
                                valueSql = valueSql + "'" + (postObj.getString(itemCode) != null ? postObj.getString(itemCode) : "") + "',";
                                continue;
                            }
                            valueSql = valueSql + "null,";
                        }
                        fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
                        valueSql = valueSql.substring(0, valueSql.length() - 1);
                        fieldSql = fieldSql + ")";
                        valueSql = valueSql + ")";
                        executeSql = executeSql + fieldSql + valueSql;
                        this.dataModelItemService.executeInsertSql(executeSql);
                    }
                    if (CollectionUtils.isNotEmpty(delPostSourceIds)) {
                        String delPostSourceIdStr = "";
                        for (String delPostSourceId : delPostSourceIds) {
                            delPostSourceIdStr = delPostSourceIdStr + "'" + delPostSourceId + "',";
                        }
                        delPostSourceIdStr = delPostSourceIdStr.substring(0, delPostSourceIdStr.length() - 1);
                        this.dataModelItemService.deleteMdmDataBySourceIds("postmodel", delPostSourceIdStr);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(">>>>\u90d1\u5dde\u4e00\u5efa\u540c\u6b65\u5b8f\u666fHR\u7cfb\u7edf\u5c97\u4f4d\u62a5\u9519---------", (Throwable)e);
        }
        return CommonResponse.success((String)(">>>>" + this.getDateTime() + ">>>>\u90d1\u5dde\u4e00\u5efa\u540c\u6b65\u5b8f\u666fHR\u7cfb\u7edf\u5c97\u4f4d\u6267\u884c\u5b8c\u6bd5!"));
    }

    @RequestMapping(value={"/project"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncProject(HttpServletRequest request) {
        this.logger.info(">>>>{}>>>>\u90d1\u5dde\u4e00\u5efa \u540c\u6b65\u9879\u76ee\u6570\u636estart...", (Object)this.getDateTime());
        try {
            QueryParam param = new QueryParam();
            boolean has = true;
            int pageSize = 50;
            int pageNum = 1;
            while (has) {
                param.setPageSize(pageSize);
                param.setPageIndex(pageNum);
                String resp = HttpTookitZzyj.postJson(this.baseHost + "ejc-share-web/zzyj/mdm/project/sync", JSONObject.toJSONString((Object)param));
                if (!StringUtils.isNotEmpty((CharSequence)resp)) continue;
                JSONObject r = JSONObject.parseObject((String)resp);
                if (r.getInteger("code") == 0 && r.get((Object)"data") != null) {
                    JSONArray projectList = r.getJSONArray("data");
                    this.saveOrUpdateProject(projectList);
                    ++pageNum;
                    continue;
                }
                has = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(">>>>\u90d1\u5dde\u4e00\u5efa\u540c\u6b65 \u9879\u76ee\u62a5\u9519---------", (Throwable)e);
        }
        return CommonResponse.success((String)(">>>>" + this.getDateTime() + ">>>>\u90d1\u5dde\u4e00\u5efa\u540c\u6b65 \u9879\u76ee\u6267\u884c\u5b8c\u6bd5!"));
    }

    private void saveOrUpdateProject(JSONArray projectList) {
        QueryWrapper masterDataModelWrapper = new QueryWrapper();
        masterDataModelWrapper.eq((Object)"model_code", (Object)"projectmodel");
        DataModelEntity dataModelEntity = (DataModelEntity)((Object)this.dataModelService.getOne((Wrapper)masterDataModelWrapper));
        QueryWrapper masterDataModelItemWrapper = new QueryWrapper();
        masterDataModelItemWrapper.eq((Object)"data_model_id", (Object)dataModelEntity.getId());
        List dataModelItemEntities = this.dataModelItemService.list((Wrapper)masterDataModelItemWrapper);
        for (int i = 0; i < projectList.size(); ++i) {
            JSONObject project = projectList.getJSONObject(i);
            JSONObject proObj = this.dataModelItemService.queryDataBySourceId("projectmodel", project.getString("id"));
            String executeSql = "";
            if (proObj != null) {
                executeSql = executeSql + "update projectmodel set _last_update_time = now(),_data_type=2,";
                for (DataModelItemEntity modelItem : dataModelItemEntities) {
                    if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) continue;
                    if (StringUtils.isNotBlank((CharSequence)project.getString(modelItem.getItemCode()))) {
                        if ("planStartDate".equals(modelItem.getItemCode()) || "planEndDate".equals(modelItem.getItemCode())) {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                            executeSql = executeSql + "`" + modelItem.getItemCode() + "`='" + format.format(project.getDate(modelItem.getItemCode())) + "',";
                            continue;
                        }
                        executeSql = executeSql + "`" + modelItem.getItemCode() + "`='" + (project.getString(modelItem.getItemCode()) != null ? project.getString(modelItem.getItemCode()) : "") + "',";
                        continue;
                    }
                    executeSql = executeSql + "`" + modelItem.getItemCode() + "`=null,";
                }
                executeSql = executeSql.substring(0, executeSql.length() - 1);
                executeSql = executeSql + " where _source_id='" + project.getString("id") + "'";
                this.dataModelItemService.executeUpdateSql(executeSql);
                continue;
            }
            executeSql = "insert into projectmodel";
            String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id, ";
            String valueSql = " values(" + IdWorker.getId() + ",now(),1,'" + project.getString("id") + "', ";
            for (DataModelItemEntity modelItem : dataModelItemEntities) {
                if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) continue;
                String itemCode = modelItem.getItemCode();
                fieldSql = fieldSql + "`" + itemCode + "`,";
                if (StringUtils.isNotBlank((CharSequence)project.getString(itemCode))) {
                    if ("planStartDate".equals(modelItem.getItemCode()) || "planEndDate".equals(modelItem.getItemCode())) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                        valueSql = valueSql + "'" + format.format(project.getDate(modelItem.getItemCode())) + "',";
                        continue;
                    }
                    valueSql = valueSql + "'" + (project.getString(itemCode) != null ? project.getString(itemCode) : "") + "',";
                    continue;
                }
                valueSql = valueSql + "null,";
            }
            fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
            valueSql = valueSql.substring(0, valueSql.length() - 1);
            fieldSql = fieldSql + ")";
            valueSql = valueSql + ")";
            executeSql = executeSql + fieldSql + valueSql;
            this.dataModelItemService.executeInsertSql(executeSql);
        }
    }

    @RequestMapping(value={"/supplier"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncSupplier(HttpServletRequest request) {
        this.logger.info(">>>>{}>>>>\u90d1\u5dde\u4e00\u5efa \u540c\u6b65\u4f9b\u5e94\u5546\u6570\u636estart...", (Object)this.getDateTime());
        try {
            QueryParam param = new QueryParam();
            boolean has = true;
            int pageSize = 50;
            int pageNum = 1;
            while (has) {
                param.setPageSize(pageSize);
                param.setPageIndex(pageNum);
                String resp = HttpTookitZzyj.postJson(this.baseHost + "ejc-share-web/zzyj/mdm/supplier/sync", JSONObject.toJSONString((Object)param));
                if (!StringUtils.isNotEmpty((CharSequence)resp)) continue;
                JSONObject r = JSONObject.parseObject((String)resp);
                if (r.getInteger("code") == 0 && r.get((Object)"data") != null) {
                    JSONArray supplierList = r.getJSONArray("data");
                    this.saveOrUpdateSupplier(supplierList);
                    ++pageNum;
                    continue;
                }
                has = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(">>>>\u90d1\u5dde\u4e00\u5efa\u540c\u6b65 \u4f9b\u5e94\u5546\u62a5\u9519---------", (Throwable)e);
        }
        return CommonResponse.success((String)(">>>>" + this.getDateTime() + ">>>>\u90d1\u5dde\u4e00\u5efa\u540c\u6b65 \u4f9b\u5e94\u5546\u6267\u884c\u5b8c\u6bd5!"));
    }

    private void saveOrUpdateSupplier(JSONArray supplierList) {
        QueryWrapper masterDataModelWrapper = new QueryWrapper();
        masterDataModelWrapper.eq((Object)"model_code", (Object)"suppliermodel");
        DataModelEntity dataModelEntity = (DataModelEntity)((Object)this.dataModelService.getOne((Wrapper)masterDataModelWrapper));
        QueryWrapper masterDataModelItemWrapper = new QueryWrapper();
        masterDataModelItemWrapper.eq((Object)"data_model_id", (Object)dataModelEntity.getId());
        List dataModelItemEntities = this.dataModelItemService.list((Wrapper)masterDataModelItemWrapper);
        for (int i = 0; i < supplierList.size(); ++i) {
            JSONObject project = supplierList.getJSONObject(i);
            JSONObject proObj = this.dataModelItemService.queryDataBySourceId("projectmodel", project.getString("id"));
            String executeSql = "";
            if (proObj != null) {
                executeSql = executeSql + "update suppliermodel set _last_update_time = now(),_data_type=2,";
                for (DataModelItemEntity modelItem : dataModelItemEntities) {
                    if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) continue;
                    if (StringUtils.isNotBlank((CharSequence)project.getString(modelItem.getItemCode()))) {
                        if ("registTime".equals(modelItem.getItemCode()) || "blTime".equals(modelItem.getItemCode())) {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                            executeSql = executeSql + "`" + modelItem.getItemCode() + "`='" + format.format(project.getDate(modelItem.getItemCode())) + "',";
                            continue;
                        }
                        executeSql = executeSql + "`" + modelItem.getItemCode() + "`='" + (project.getString(modelItem.getItemCode()) != null ? project.getString(modelItem.getItemCode()) : "") + "',";
                        continue;
                    }
                    executeSql = executeSql + "`" + modelItem.getItemCode() + "`=null,";
                }
                executeSql = executeSql.substring(0, executeSql.length() - 1);
                executeSql = executeSql + " where _source_id='" + project.getString("id") + "'";
                this.dataModelItemService.executeUpdateSql(executeSql);
                continue;
            }
            executeSql = "insert into suppliermodel";
            String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id, ";
            String valueSql = " values(" + IdWorker.getId() + ",now(),1,'" + project.getString("id") + "', ";
            for (DataModelItemEntity modelItem : dataModelItemEntities) {
                if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) continue;
                String itemCode = modelItem.getItemCode();
                fieldSql = fieldSql + "`" + itemCode + "`,";
                if (StringUtils.isNotBlank((CharSequence)project.getString(itemCode))) {
                    if ("registTime".equals(modelItem.getItemCode()) || "blTime".equals(modelItem.getItemCode())) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                        valueSql = valueSql + "'" + format.format(project.getDate(modelItem.getItemCode())) + "',";
                        continue;
                    }
                    valueSql = valueSql + "'" + (project.getString(itemCode) != null ? project.getString(itemCode) : "") + "',";
                    continue;
                }
                valueSql = valueSql + "null,";
            }
            fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
            valueSql = valueSql.substring(0, valueSql.length() - 1);
            fieldSql = fieldSql + ")";
            valueSql = valueSql + ")";
            executeSql = executeSql + fieldSql + valueSql;
            this.dataModelItemService.executeInsertSql(executeSql);
        }
    }

    @RequestMapping(value={"/customer"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncCustomer(HttpServletRequest request) {
        this.logger.info(">>>>{}>>>>\u90d1\u5dde\u4e00\u5efa \u540c\u6b65\u5ba2\u6237\u6570\u636estart...", (Object)this.getDateTime());
        try {
            QueryParam param = new QueryParam();
            boolean has = true;
            int pageSize = 50;
            int pageNum = 1;
            while (has) {
                param.setPageSize(pageSize);
                param.setPageIndex(pageNum);
                String resp = HttpTookitZzyj.postJson(this.baseHost + "ejc-share-web/zzyj/mdm/customer/sync", JSONObject.toJSONString((Object)param));
                if (!StringUtils.isNotEmpty((CharSequence)resp)) continue;
                JSONObject r = JSONObject.parseObject((String)resp);
                if (r.getInteger("code") == 0 && r.get((Object)"data") != null) {
                    JSONArray customerList = r.getJSONArray("data");
                    this.saveOrUpdateCustomer(customerList);
                    ++pageNum;
                    continue;
                }
                has = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(">>>>\u90d1\u5dde\u4e00\u5efa\u540c\u6b65 \u5ba2\u6237\u62a5\u9519---------", (Throwable)e);
        }
        return CommonResponse.success((String)(">>>>" + this.getDateTime() + ">>>>\u90d1\u5dde\u4e00\u5efa\u540c\u6b65 \u5ba2\u6237\u6267\u884c\u5b8c\u6bd5!"));
    }

    private void saveOrUpdateCustomer(JSONArray customerList) {
        QueryWrapper masterDataModelWrapper = new QueryWrapper();
        masterDataModelWrapper.eq((Object)"model_code", (Object)"customermodel");
        DataModelEntity dataModelEntity = (DataModelEntity)((Object)this.dataModelService.getOne((Wrapper)masterDataModelWrapper));
        QueryWrapper masterDataModelItemWrapper = new QueryWrapper();
        masterDataModelItemWrapper.eq((Object)"data_model_id", (Object)dataModelEntity.getId());
        List dataModelItemEntities = this.dataModelItemService.list((Wrapper)masterDataModelItemWrapper);
        for (int i = 0; i < customerList.size(); ++i) {
            JSONObject project = customerList.getJSONObject(i);
            JSONObject proObj = this.dataModelItemService.queryDataBySourceId("customermodel", project.getString("id"));
            String executeSql = "";
            if (proObj != null) {
                executeSql = executeSql + "update customermodel set _last_update_time = now(),_data_type=2,";
                for (DataModelItemEntity modelItem : dataModelItemEntities) {
                    if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) continue;
                    if (StringUtils.isNotBlank((CharSequence)project.getString(modelItem.getItemCode()))) {
                        executeSql = executeSql + "`" + modelItem.getItemCode() + "`='" + (project.getString(modelItem.getItemCode()) != null ? project.getString(modelItem.getItemCode()) : "") + "',";
                        continue;
                    }
                    executeSql = executeSql + "`" + modelItem.getItemCode() + "`=null,";
                }
                executeSql = executeSql.substring(0, executeSql.length() - 1);
                executeSql = executeSql + " where _source_id='" + project.getString("id") + "'";
                this.dataModelItemService.executeUpdateSql(executeSql);
                continue;
            }
            executeSql = "insert into customermodel";
            String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id, ";
            String valueSql = " values(" + IdWorker.getId() + ",now(),1,'" + project.getString("id") + "', ";
            for (DataModelItemEntity modelItem : dataModelItemEntities) {
                if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) continue;
                String itemCode = modelItem.getItemCode();
                fieldSql = fieldSql + "`" + itemCode + "`,";
                if (StringUtils.isNotBlank((CharSequence)project.getString(itemCode))) {
                    valueSql = valueSql + "'" + (project.getString(itemCode) != null ? project.getString(itemCode) : "") + "',";
                    continue;
                }
                valueSql = valueSql + "null,";
            }
            fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
            valueSql = valueSql.substring(0, valueSql.length() - 1);
            fieldSql = fieldSql + ")";
            valueSql = valueSql + ")";
            executeSql = executeSql + fieldSql + valueSql;
            this.dataModelItemService.executeInsertSql(executeSql);
        }
    }
}

