package com.ejianc.foundation.mdm.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 数据模型表
 * 
 * @author guoming
 *
 */
@TableName("ejc_mdm_datamodel")
public class DataModelEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
	 * 数据模型分类ID
	 */
	@TableField(value = "category_id")
	private Long categoryId;

	@TableField(exist = false)
	private String categoryName;

	/**
	 * 父ID
	 */
	@TableField(value = "parent_id")
	private Long parentId;

	/**
	 * 数据模型编码
	 */
	@TableField(value = "model_code")
	private String modelCode;

	/**
	 * 数据模型名称
	 */
	@TableField(value = "model_name")
	private String modelName;

	/**
	 * 数据模型排序
	 */
	@TableField(value = "sequence")
	private Integer sequence;

	/**
	 * 是否发布： 1已发布， 0未发布
	 */
	@TableField(value = "publish_flag")
	private Integer publishFlag;

	@TableField(exist = false)
	private Boolean hasChildren;

	public Long getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(Long categoryId) {
		this.categoryId = categoryId;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public String getModelCode() {
		return modelCode;
	}

	public void setModelCode(String modelCode) {
		this.modelCode = modelCode;
	}

	public String getModelName() {
		return modelName;
	}

	public void setModelName(String modelName) {
		this.modelName = modelName;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public Integer getPublishFlag() {
		return publishFlag;
	}

	public void setPublishFlag(Integer publishFlag) {
		this.publishFlag = publishFlag;
	}

	public Boolean getHasChildren() {
		return hasChildren;
	}

	public void setHasChildren(Boolean hasChildren) {
		this.hasChildren = hasChildren;
	}

}
