package com.ejianc.foundation.mdm.controller;

import java.io.Serializable;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.mdm.bean.ThirdSystemEntity;
import com.ejianc.foundation.mdm.service.IThirdSystemService;
import com.ejianc.foundation.mdm.vo.ThirdSystemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import cn.hutool.core.lang.UUID;

@RestController
@RequestMapping("/thirdsys/")
public class ThirdSystemController implements Serializable {

	private static final long serialVersionUID = 1L;
	
	@Autowired
	private IThirdSystemService thirdSystemService;

	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody ThirdSystemVO thirdSystemVo) {
		QueryWrapper<ThirdSystemEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("system_code", thirdSystemVo.getSystemCode());
		ThirdSystemEntity thirdSystemEntity = thirdSystemService.getOne(queryWrapper);
		
		if(thirdSystemVo.getId() != null && thirdSystemVo.getId() > 0) {
			if(thirdSystemEntity != null && !thirdSystemEntity.getId().equals(thirdSystemVo.getId())) {
				return CommonResponse.error("修改失败：系统编码与【" + thirdSystemEntity.getSystemName() + "】重复！");
			}
			ThirdSystemEntity uniqueBean = thirdSystemService.getById(thirdSystemVo.getId());
			uniqueBean.setSystemType(thirdSystemVo.getSystemType());
			uniqueBean.setSystemCode(thirdSystemVo.getSystemCode());
			uniqueBean.setSystemName(thirdSystemVo.getSystemName());
			uniqueBean.setServiceUrl(thirdSystemVo.getServiceUrl());
			uniqueBean.setEnableFlag(thirdSystemVo.getEnableFlag());
			uniqueBean.setSequence(thirdSystemVo.getSequence());
			
			thirdSystemService.saveOrUpdate(uniqueBean, false);
			return CommonResponse.success("修改成功");
		}else{
			if(thirdSystemEntity != null) {
				return CommonResponse.error("修改失败：系统编码与【" + thirdSystemEntity.getSystemName() + "】重复！");
			}
			ThirdSystemEntity saveBean = BeanMapper.map(thirdSystemVo, ThirdSystemEntity.class);
			saveBean.setTicket(UUID.randomUUID().toString());
			thirdSystemService.saveOrUpdate(saveBean, false);
			return CommonResponse.success("保存成功");
		}
	}
	
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<ThirdSystemVO> queryDetail(@RequestParam Long id) {
		ThirdSystemEntity uniqueBean = thirdSystemService.getById(id);
		ThirdSystemVO thirdSystemVo = BeanMapper.map(uniqueBean, ThirdSystemVO.class);
		return CommonResponse.success(thirdSystemVo);
	}
	
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		thirdSystemService.removeByIds(ids);
		return CommonResponse.success("删除成功");
	}

	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<ThirdSystemEntity>> pageList(@RequestBody QueryParam queryParam) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
		queryParam.getOrderMap().put("sequence", QueryParam.ASC);
		IPage<ThirdSystemEntity> pageData = thirdSystemService.queryPage(queryParam, false);
		return CommonResponse.success(pageData);
	}
	
}
