package com.ejianc.foundation.mdm.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 数据清洗规则
 * 
 * @author guoming
 *
 */
@TableName("ejc_mdm_dataclean_rule_detail")
public class DataCleanRuleDetailEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
	 * 规则ID
	 */
	@TableField(value = "rule_id")
	private Long ruleId;

	/**
	 * 数据模型项Id
	 */
	@TableField(value = "data_model_item_id")
	private Long dataModelItemId;

	/**
	 * 规则类型： 1字段去重，2必填判断，3邮箱判断，4整数判断，5金额判断，6日期判断，7参照类型
	 */
	@TableField(value = "rule_type")
	private String ruleType;

	/**
	 * 模型编码：当ruleType为参照类型时选择，参照的数据模型
	 */
	@TableField(value = "model_code")
	private String modelCode;

	public Long getRuleId() {
		return ruleId;
	}

	public void setRuleId(Long ruleId) {
		this.ruleId = ruleId;
	}

	public Long getDataModelItemId() {
		return dataModelItemId;
	}

	public void setDataModelItemId(Long dataModelItemId) {
		this.dataModelItemId = dataModelItemId;
	}

	public String getRuleType() {
		return ruleType;
	}

	public void setRuleType(String ruleType) {
		this.ruleType = ruleType;
	}

	public String getModelCode() {
		return modelCode;
	}

	public void setModelCode(String modelCode) {
		this.modelCode = modelCode;
	}

}
