package com.ejianc.foundation.mdm.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.mdm.bean.DataModelEntity;
import com.ejianc.foundation.mdm.bean.DataModelItemEntity;
import com.ejianc.foundation.mdm.service.IDataModelItemService;
import com.ejianc.foundation.mdm.service.IDataModelService;
import com.ejianc.foundation.mdm.vo.DataModelItemVO;
import com.ejianc.foundation.mdm.vo.DataModelVO;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.http.Header;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.http.HttpResponseHandler;
import com.ejianc.framework.core.http.NameValuePair;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@RestController
@RequestMapping("/datamodel/")
public class DataModelController implements Serializable {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final long serialVersionUID = 1L;

    @Value("${common.env.base-host}")
    private String baseHost;
	
	@Autowired
	private IDataModelService dataModelService;
	
	@Autowired
	private IDataModelItemService dataModelItemService;
	
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<DataModelVO> saveOrUpdate(@RequestBody DataModelVO dataModelVo) {
		return dataModelService.saveOrUpdate(dataModelVo);
	}
	
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<DataModelVO> queryDetail(@RequestParam Long id) {
		DataModelVO dataModelVo = dataModelService.queryDetail(id);
		return CommonResponse.success(dataModelVo);
	}
	
	@RequestMapping(value = "/delete", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> delete(@RequestParam Long id) {
		return dataModelService.delete(id);
	}
	
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<DataModelEntity>> pageList(@RequestBody QueryParam queryParam) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
		queryParam.getOrderMap().put("sequence", QueryParam.ASC);
		IPage<DataModelEntity> pageData = dataModelService.queryDataModelPage(queryParam);
		return CommonResponse.success(pageData);
	}
	
	@RequestMapping(value = "/queryChildren", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<DataModelEntity>> queryChildren(@RequestParam Long dataModelId) {
		List<DataModelEntity> dataModelEntities = dataModelService.queryChildren(dataModelId);
		return CommonResponse.success(dataModelEntities);
	}
	
	@RequestMapping(value = "/publish", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> publishDataModel(@RequestParam Long dataModelId) {
		dataModelService.publishDataModel(dataModelId);
		return CommonResponse.success();
	}
	
	@RequestMapping(value = "/queryTree", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<DataModelVO>> queryTree() {
		List<DataModelEntity> entitys = dataModelService.list();
		List<DataModelVO> dataList = BeanMapper.mapList(entitys, DataModelVO.class);
		List<DataModelVO> vos = createTreeDataVO(dataList);
		return CommonResponse.success(vos);
	}
	
	@RequestMapping(value = "/queryItems", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<JSONObject> queryItems(@RequestParam Long id) {
		DataModelVO dataModelVo = dataModelService.queryDetail(id);
		JSONObject json = new JSONObject();
		if(dataModelVo!=null){
			json.put("dataModelCode", dataModelVo.getModelCode());
			if(dataModelVo.getDataModelItemVos()!=null&&dataModelVo.getDataModelItemVos().size()>0){
//				List<String> items = new ArrayList<>();
				JSONObject items = new JSONObject();
				dataModelVo.getDataModelItemVos().forEach(e -> {
//					items.add(e.getItemCode());
					items.put(e.getItemCode(), e.getItemName());
				});
				json.put("items", items);
			}
			//获取子节点---
			QueryWrapper<DataModelEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("parent_id", id);
			List<DataModelEntity> dataList = dataModelService.list(queryWrapper);
			if(dataList!=null&&dataList.size()>0){
				JSONArray array = new JSONArray();
				for(DataModelEntity entity : dataList){
					JSONObject children = new JSONObject();
					children.put("dataModelCode", entity.getModelCode());
					//查询模型项
					QueryWrapper<DataModelItemEntity> itemQueryWrapper = new QueryWrapper<>();
					itemQueryWrapper.eq("data_model_id", entity.getId());
					itemQueryWrapper.orderByAsc("sequence");
					List<DataModelItemEntity> itemEntities = dataModelItemService.list(itemQueryWrapper);
					if(itemEntities!=null&&itemEntities.size()>0){
//						List<String> items = new ArrayList<>();
						JSONObject items = new JSONObject();
						itemEntities.forEach(e -> {
//							items.add(e.getItemCode());
							items.put(e.getItemCode(), e.getItemName());
						});
						children.put("items", items);
					}
					array.add(children);
				}
				json.put("children", array);
			}
		}
		return CommonResponse.success(json);
	}
	
	public static List<DataModelVO> createTreeDataVO(List<DataModelVO> list) {
		List<DataModelVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, DataModelVO> listMap = new HashMap<>();
		for(DataModelVO orgEntity:list) {
			orgEntity.setKey(orgEntity.getId());
			listMap.put(orgEntity.getId().toString(), orgEntity);
		}
        
        for(int i =0; i<list.size(); i++) {
        	DataModelVO orgEntity = list.get(i);
        	String parentId = (orgEntity.getParentId() != null && orgEntity.getParentId() > 0) ? orgEntity.getParentId().toString():"";
        	DataModelVO parent = listMap.get(parentId);
        	if(parent != null) {
        		List<DataModelVO> child = parent.getChildren();
        		if(child != null) {
        			child.add(orgEntity);
        		}else{
        			List<DataModelVO> children = new ArrayList<DataModelVO>();
        			children.add(orgEntity);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(orgEntity.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}


    /**
     * 参照定义
     * 
     * @param refCode
     * @return
     */
    @RequestMapping(value = "/findByCode", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReferVO> findByCode(@RequestParam String refCode) {
        ReferVO refer = new ReferVO();
        List<ReferShowfieldVO> gridHeaders = new ArrayList<>();
        ReferShowfieldVO idHeader = new ReferShowfieldVO();
        ReferShowfieldVO nameHeader = new ReferShowfieldVO();
        ReferShowfieldVO codeHeader = new ReferShowfieldVO();
        switch(refCode){
            case "dataModel":
                refer.setRefCode("dataModel");
                refer.setRefName("数据模型");
                refer.setRefType("grid");
                refer.setDataurl(baseHost + "ejc-mdm-web/datamodel/queryDataModelReferList");
                refer.setIdField("id");
                refer.setCodeField("modelCode");
                refer.setNameField("modelName");
                refer.setId(23332323L);
                idHeader.setId(1l);
                idHeader.setName("主键");
                idHeader.setCode("id");
                idHeader.setHidden(true);
                idHeader.setShowOrder("0");
                idHeader.setType("string");
                gridHeaders.add(idHeader);
                codeHeader.setId(2l);
                codeHeader.setName("数据模型编码");
                codeHeader.setCode("modelCode");
                codeHeader.setHidden(false);
                codeHeader.setShowOrder("1");
                codeHeader.setType("string");
                gridHeaders.add(codeHeader);
                nameHeader.setId(3l);
                nameHeader.setName("数据模型名称");
                nameHeader.setCode("modelName");
                nameHeader.setHidden(false);
                nameHeader.setShowOrder("2");
                nameHeader.setType("string");
                gridHeaders.add(nameHeader);
                refer.setGridheaders(gridHeaders);
                break;
            case "dataModelItem":
                refer.setRefCode("dataModelItem");
                refer.setRefName("数据模型字段");
                refer.setRefType("grid");
                refer.setDataurl(baseHost + "ejc-mdm-web/datamodel/queryDataModelItemReferList");
                refer.setIdField("id");
                refer.setCodeField("itemCode");
                refer.setNameField("itemName");
                refer.setId(23332323L);
                idHeader.setId(1l);
                idHeader.setName("主键");
                idHeader.setCode("id");
                idHeader.setHidden(true);
                idHeader.setShowOrder("0");
                idHeader.setType("string");
                gridHeaders.add(idHeader);
                codeHeader.setId(2l);
                codeHeader.setName("模型字段编码");
                codeHeader.setCode("itemCode");
                codeHeader.setHidden(false);
                codeHeader.setShowOrder("1");
                codeHeader.setType("string");
                gridHeaders.add(codeHeader);
                nameHeader.setId(3l);
                nameHeader.setName("模型字段名称");
                nameHeader.setCode("itemName");
                nameHeader.setHidden(false);
                nameHeader.setShowOrder("2");
                nameHeader.setType("string");
                gridHeaders.add(nameHeader);
                ReferShowfieldVO dataTypeHeader = new ReferShowfieldVO();
                dataTypeHeader.setId(4l);
                dataTypeHeader.setName("数据类型");
                dataTypeHeader.setCode("dataType");
                dataTypeHeader.setHidden(false);
                dataTypeHeader.setShowOrder("3");
                dataTypeHeader.setType("string");
                gridHeaders.add(dataTypeHeader);
                refer.setGridheaders(gridHeaders);
                break;
        }

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", refer);
        return CommonResponse.success(refer);
    }

    /**
     * 参照数据模型列表
     * 
     * @param condition
     * @param searchText
     * @param pageSize
     * @param pageNumber
     * @return
     */
	@RequestMapping(value = "/queryDataModelReferList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DataModelVO>> queryDataModelReferList(@RequestParam(required = false) String condition,
                                    @RequestParam(required = false) String searchText,
                                    @RequestParam(required = true) int pageSize,
                                    @RequestParam(required = true) int pageNumber) {
        QueryParam queryParam = new QueryParam();
		Long tenantId = InvocationInfoProxy.getTenantid();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
		queryParam.getParams().put("publishFlag", new Parameter(QueryParam.EQ, 1));
		queryParam.getParams().put("refer", new Parameter(QueryParam.EQ, "true"));
		
		queryParam.getOrderMap().put("sequence", QueryParam.ASC);
		queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("modelCode");
        fuzzyFields.add("modelName");
        
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
		IPage<DataModelEntity> ePage = dataModelService.queryDataModelPage(queryParam);
        IPage<DataModelVO> pageData = new Page<>(ePage.getCurrent(), ePage.getSize(), ePage.getTotal());
        pageData.setRecords(BeanMapper.mapList(ePage.getRecords(), DataModelVO.class));

        return CommonResponse.success("查询数据模型列表成功！", pageData);
    }

    /**
     * 参照数据模型列表
     * 
     * @param condition
     * @param searchText
     * @param pageSize
     * @param pageNumber
     * @return
     */
	@RequestMapping(value = "/queryDataModelItemReferList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DataModelItemVO>> queryDataModelItemReferList(@RequestParam(required = false) String condition,
                                    @RequestParam(required = false) String searchText,
                                    @RequestParam(required = true) int pageSize,
                                    @RequestParam(required = true) int pageNumber) {

        QueryParam queryParam = new QueryParam();
		if(condition!=null){
			//当传参orgorgId为取传入的参数，否则是从上下信息中获取
			JSONObject cond = JSONObject.parseObject(condition);
			if(cond.get("dataModelId")!=null){
				queryParam.getParams().put("dataModelId", new Parameter(QueryParam.EQ, Long.parseLong(cond.get("dataModelId").toString())));
			}
		}
		Long tenantId = InvocationInfoProxy.getTenantid();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
		queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("itemCode");
        fuzzyFields.add("itemName");
        
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
		IPage<DataModelItemEntity> ePage = dataModelItemService.queryPage(queryParam);
        IPage<DataModelItemVO> pageData = new Page<>(ePage.getCurrent(), ePage.getSize(), ePage.getTotal());
        pageData.setRecords(BeanMapper.mapList(ePage.getRecords(), DataModelItemVO.class));

        return CommonResponse.success("查询数据模型列表成功！", pageData);
    }
	
	@RequestMapping(value = "/operateDataSync", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> operateDataSync(HttpServletRequest request, @RequestParam Long dataModelId) {
		DataModelEntity dataModelEntity = dataModelService.getById(dataModelId);
		if(dataModelEntity != null) {
			if(StringUtils.isNotBlank(dataModelEntity.getSyncAddress())) {
				String syncAddr = baseHost + dataModelEntity.getSyncAddress();
				logger.info("syncAddr="+syncAddr);
				String authority = request.getHeader("authority");
				logger.info("authority="+authority);
				Thread syncOperate = new Thread(new Runnable() {
					@Override
					public void run() {
						Header[] headers = {new Header("authority", authority)} ;
						List<NameValuePair> params = new ArrayList<>();
						HttpClientUtils.getInstance().post(syncAddr,headers, params, new HttpResponseHandler() {

							@Override
							public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
							}

							@Override
							public void onFailure(int status, byte[] data) {
								super.onFailure(status, data);
							}
						});
					}
				});
				syncOperate.run();
			}else{
				return CommonResponse.error("同步地址不能为空！");
			}
		}
		return CommonResponse.success();
	}
}
