package com.ejianc.foundation.mdm.controller;

import java.io.BufferedOutputStream;
import java.io.Serializable;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.mdm.bean.DataTransferLogEntity;
import com.ejianc.foundation.mdm.service.IDataTransferLogService;
import com.ejianc.foundation.mdm.vo.DataTransferLogVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;

@RestController
@RequestMapping("/transferlog/")
public class DataTransferLogController implements Serializable {

	private static final long serialVersionUID = 1L;
	
	@Autowired
	private IDataTransferLogService dataTransferLogService;
	
	
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
		IPage<DataTransferLogVO> pageData = dataTransferLogService.queryDataTransferLogPage(queryParam);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", pageData);
		return CommonResponse.success(jsonObject);
	}
	
	@RequestMapping(value = "/downloadRespData")
	public void downloadRespData(@RequestParam Long id, HttpServletResponse response) {
		
		DataTransferLogEntity dataTransferLogEntity = dataTransferLogService.getById(id);
		
		response.setContentType("text/plain");
        response.addHeader("Content-Disposition", "attachment;filename=respData.txt");
        BufferedOutputStream buff = null;  
        ServletOutputStream outSTr = null;  
        try {  
            outSTr = response.getOutputStream();// 建立  
            buff = new BufferedOutputStream(outSTr);  
            buff.write(dataTransferLogEntity.getCallResp().getBytes("UTF-8"));  
            buff.flush();  
            buff.close();  
        } catch (Exception e) {  
            e.printStackTrace();  
        } finally {  
            try {  
                buff.close();  
                outSTr.close();  
            } catch (Exception e) {  
                e.printStackTrace();  
            }  
        }  
	}
}
