package com.ejianc.foundation.mdm.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 数据模型字段表
 * 
 * @author guoming
 *
 */
@TableName("ejc_mdm_datamodel_item")
public class DataModelItemEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
	 * 数据模型ID
	 */
	@TableField(value = "data_model_id")
	private Long dataModelId;
	/**
	 * 模型字段编码
	 */
	@TableField(value = "item_code")
	private String itemCode;
	/**
	 * 模型字段名称
	 */
	@TableField(value = "item_name")
	private String itemName;
	/**
	 * 数据类型
	 */
	@TableField(value = "data_type")
	private String dataType;
	/**
	 * 数据长度
	 */
	@TableField(value = "data_length")
	private Integer dataLength;
	/**
	 * 小数位
	 */
	@TableField(value = "decimal_place")
	private Integer decimalPlace;
	/**
	 * 是否唯一： 0不唯一，1：唯一
	 */
	@TableField(value = "unique_flag")
	private Boolean uniqueFlag;
	/**
	 * 是否必填：0不必填 ，1必填
	 */
	@TableField(value = "must_fill_flag")
	private Boolean mustFillFlag;

	/**
	 * 参照编码
	 */
	@TableField(value = "refer_code")
	private String referCode;

	/**
	 * 枚举档案编码
	 */
	@TableField(value = "defdoc_code")
	private String defdocCode;
	/**
	 * 是否作为查询条件：0不作为，1作为查询条件
	 */
	@TableField(value = "query_condition_flag")
	private Boolean queryConditionFlag;
	/**
	 * 排序字段
	 */
	@TableField(value = "sequence")
	private Integer sequence;

	/**
	 * 描述信息
	 */
	@TableField(value = "description")
	private String description;

	/**
	 * 排序值
	 */
	@TableField(value = "sort_value")
	private String sortValue;

	public Long getDataModelId() {
		return dataModelId;
	}

	public void setDataModelId(Long dataModelId) {
		this.dataModelId = dataModelId;
	}

	public String getItemCode() {
		return itemCode;
	}

	public void setItemCode(String itemCode) {
		this.itemCode = itemCode;
	}

	public String getItemName() {
		return itemName;
	}

	public void setItemName(String itemName) {
		this.itemName = itemName;
	}

	public String getDataType() {
		return dataType;
	}

	public void setDataType(String dataType) {
		this.dataType = dataType;
	}

	public Integer getDataLength() {
		return dataLength;
	}

	public void setDataLength(Integer dataLength) {
		this.dataLength = dataLength;
	}

	public Integer getDecimalPlace() {
		return decimalPlace;
	}

	public void setDecimalPlace(Integer decimalPlace) {
		this.decimalPlace = decimalPlace;
	}

	public Boolean getUniqueFlag() {
		return uniqueFlag;
	}

	public void setUniqueFlag(Boolean uniqueFlag) {
		this.uniqueFlag = uniqueFlag;
	}

	public Boolean getMustFillFlag() {
		return mustFillFlag;
	}

	public void setMustFillFlag(Boolean mustFillFlag) {
		this.mustFillFlag = mustFillFlag;
	}

	public String getReferCode() {
		return referCode;
	}

	public void setReferCode(String referCode) {
		this.referCode = referCode;
	}

	public String getDefdocCode() {
		return defdocCode;
	}

	public void setDefdocCode(String defdocCode) {
		this.defdocCode = defdocCode;
	}

	public Boolean getQueryConditionFlag() {
		return queryConditionFlag;
	}

	public void setQueryConditionFlag(Boolean queryConditionFlag) {
		this.queryConditionFlag = queryConditionFlag;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getSortValue() {
		return sortValue;
	}

	public void setSortValue(String sortValue) {
		this.sortValue = sortValue;
	}

}
