package com.ejianc.foundation.bulidMaterialMdm.controller;

import java.io.Serializable;


import com.ejianc.foundation.bulidMaterialMdm.bean.MaterialUserEntity;
import com.ejianc.foundation.bulidMaterialMdm.mapper.UserMapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.bulidMaterialMdm.bean.MaterialUserTransferEntity;
import com.ejianc.foundation.bulidMaterialMdm.service.IMaterialUserTransferService;
import com.ejianc.foundation.bulidMaterialMdm.vo.MaterialUserTransferVO;

/**
 * 人员调换部门
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialUserTransfer")
public class MaterialUserTransferController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IMaterialUserTransferService service;
    @Autowired
    private UserMapper userMapper;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialUserTransferVO> saveOrUpdate(@RequestBody MaterialUserTransferVO saveOrUpdateVO) {
    	MaterialUserTransferEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialUserTransferEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
        }
    	service.saveOrUpdate(entity, false);
    	MaterialUserTransferVO vo = BeanMapper.map(entity, MaterialUserTransferVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * @Description updateState 修改状态
     */
    @RequestMapping(value = "/updateState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateState(@RequestParam("id") Long id) {
        MaterialUserTransferEntity entity = service.selectById(id);
        entity.setTransferState(1);
        service.saveOrUpdate(entity);

        //更新中间库的部门id
        MaterialUserEntity materialUserEntity = new MaterialUserEntity();
        materialUserEntity.setUserId(entity.getUserId());
        materialUserEntity.setLastUpdateTime(new Date());
        materialUserEntity.setDepartmentId(entity.getDepartmentIdNew());
        userMapper.updateUserDeptId(materialUserEntity);
        return CommonResponse.success("保存或修改单据成功！");
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialUserTransferVO> queryDetail(Long id) {
    	MaterialUserTransferEntity entity = service.selectById(id);
    	MaterialUserTransferVO vo = BeanMapper.map(entity, MaterialUserTransferVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialUserTransferVO> vos) {
        service.removeByIds(vos.stream().map(MaterialUserTransferVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialUserTransferVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams()
                .put("transferState", new Parameter(QueryParam.EQ, 2));
        IPage<MaterialUserTransferEntity> page = service.queryPage(param,false);
        IPage<MaterialUserTransferVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialUserTransferVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }




    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refMaterialUserTransferData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialUserTransferVO>> refMaterialUserTransferData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialUserTransferEntity> page = service.queryPage(param,false);
        IPage<MaterialUserTransferVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialUserTransferVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
