package com.ejianc.foundation.bulidMaterialMdm.mapper;


import com.ejianc.foundation.bulidMaterialMdm.bean.MadOrgEntity;
import com.ejianc.foundation.bulidMaterialMdm.bean.MadRecordEntity;
import com.ejianc.foundation.bulidMaterialMdm.bean.MaterialOrgEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 筑材信息
 * 
 * @author generator
 * 
 */
@Mapper
public interface OrgMapper extends BaseCrudMapper<MadOrgEntity> {
    /**
     *获取要同步的组织数据
     */
    @Select("SELECT md.* FROM `orgmodel` md\n" +
            "LEFT JOIN ejc_buildmaterial_org ma\n" +
            "on ma.mdm_id = md._master_data_id\n" +
            " where DATE_SUB(CURDATE(),INTERVAL 1 DAY) <= Date(md._last_update_time)\n" +
            " and ( ma.id is null or ma.last_update_time < md._last_update_time)")
    List<MadOrgEntity> getTodayUpdateData();

    /**
     *中间记录表新增数据
     */
    @Insert("INSERT INTO `ejc_buildmaterial_record`(mdm_id,send_time,bill_type,is_success,error_reason) VALUE(#{mdmId},#{sendTime},#{billType},#{isSuccess},#{errorReason})")
    Integer insertSendRecord(MadRecordEntity entity);

    /**
     * 根据主数据id获取筑材网id
     */
    @Select("SELECT material_id FROM `ejc_buildmaterial_org` where mdm_id = #{mdmId} limit 1")
    Integer getMaterialIdByMdmId(Long mdmId);

    /**
     *组织中间表新增数据
     */
    @Insert("INSERT INTO `ejc_buildmaterial_org`(mdm_id,material_id,last_update_time,data_type,name,parent_id) " +
            "VALUE(#{mdmId},#{materialId},#{lastUpdateTime},#{dataType},#{name},#{parentId})")
    Integer insertOrgInfo(MaterialOrgEntity entity);


    /**
     *组织中间表修改数据
     */
    @Update("update `ejc_buildmaterial_org` set last_update_time = #{lastUpdateTime},name =#{name},parent_id = #{parentId},data_type=#{dataType}\n" +
            "where mdm_id = #{mdmId} and material_id = #{materialId}")
    Integer updateOrgInfo(MaterialOrgEntity entity);


    /**
     *查询库中所有组织个数（删除除外）
     */
    List<MadOrgEntity> selectWithPage(Integer start);

}
