package com.ejianc.foundation.mdm.mapper;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.mdm.bean.DataModelItemEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;

@Mapper
public interface DataModelItemMapper extends BaseCrudMapper<DataModelItemEntity> {

	List<JSONObject> queryMdmDataList(Map<String, Object> modelItemMap);

	List<JSONObject> queryMdmChildDataList(Map<String, Object> childParamMap);

	void deleteChildMdmData(Map<String, Object> childParamMap);

	void deleteMasterMdmData(Map<String, Object> modelItemMap);

	JSONObject queryUniqueByMasterDataId(@Param("tableName") String tableName,@Param("masterDataId") String masterDataId);

	void executeUpdateSql(@Param("executeSql") String executeSql);

	void executeInsertSql(@Param("executeSql") String executeSql);

	void executeDeleteSql(@Param("executeSql") String executeSql);
	
	JSONObject queryDataIsExist(Map<String, String> paramMap);

	JSONObject queryReferData(Map<String, String> referParamMap);

	void executeCreateSql(@Param("createSql") String createSql);

	JSONObject queryDataBySourceId(@Param("tableName") String tableName,@Param("sourceId") String sourceId);

	JSONObject getObjectBySqlCondition(@Param("tableName") String tableName,@Param("sqlCondition") String sqlCondition);

	void deleteMdmDataBySourceIds(@Param("tableName") String tableName,@Param("delSourceIdStr") String delSourceIdStr);

	Long queryMdmDataCount(Map<String, Object> modelItemMap);

	List<JSONObject> queryDataBySql(@Param("sql") String sql);

	Long queryMdmDataStateCount(Map<String, Object> modelItemMap);

	List<JSONObject> queryMdmDataStateList(Map<String, Object> modelItemMap);
}
