/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.bulidMaterialMdm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.bulidMaterialMdm.bean.MadOrgEntity;
import com.ejianc.foundation.bulidMaterialMdm.bean.MadRecordEntity;
import com.ejianc.foundation.bulidMaterialMdm.bean.MaterialOrgEntity;
import com.ejianc.foundation.bulidMaterialMdm.mapper.OrgMapper;
import com.ejianc.foundation.bulidMaterialMdm.service.IOrgService;
import com.ejianc.foundation.bulidMaterialMdm.service.ISystemRequestService;
import com.ejianc.foundation.bulidMaterialMdm.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orgService")
public class OrgService
implements IOrgService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemRequestService requestService;
    @Autowired
    private OrgMapper mapper;

    @Override
    public JSONObject insertOrgInfo(String departmentName, Integer parentId) {
        if (departmentName == null) {
            throw new BusinessException("\u90e8\u95e8\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        JSONObject param = new JSONObject();
        param.put("departmentName", (Object)departmentName);
        if (parentId != null) {
            param.put("parentId", (Object)parentId);
        }
        String responseBody = this.requestService.sendPostRequest("department/add", param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        Integer code = jsonObject.getInteger("code");
        message = code == 0 ? jsonObject.getInteger("object") + "" : jsonObject.getString("message");
        return jsonObject;
    }

    @Override
    public JSONObject updateOrgInfo(Integer departmentId, String departmentName, Integer parentId) {
        if (departmentName == null || departmentId == null) {
            throw new BusinessException("\u90e8\u95e8\u540d\u79f0\u548c\u90e8\u95e8id\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        JSONObject param = new JSONObject();
        param.put("departmentId", (Object)departmentId);
        param.put("departmentName", (Object)departmentName);
        if (parentId != null) {
            param.put("parentId", (Object)parentId);
        }
        String responseBody = this.requestService.sendPostRequest("department/update", param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        Integer code = jsonObject.getInteger("code");
        message = code == 0 ? jsonObject.getString("object") + "" : jsonObject.getString("message");
        return jsonObject;
    }

    @Override
    public OrgVO selectOrgInfo(Integer departmentId) {
        String url = "department/getList";
        JSONObject param = new JSONObject();
        if (departmentId != null) {
            param.put("parentId", (Object)departmentId);
        }
        String responseBody = this.requestService.sendPostRequest(url, param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        Integer code = jsonObject.getInteger("code");
        OrgVO orgVO = null;
        if (code != 0) {
            message = jsonObject.getString("message");
            throw new BusinessException("\u8fd4\u56de\u6570\u636e\u5f02\u5e38\uff01" + message);
        }
        orgVO = (OrgVO)JSONObject.parseObject((String)jsonObject.getString("object"), OrgVO.class);
        return orgVO;
    }

    @Override
    public JSONObject deleteOrgInfo(Integer departmentId) {
        if (departmentId == null) {
            throw new BusinessException("\u90e8\u95e8id\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        JSONObject param = new JSONObject();
        if (departmentId != null) {
            param.put("departmentId", (Object)departmentId);
        }
        String responseBody = this.requestService.sendPostRequest("department/delete/", param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        Integer code = jsonObject.getInteger("code");
        message = code == 0 ? jsonObject.getString("object") + "" : jsonObject.getString("message");
        return jsonObject;
    }

    @Override
    public String orgInfoSyncFirst() {
        this.logger.info("\u7b51\u6750\u7f51\u521d\u59cb\u5316\u540c\u6b65\u7ec4\u7ec7\u4fe1\u606f\u5f00\u59cb---------------->");
        int page = 0;
        boolean flag = true;
        while (flag) {
            int i = page * 100;
            List<MadOrgEntity> todayUpdateData = this.mapper.selectWithPage(i);
            if (todayUpdateData != null && todayUpdateData.size() > 0) {
                for (MadOrgEntity todayUpdateDatum : todayUpdateData) {
                    if (!"\u865a\u62df\u7ec4\u7ec7".equals(todayUpdateDatum.getOrgtype())) {
                        MadRecordEntity entity;
                        Integer materialIdByMdmId = this.mapper.getMaterialIdByMdmId(todayUpdateDatum.getParentid());
                        if (todayUpdateDatum.getParentid().equals(1502571152642412546L) || todayUpdateDatum.getParentid().equals(1502571152701132801L) || todayUpdateDatum.getParentid().equals(1502571152793407490L) || todayUpdateDatum.getParentid().equals(1502571152847933442L) || todayUpdateDatum.getParentid().equals(1502571155922358273L) || todayUpdateDatum.getParentid().equals(1502571152583692289L)) {
                            materialIdByMdmId = null;
                        } else if (materialIdByMdmId == null) {
                            this.logger.info("\u7ec4\u7ec7:{} \u7684\u4e0a\u7ea7\u7ec4\u7ec7\u672a\u540c\u6b65\uff01", (Object)todayUpdateDatum.getName());
                            continue;
                        }
                        this.logger.info("\u7b51\u6750\u7f51\u7ec4\u7ec7\u4fe1\u606f\u65b0\u589e\uff0cid\uff1a{}", (Object)todayUpdateDatum.getMasterDataId());
                        JSONObject jsonObject = this.insertOrgInfo(todayUpdateDatum.getName(), materialIdByMdmId);
                        Integer code = jsonObject.getInteger("code");
                        if (code == 0) {
                            Integer materialId = jsonObject.getInteger("object");
                            entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u65b0\u589e\u7ec4\u7ec7", 1, "");
                            this.mapper.insertSendRecord(entity);
                            MaterialOrgEntity materialOrgEntity = new MaterialOrgEntity(todayUpdateDatum.getMasterDataId(), new Date(), materialId, 1, todayUpdateDatum.getName(), materialIdByMdmId);
                            this.mapper.insertOrgInfo(materialOrgEntity);
                        } else {
                            String message = jsonObject.getString("message");
                            entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u65b0\u589e\u7ec4\u7ec7", 2, message);
                            this.mapper.insertSendRecord(entity);
                        }
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                flag = false;
            }
            ++page;
        }
        return "\u540c\u6b65\u5b8c\u6210\uff01";
    }

    @Override
    public String orgInfoSync() {
        this.logger.info("\u7b51\u6750\u7f51\u540c\u6b65\u7ec4\u7ec7\u4fe1\u606f\u5f00\u59cb---------------->");
        List<MadOrgEntity> todayUpdateData = this.mapper.getTodayUpdateData();
        if (todayUpdateData != null) {
            for (MadOrgEntity todayUpdateDatum : todayUpdateData) {
                if (!"\u865a\u62df\u7ec4\u7ec7".equals(todayUpdateDatum.getOrgtype())) {
                    MaterialOrgEntity materialOrgEntity;
                    Integer materialId;
                    String message;
                    MadRecordEntity entity;
                    Integer code;
                    JSONObject jsonObject;
                    if (todayUpdateDatum.getDataType() == 1) {
                        Integer materialIdByMdmId = this.mapper.getMaterialIdByMdmId(todayUpdateDatum.getParentid());
                        if (todayUpdateDatum.getParentid().equals(1502571152642412546L) || todayUpdateDatum.getParentid().equals(1502571152701132801L) || todayUpdateDatum.getParentid().equals(1502571152793407490L) || todayUpdateDatum.getParentid().equals(1502571152847933442L) || todayUpdateDatum.getParentid().equals(1502571155922358273L) || todayUpdateDatum.getParentid().equals(1502571152583692289L)) {
                            materialIdByMdmId = null;
                        } else if (materialIdByMdmId == null) {
                            this.logger.info("\u7ec4\u7ec7:{} \u7684\u4e0a\u7ea7\u7ec4\u7ec7\u672a\u540c\u6b65\uff01", (Object)todayUpdateDatum.getName());
                            continue;
                        }
                        this.logger.info("\u7b51\u6750\u7f51\u7ec4\u7ec7\u4fe1\u606f\u65b0\u589e\uff0cid\uff1a{}", (Object)todayUpdateDatum.getMasterDataId());
                        jsonObject = this.insertOrgInfo(todayUpdateDatum.getName(), materialIdByMdmId);
                        code = jsonObject.getInteger("code");
                        if (code == 0) {
                            Integer materialId2 = jsonObject.getInteger("object");
                            entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u65b0\u589e\u7ec4\u7ec7", 1, "");
                            this.mapper.insertSendRecord(entity);
                            MaterialOrgEntity materialOrgEntity2 = new MaterialOrgEntity(todayUpdateDatum.getMasterDataId(), new Date(), materialId2, 1, todayUpdateDatum.getName(), materialIdByMdmId);
                            this.mapper.insertOrgInfo(materialOrgEntity2);
                        } else {
                            message = jsonObject.getString("message");
                            entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u65b0\u589e\u7ec4\u7ec7", 2, message);
                            this.mapper.insertSendRecord(entity);
                        }
                    } else if (todayUpdateDatum.getDataType() == 2) {
                        materialId = this.mapper.getMaterialIdByMdmId(todayUpdateDatum.getMasterDataId());
                        Integer materialparentId = null;
                        if (!(todayUpdateDatum.getParentid() == null || todayUpdateDatum.getParentid().equals(1502571152642412546L) || todayUpdateDatum.getParentid().equals(1502571152701132801L) || todayUpdateDatum.getParentid().equals(1502571152793407490L) || todayUpdateDatum.getParentid().equals(1502571152847933442L) || todayUpdateDatum.getParentid().equals(1502571155922358273L) || todayUpdateDatum.getParentid().equals(1502571152583692289L))) {
                            materialparentId = this.mapper.getMaterialIdByMdmId(todayUpdateDatum.getParentid());
                        }
                        if (materialId != null) {
                            MadRecordEntity entity2;
                            this.logger.info("\u7b51\u6750\u7f51\u7ec4\u7ec7\u4fe1\u606f\u66f4\u65b0\uff0cid\uff1a{}", (Object)todayUpdateDatum.getMasterDataId());
                            JSONObject jsonObject2 = this.updateOrgInfo(materialId, todayUpdateDatum.getName(), materialparentId);
                            Integer code2 = jsonObject2.getInteger("code");
                            if (code2 == 0) {
                                String object = jsonObject2.getString("object");
                                entity2 = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u4fee\u6539\u7ec4\u7ec7", 1, object);
                                this.mapper.insertSendRecord(entity2);
                                materialOrgEntity = new MaterialOrgEntity(todayUpdateDatum.getMasterDataId(), new Date(), materialId, 2, todayUpdateDatum.getName(), materialparentId);
                                this.mapper.updateOrgInfo(materialOrgEntity);
                            } else {
                                String message2 = jsonObject2.getString("message");
                                entity2 = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u4fee\u6539\u7ec4\u7ec7", 2, message2);
                                this.mapper.insertSendRecord(entity2);
                            }
                        } else {
                            MadRecordEntity entity3;
                            Integer materialIdByMdmId = this.mapper.getMaterialIdByMdmId(todayUpdateDatum.getParentid());
                            if (todayUpdateDatum.getParentid().equals(1502571152642412546L) || todayUpdateDatum.getParentid().equals(1502571152701132801L) || todayUpdateDatum.getParentid().equals(1502571152793407490L) || todayUpdateDatum.getParentid().equals(1502571152847933442L) || todayUpdateDatum.getParentid().equals(1502571155922358273L) || todayUpdateDatum.getParentid().equals(1502571152583692289L)) {
                                materialIdByMdmId = null;
                            } else if (materialIdByMdmId == null) {
                                this.logger.info("\u7ec4\u7ec7:{} \u7684\u4e0a\u7ea7\u7ec4\u7ec7\u672a\u540c\u6b65\uff01", (Object)todayUpdateDatum.getName());
                                continue;
                            }
                            this.logger.info("\u7b51\u6750\u7f51\u7ec4\u7ec7\u4fe1\u606f\u4fee\u6539\u65b0\u589e\uff0cid\uff1a{}", (Object)todayUpdateDatum.getMasterDataId());
                            JSONObject jsonObject3 = this.insertOrgInfo(todayUpdateDatum.getName(), materialIdByMdmId);
                            Integer code3 = jsonObject3.getInteger("code");
                            if (code3 == 0) {
                                Integer materialId1 = jsonObject3.getInteger("object");
                                entity3 = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u4fee\u6539\u65b0\u589e\u7ec4\u7ec7", 1, "");
                                this.mapper.insertSendRecord(entity3);
                                MaterialOrgEntity materialOrgEntity3 = new MaterialOrgEntity(todayUpdateDatum.getMasterDataId(), new Date(), materialId1, 1, todayUpdateDatum.getName(), materialIdByMdmId);
                                this.mapper.insertOrgInfo(materialOrgEntity3);
                            } else {
                                String message3 = jsonObject3.getString("message");
                                entity3 = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u4fee\u6539\u65b0\u589e\u7ec4\u7ec7", 2, message3);
                                this.mapper.insertSendRecord(entity3);
                            }
                        }
                    } else if (todayUpdateDatum.getDataType() == 3) {
                        materialId = this.mapper.getMaterialIdByMdmId(todayUpdateDatum.getMasterDataId());
                        if (materialId != null) {
                            this.logger.info("\u7b51\u6750\u7f51\u7ec4\u7ec7\u4fe1\u606f\u5220\u9664\uff0cid\uff1a{}", (Object)todayUpdateDatum.getMasterDataId());
                            jsonObject = this.deleteOrgInfo(materialId);
                            code = jsonObject.getInteger("code");
                            if (code == 0) {
                                String object = jsonObject.getString("object");
                                entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u5220\u9664\u7ec4\u7ec7", 1, object);
                                this.mapper.insertSendRecord(entity);
                                Integer materialparentId = null;
                                if (todayUpdateDatum.getParentid() != null) {
                                    materialparentId = this.mapper.getMaterialIdByMdmId(todayUpdateDatum.getParentid());
                                }
                                materialOrgEntity = new MaterialOrgEntity(todayUpdateDatum.getMasterDataId(), new Date(), materialId, 3, todayUpdateDatum.getName(), materialparentId);
                                this.mapper.updateOrgInfo(materialOrgEntity);
                            } else {
                                message = jsonObject.getString("message");
                                entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u5220\u9664\u7ec4\u7ec7", 2, message);
                                this.mapper.insertSendRecord(entity);
                            }
                        } else {
                            MadRecordEntity entity4 = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u5220\u9664\u7ec4\u7ec7", 2, "\u4e2d\u95f4\u8868\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff01");
                            this.mapper.insertSendRecord(entity4);
                        }
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return "\u540c\u6b65\u5b8c\u6210\uff01";
    }
}

