/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.mdm.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.mdm.bean.DataSourceSettingEntity;
import com.ejianc.foundation.mdm.service.IDataSourceSettingService;
import com.ejianc.foundation.mdm.utils.JdbcDataProvider;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DESUtils;
import com.ejianc.framework.core.util.EnvironmentTools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dsSetting/"})
public class DataSourceSettingController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TEST_MYSQL_SQL = "select 1";
    private static final String TEST_ORACLE_SQL = "select 1 from dual";
    private static final String TEST_SQLSERVER_SQL = "select 1";
    @Autowired
    private IDataSourceSettingService dataSourceSettingService;
    @Autowired
    private EnvironmentTools environmentTools;
    @Value(value="${refer.base-host:null}")
    private String baseHost;

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DataSourceSettingEntity>> pageList(@RequestBody QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.getOrderMap().put("sequence", "asc");
        IPage pageData = this.dataSourceSettingService.queryPage(queryParam);
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DataSourceSettingEntity> queryDetail(@RequestParam Long id) {
        DataSourceSettingEntity uniqueBean = (DataSourceSettingEntity)((Object)this.dataSourceSettingService.getById(id));
        return CommonResponse.success((Object)((Object)uniqueBean));
    }

    @RequestMapping(value={"/testConnection"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> testConnection(@RequestParam Long id) {
        DataSourceSettingEntity uniqueBean = (DataSourceSettingEntity)((Object)this.dataSourceSettingService.getById(id));
        uniqueBean.setDsPassword(DESUtils.decrypt((String)uniqueBean.getDsPassword()));
        HashMap<String, String> dataSourceMap = new HashMap<String, String>();
        dataSourceMap.put("driver", uniqueBean.getDriverName());
        dataSourceMap.put("jdbcurl", uniqueBean.getDsUrl());
        dataSourceMap.put("username", uniqueBean.getDsUserName());
        dataSourceMap.put("password", uniqueBean.getDsPassword());
        dataSourceMap.put("pooled", "false");
        HashMap<String, String> query = new HashMap<String, String>();
        if (uniqueBean.getDriverName().contains("mysql")) {
            query.put("sql", "select 1");
        }
        JdbcDataProvider jdbcDataProvider = JdbcDataProvider.getInstance();
        try {
            jdbcDataProvider.assignVal(dataSourceMap, query);
            boolean connectionFlag = jdbcDataProvider.testConnection();
            if (connectionFlag) {
                return CommonResponse.success((String)"\u8fde\u63a5\u6210\u529f");
            }
            return CommonResponse.error((String)"\u8fde\u63a5\u5931\u8d25");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.dataSourceSettingService.removeByIds(ids);
        return CommonResponse.success();
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody DataSourceSettingEntity saveData) {
        if (saveData.getId() != null && saveData.getId() > 0L) {
            DataSourceSettingEntity uniqueBean = (DataSourceSettingEntity)((Object)this.dataSourceSettingService.getById(saveData.getId()));
            uniqueBean.setSourceName(saveData.getSourceName());
            uniqueBean.setDriverName(saveData.getDriverName());
            uniqueBean.setDsUrl(saveData.getDsUrl());
            uniqueBean.setDsUserName(saveData.getDsUserName());
            if (!saveData.getDsPassword().equals(uniqueBean.getDsPassword())) {
                uniqueBean.setDsPassword(DESUtils.encrypt((String)saveData.getDsPassword()));
            }
            this.dataSourceSettingService.saveOrUpdate((Object)uniqueBean);
        } else {
            saveData.setDsPassword(DESUtils.encrypt((String)saveData.getDsPassword()));
            saveData.setAccessTicket(Base64.getEncoder().encodeToString(UUID.randomUUID().toString().replace("-", "").getBytes()));
            this.dataSourceSettingService.saveOrUpdate((Object)saveData);
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/findByCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReferVO> findByCode(@RequestParam String refCode) {
        ReferVO refer = new ReferVO();
        String referBaseHost = "";
        referBaseHost = StringUtils.isNotBlank((CharSequence)this.baseHost) && !"null".equals(this.baseHost) ? this.baseHost : this.environmentTools.getBaseHost();
        ArrayList<ReferShowfieldVO> gridHeaders = new ArrayList<ReferShowfieldVO>();
        ReferShowfieldVO idHeader = new ReferShowfieldVO();
        ReferShowfieldVO entityHeader = new ReferShowfieldVO();
        ReferShowfieldVO displayHeader = new ReferShowfieldVO();
        ReferShowfieldVO entityFullHeader = new ReferShowfieldVO();
        switch (refCode) {
            case "mdm_datasourcesetting_referList": {
                refer.setRefCode("dsSetting");
                refer.setRefName("\u6570\u636e\u6e90\u914d\u7f6e");
                refer.setRefType("grid");
                refer.setDataurl("http://127.0.0.1:8080/ejc-mdm-web/dsSetting/queryDsSettingRefList");
                refer.setIdField("id");
                refer.setCodeField("sourceName");
                refer.setNameField("sourceName");
                refer.setId(Long.valueOf(new Date().getTime()));
                idHeader.setId(Long.valueOf(1L));
                idHeader.setName("\u4e3b\u952e");
                idHeader.setCode("id");
                idHeader.setHidden(true);
                idHeader.setShowOrder(Integer.valueOf(1));
                idHeader.setType("string");
                gridHeaders.add(idHeader);
                entityHeader.setId(Long.valueOf(2L));
                entityHeader.setName("\u6570\u636e\u6e90\u540d\u79f0");
                entityHeader.setCode("sourceName");
                entityHeader.setHidden(false);
                entityHeader.setShowOrder(Integer.valueOf(1));
                entityHeader.setType("string");
                gridHeaders.add(entityHeader);
                displayHeader.setId(Long.valueOf(3L));
                displayHeader.setName("\u9a71\u52a8\u540d\u79f0");
                displayHeader.setCode("driverName");
                displayHeader.setHidden(false);
                displayHeader.setShowOrder(Integer.valueOf(1));
                displayHeader.setType("string");
                gridHeaders.add(displayHeader);
                entityFullHeader.setId(Long.valueOf(4L));
                entityFullHeader.setName("\u6570\u636e\u6e90\u5730\u5740");
                entityFullHeader.setCode("dsUrl");
                entityFullHeader.setHidden(false);
                entityFullHeader.setShowOrder(Integer.valueOf(1));
                entityFullHeader.setType("string");
                gridHeaders.add(entityFullHeader);
                refer.setGridheaders(gridHeaders);
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)refer);
        return CommonResponse.success((Object)refer);
    }

    @RequestMapping(value={"/queryDsSettingRefList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DataSourceSettingEntity>> queryDsSettingRefList(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText, @RequestParam int pageSize, @RequestParam int pageNumber, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        IPage pageData = this.dataSourceSettingService.queryPage(queryParam);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f!", (Object)pageData);
    }
}

