/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.mdm.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.mdm.bean.DataModelEntity;
import com.ejianc.foundation.mdm.bean.DataStateEntity;
import com.ejianc.foundation.mdm.bean.DataSubscribeEntity;
import com.ejianc.foundation.mdm.bean.DataTransferLogEntity;
import com.ejianc.foundation.mdm.bean.ThirdSystemEntity;
import com.ejianc.foundation.mdm.service.IDataModelItemService;
import com.ejianc.foundation.mdm.service.IDataModelService;
import com.ejianc.foundation.mdm.service.IDataStateService;
import com.ejianc.foundation.mdm.service.IDataSubscribeService;
import com.ejianc.foundation.mdm.service.IDataTransferLogService;
import com.ejianc.foundation.mdm.service.IThirdSystemService;
import com.ejianc.foundation.mdm.utils.HttpTookit;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasub/"})
public class DataSubscribeController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = -4419083871191610565L;
    @Autowired
    private IDataSubscribeService dataSubscribeService;
    @Autowired
    private IThirdSystemService thirdSystemService;
    @Autowired
    private IDataModelService dataModelService;
    @Autowired
    private IDataModelItemService dataModelItemService;
    @Autowired
    private IDataTransferLogService dataTransferLogService;
    @Autowired
    private IDataStateService dataStateService;

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DataSubscribeEntity>> pageList(@RequestBody QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        IPage pageData = this.dataSubscribeService.queryPage(queryParam);
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody DataSubscribeEntity saveData) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"subscribe_code", (Object)saveData.getSubscribeCode());
        DataSubscribeEntity dataSubscribeEntity = (DataSubscribeEntity)((Object)this.dataSubscribeService.getOne((Wrapper)queryWrapper));
        QueryWrapper dataSubWrapper = new QueryWrapper();
        dataSubWrapper.eq((Object)"data_model_id", (Object)saveData.getDataModelId());
        dataSubWrapper.eq((Object)"third_system_id", (Object)saveData.getThirdSystemId());
        List existDataSubList = this.dataSubscribeService.list((Wrapper)dataSubWrapper);
        if (saveData.getId() != null && saveData.getId() > 0L) {
            if (dataSubscribeEntity != null && !dataSubscribeEntity.getId().equals(saveData.getId())) {
                return CommonResponse.error((String)("\u7f16\u7801\u4e0e\u3010" + dataSubscribeEntity.getSubscribeName() + "\u3011\u91cd\u590d!"));
            }
            DataSubscribeEntity uniqueBean = (DataSubscribeEntity)((Object)this.dataSubscribeService.getById(saveData.getId()));
            if (!uniqueBean.getDataModelId().equals(saveData.getDataModelId()) && existDataSubList != null && existDataSubList.size() > 0) {
                return CommonResponse.error((String)("\u7cfb\u7edf\u3010" + saveData.getThirdSystemName() + "\u3011\u4e0b\u8be5\u6570\u636e\u6a21\u578b\u5df2\u7ecf\u521b\u5efa\u4e86\uff0c \u4e0d\u5141\u8bb8\u521b\u5efa!"));
            }
            uniqueBean.setDataModelId(saveData.getDataModelId());
            uniqueBean.setDataModelName(saveData.getDataModelName());
            uniqueBean.setSubscribeCode(saveData.getSubscribeCode());
            uniqueBean.setSubscribeName(saveData.getSubscribeName());
            uniqueBean.setEnableFlag(saveData.getEnableFlag());
            this.dataSubscribeService.saveOrUpdate((Object)uniqueBean);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        if (dataSubscribeEntity != null) {
            return CommonResponse.error((String)("\u7f16\u7801\u4e0e\u3010" + dataSubscribeEntity.getSubscribeName() + "\u3011\u91cd\u590d!"));
        }
        if (existDataSubList != null && existDataSubList.size() > 0) {
            return CommonResponse.error((String)("\u7cfb\u7edf\u3010" + saveData.getThirdSystemName() + "\u3011\u4e0b\u8be5\u6570\u636e\u6a21\u578b\u5df2\u7ecf\u521b\u5efa\u4e86\uff0c \u4e0d\u5141\u8bb8\u521b\u5efa!"));
        }
        saveData.setId(IdWorker.getId());
        this.dataSubscribeService.saveOrUpdate((Object)saveData);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DataSubscribeEntity> queryDetail(@RequestParam Long id) {
        DataSubscribeEntity uniqueBean = (DataSubscribeEntity)((Object)this.dataSubscribeService.getById(id));
        return CommonResponse.success((Object)((Object)uniqueBean));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        this.dataSubscribeService.removeById(id);
        return CommonResponse.success();
    }

    public String getDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(new Date());
    }

    @RequestMapping(value={"/sync/pushdata"})
    @ResponseBody
    public CommonResponse<String> pushDataToTargetSystem() {
        this.logger.info(">>>>{}>>>>\u4e3b\u6570\u636e\u7cfb\u7edf\u5b9a\u65f6\u63a8\u9001\u6570\u636estart...", (Object)this.getDateTime());
        QueryWrapper thirdSystemWrapper = new QueryWrapper();
        thirdSystemWrapper.in((Object)"system_type", new Object[]{"2,3"});
        List thirdSystemEntities = this.thirdSystemService.list((Wrapper)thirdSystemWrapper);
        if (thirdSystemEntities != null && thirdSystemEntities.size() > 0) {
            for (ThirdSystemEntity thirdSystemEntity : thirdSystemEntities) {
                String pushDataUrl = thirdSystemEntity.getServiceUrl();
                if (!StringUtils.isNotBlank((CharSequence)pushDataUrl)) continue;
                QueryWrapper dataSubWrapper = new QueryWrapper();
                dataSubWrapper.eq((Object)"third_system_id", (Object)thirdSystemEntity.getId());
                dataSubWrapper.eq((Object)"enable_flag", (Object)1);
                List dataSubEntities = this.dataSubscribeService.list((Wrapper)dataSubWrapper);
                if (dataSubEntities == null || dataSubEntities.size() <= 0 || !StringUtils.isNotBlank((CharSequence)pushDataUrl)) continue;
                for (DataSubscribeEntity dataSubscribeEntity : dataSubEntities) {
                    Long dataModelId = dataSubscribeEntity.getDataModelId();
                    DataModelEntity dataModelEntity = (DataModelEntity)((Object)this.dataModelService.getById(dataModelId));
                    HashMap<String, Object> modelItemMap = new HashMap<String, Object>();
                    modelItemMap.put("tableName", dataModelEntity.getModelCode());
                    modelItemMap.put("dataState", 0);
                    modelItemMap.put("thirdCode", thirdSystemEntity.getSystemCode());
                    modelItemMap.put("modelCode", dataModelEntity.getModelCode());
                    Long resultDataListCount = this.dataModelItemService.queryMdmDataStateCount(modelItemMap);
                    Integer i = 0;
                    while ((long)i.intValue() <= resultDataListCount / 500L) {
                        Integer pageIndex = i * 500;
                        Integer pageSize = (i + 1) * 500;
                        modelItemMap.put("pageIndex", pageIndex);
                        modelItemMap.put("pageSize", pageSize);
                        List<JSONObject> resultDataList = this.dataModelItemService.queryMdmDataStateList(modelItemMap);
                        this.pushAAndDealData(resultDataList, thirdSystemEntity.getSystemCode(), dataModelEntity.getModelCode(), pushDataUrl, thirdSystemEntity.getId());
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                    }
                }
            }
        }
        return CommonResponse.success();
    }

    private void pushAAndDealData(List<JSONObject> resultDataList, String thirdCode, String modelCode, String pushDataUrl, Long thirdSystemId) {
        if (resultDataList != null && resultDataList.size() > 0) {
            JSONObject paramJsonObject = new JSONObject();
            paramJsonObject.put(modelCode, resultDataList);
            String responseStr = "";
            try {
                JSONObject backJsonObject;
                DataTransferLogEntity entity = new DataTransferLogEntity();
                entity.setThirdSystemId(thirdSystemId);
                entity.setCallType("pushdata");
                entity.setReqTime(new Date());
                entity.setReqParams(JSONObject.toJSONString((Object)paramJsonObject));
                entity.setCallResp(responseStr);
                entity.setRespState("failed");
                entity.setId(IdWorker.getId());
                this.dataTransferLogService.saveOrUpdate((Object)entity, false);
                this.logger.error("---------\u4e3b\u6570\u636e\u63a8\u9001\u6570\u636e\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u5f00\u59cb---------");
                this.logger.error("url:{}", (Object)pushDataUrl);
                this.logger.error("\u53c2\u6570:{}", (Object)paramJsonObject);
                responseStr = HttpTookit.postJson(pushDataUrl, JSONObject.toJSONString((Object)paramJsonObject));
                this.logger.error("---------\u4e3b\u6570\u636e\u63a8\u9001\u6570\u636e\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u7ed3\u679c\uff1a{}", (Object)responseStr);
                entity.setCallResp(responseStr);
                entity.setRespState("ok");
                this.dataTransferLogService.saveOrUpdate((Object)entity, false);
                if (StringUtils.isNotBlank((CharSequence)responseStr) && "0".equals((backJsonObject = JSONObject.parseObject((String)responseStr)).getString("code"))) {
                    JSONArray backDataArr = backJsonObject.getJSONArray("data");
                    ArrayList<DataStateEntity> dataStateList = new ArrayList<DataStateEntity>();
                    if (backDataArr != null && backDataArr.size() > 0) {
                        for (int i = 0; i < backDataArr.size(); ++i) {
                            JSONObject backDataObj = backDataArr.getJSONObject(i);
                            if (!"1".equals(backDataObj.getString("state"))) continue;
                            DataStateEntity sentity = new DataStateEntity();
                            sentity.setDataModelId(backDataObj.getLong("mastDataId"));
                            sentity.setModelCode(modelCode);
                            sentity.setThirdCode(thirdCode);
                            dataStateList.add(sentity);
                        }
                        if (dataStateList != null && dataStateList.size() > 0) {
                            this.dataStateService.saveOrUpdateBatch(dataStateList, dataStateList.size(), false);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("\u4e3b\u6570\u636e\u63a8\u9001\u6570\u636e\u5931\u8d25\uff0c\u9519\u8bef:{}", (Throwable)e);
                this.logger.error("\u4e3b\u6570\u636e\u63a8\u9001\u6570\u636e\u5931\u8d25,\u5730\u5740\uff1a{},\u6570\u636e\u5185\u5bb9\uff1a{}", (Object)pushDataUrl, (Object)responseStr);
            }
        }
    }
}

