/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.mdm.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.mdm.bean.DataSourceSettingEntity;
import com.ejianc.foundation.mdm.bean.DbOpenApiEntity;
import com.ejianc.foundation.mdm.bean.DbOpenApiTransferLogEntity;
import com.ejianc.foundation.mdm.service.IDataSourceSettingService;
import com.ejianc.foundation.mdm.service.IDbOpenApiService;
import com.ejianc.foundation.mdm.service.IDbOpenApiTransferLogService;
import com.ejianc.foundation.mdm.utils.JdbcDataProvider;
import com.ejianc.foundation.mdm.utils.ProduceNumber;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DESUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class DbOpenApiController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IDbOpenApiService dbOpenApiService;
    @Autowired
    private IDataSourceSettingService dataSourceSettingService;
    @Autowired
    private IDbOpenApiTransferLogService dbOpenApiTransferLogService;

    @RequestMapping(value={"/dbOpenApi/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DbOpenApiEntity>> pageList(@RequestBody QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.getOrderMap().put("sequence", "asc");
        IPage pageData = this.dbOpenApiService.queryPage(queryParam);
        if (pageData != null && pageData.getRecords() != null) {
            for (DbOpenApiEntity dbOpenApiEntity : pageData.getRecords()) {
                DataSourceSettingEntity dataSourceSettingEntity = (DataSourceSettingEntity)((Object)this.dataSourceSettingService.getById(dbOpenApiEntity.getDataSourceId()));
                dbOpenApiEntity.setDataSourceName(dataSourceSettingEntity.getSourceName());
            }
        }
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/dbOpenApi/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DbOpenApiEntity> queryDetail(@RequestParam Long id) {
        DbOpenApiEntity dbOpenApiEntity = (DbOpenApiEntity)((Object)this.dbOpenApiService.selectById(id));
        DataSourceSettingEntity dataSourceSettingEntity = (DataSourceSettingEntity)((Object)this.dataSourceSettingService.getById(dbOpenApiEntity.getDataSourceId()));
        dbOpenApiEntity.setDataSourceName(dataSourceSettingEntity.getSourceName());
        dbOpenApiEntity.setAccessTicket(dataSourceSettingEntity.getAccessTicket());
        return CommonResponse.success((Object)((Object)dbOpenApiEntity));
    }

    @RequestMapping(value={"/dbOpenApi/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.dbOpenApiService.removeByIds(ids);
        return CommonResponse.success();
    }

    @RequestMapping(value={"/dbOpenApi/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody DbOpenApiEntity saveData) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (saveData.getId() != null && saveData.getId() > 0L) {
            DbOpenApiEntity uniqueBean = (DbOpenApiEntity)((Object)this.dbOpenApiService.selectById(saveData.getId()));
            uniqueBean.setDataSourceId(saveData.getDataSourceId());
            if (!saveData.getOpenApiCode().equals(uniqueBean.getOpenApiCode())) {
                queryWrapper.eq((Object)"open_api_code", (Object)saveData.getOpenApiCode());
                queryWrapper.ne((Object)"id", (Object)saveData.getId());
                DbOpenApiEntity uniqueCodeBean = (DbOpenApiEntity)((Object)this.dbOpenApiService.getOne((Wrapper)queryWrapper));
                if (uniqueCodeBean != null) {
                    return CommonResponse.error((String)("\u7f16\u7801\u4e0e\u3010" + uniqueCodeBean.getOpenApiName() + "\u3011\u91cd\u590d!"));
                }
                uniqueBean.setOpenApiCode(saveData.getOpenApiCode());
            }
            uniqueBean.setOpenApiName(saveData.getOpenApiName());
            uniqueBean.setOpenApiParam(saveData.getOpenApiParam());
            uniqueBean.setSequence(saveData.getSequence());
            uniqueBean.setSqlContent(saveData.getSqlContent());
            uniqueBean.setRemark(saveData.getRemark());
            this.dbOpenApiService.saveOrUpdate((Object)uniqueBean);
        } else {
            saveData.setOpenApiCode(ProduceNumber.produce());
            queryWrapper.eq((Object)"open_api_code", (Object)saveData.getOpenApiCode());
            DbOpenApiEntity uniqueCodeBean = (DbOpenApiEntity)((Object)this.dbOpenApiService.getOne((Wrapper)queryWrapper));
            if (uniqueCodeBean != null) {
                return CommonResponse.error((String)("\u7f16\u7801\u4e0e\u3010" + uniqueCodeBean.getOpenApiName() + "\u3011\u91cd\u590d!"));
            }
            this.dbOpenApiService.saveOrUpdate((Object)saveData);
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/dbOpenApi/queryDbOpenLogList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DbOpenApiTransferLogEntity>> queryDbOpenLogList(@RequestBody QueryParam queryParam) {
        queryParam.getOrderMap().put("req_time", "desc");
        IPage pageData = this.dbOpenApiTransferLogService.queryPage(queryParam);
        if (pageData != null && pageData.getRecords() != null) {
            for (DbOpenApiTransferLogEntity dbOpenApiTransferLogEntity : pageData.getRecords()) {
                DbOpenApiEntity dbOpenApiEntity = (DbOpenApiEntity)((Object)this.dbOpenApiService.selectById(dbOpenApiTransferLogEntity.getDbOpenapiId()));
                dbOpenApiTransferLogEntity.setDbOpenApiName(dbOpenApiEntity.getOpenApiName());
            }
        }
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/dbopenapi/query/{openApiCode}"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryOpenApiData(final HttpServletRequest request, @PathVariable String openApiCode, final @RequestBody JSONObject jsonObject) {
        String ticket = request.getHeader("ticket");
        if (StringUtils.isBlank((String)ticket)) {
            return CommonResponse.error((String)"\u8bf7\u6c42\u5934\u4e2d\u7684ticket\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"open_api_code", (Object)openApiCode);
        final DbOpenApiEntity dbOpenApiEntity = (DbOpenApiEntity)((Object)this.dbOpenApiService.getOne((Wrapper)queryWrapper));
        if (dbOpenApiEntity == null) {
            return CommonResponse.error((String)("\u672a\u627e\u5230OpenCode\uff1a " + openApiCode + " \u5bf9\u5e94\u7684\u5f00\u653e\u63a5\u53e3\uff01"));
        }
        DataSourceSettingEntity dsSetting = (DataSourceSettingEntity)((Object)this.dataSourceSettingService.getById(dbOpenApiEntity.getDataSourceId()));
        if (!ticket.equals(dsSetting.getAccessTicket())) {
            return CommonResponse.error((String)"ticket\u7968\u636e\u9519\u8bef\uff0c\u4e0d\u80fd\u8bbf\u95ee\u8be5\u63a5\u53e3");
        }
        String queryParam = dbOpenApiEntity.getOpenApiParam();
        String sqlContent = dbOpenApiEntity.getSqlContent();
        if (StringUtils.isNotBlank((String)queryParam)) {
            String[] paramArr;
            for (String param : paramArr = queryParam.split(",")) {
                if (!jsonObject.containsKey((Object)param)) {
                    return CommonResponse.error((String)("\u53c2\u6570\u3010" + param + "\u3011\u672a\u4f20\u5165\uff01"));
                }
                String value = jsonObject.getString(param);
                if (value.toLowerCase().indexOf(";") >= 0 || value.toLowerCase().indexOf("drop") >= 0 || value.toLowerCase().indexOf("insert") >= 0 || value.toLowerCase().indexOf("delete") >= 0 || value.toLowerCase().indexOf("update") >= 0) {
                    throw new BusinessException("\u53c2\u6570\u4e2d\u542b\u6709drop\u3001insert\u3001update\u3001delete\u5173\u952e\u5b57\u3002");
                }
                sqlContent = sqlContent.replaceAll("\\{" + param + "\\}", value);
            }
        }
        HashMap<String, String> dataSourceMap = new HashMap<String, String>();
        dataSourceMap.put("driver", dsSetting.getDriverName());
        dataSourceMap.put("jdbcurl", dsSetting.getDsUrl());
        dataSourceMap.put("username", dsSetting.getDsUserName());
        dataSourceMap.put("password", DESUtils.decrypt((String)dsSetting.getDsPassword()));
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("sql", sqlContent);
        JdbcDataProvider jdbcDataProvider = JdbcDataProvider.getInstance();
        jdbcDataProvider.assignVal(dataSourceMap, query);
        final List<JSONObject> records = jdbcDataProvider.getDataList();
        new Thread(new Runnable(){

            @Override
            public void run() {
                DbOpenApiTransferLogEntity transferLog = new DbOpenApiTransferLogEntity();
                transferLog.setDbOpenapiId(dbOpenApiEntity.getId());
                transferLog.setReqTime(new Date());
                transferLog.setReqParams(jsonObject.toString());
                transferLog.setReqIp(DbOpenApiController.this.getRemoteHost(request));
                transferLog.setCallResp(JSON.toJSONString((Object)records));
                DbOpenApiController.this.dbOpenApiTransferLogService.saveOrUpdate((Object)transferLog);
            }
        }).start();
        return CommonResponse.success((String)"\u6570\u636e\u67e5\u8be2\u6210\u529f\uff01", records);
    }

    private String getRemoteHost(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-client-IP");
        }
        if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Client-IP");
        }
        if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteHost();
        }
        return "0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : ip;
    }
}

