/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.mdm.dataprovider;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.mdm.dataprovider.Aggregatable;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class InnerAggregator
implements Aggregatable {
    protected Map<String, String> dataSource;
    protected Map<String, String> query;
    @Autowired
    protected RedisTemplate<String, Object> redisTemplate;

    public abstract void loadData(String[][] var1, long var2);

    public void setDataSource(Map<String, String> dataSource) {
        this.dataSource = dataSource;
    }

    public void setQuery(Map<String, String> query) {
        this.query = query;
    }

    protected String getCacheKey() {
        return Hashing.md5().newHasher().putString((CharSequence)(JSONObject.toJSON(this.dataSource).toString() + JSONObject.toJSON(this.query).toString()), Charsets.UTF_8).hash().toString();
    }

    public boolean checkExist() {
        return this.redisTemplate.boundValueOps((Object)this.getCacheKey()).get() != null;
    }

    public void cleanExist() {
        this.redisTemplate.delete((Object)this.getCacheKey());
    }

    public void beforeLoad(String[] header) {
    }

    public void loadBatch(String[] header, String[][] data) {
    }

    public void afterLoad() {
    }
}

