package com.ejianc.foundation.message.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

/**
 * 消息内容载体
 */
public class SocketMessageLogVO extends BaseVO {
	private static final long serialVersionUID = 1L;

	public static final String ROBOT = "robot";
	public static final String USER = "user";

	public static final String TO_DO = "1";
	public static final String DONE = "user";

	/**
	 * 消息内容
	 * 机器人消息是json格式，用户消息是纯文本
	 */
	private String content;
	/**
	 * 消息类型：robot or user
	 * robot:机器人发送的消息，user:用户回复的消息
	 */
	private String msgType;
	/**
	 * 发送时间
	 */
	private String sendTime;
	/**
	 * 用户id，会话是哪个用户的历史记录
	 */
	private Long userId;

	/**
	 * 消息状态：1:未处理，2:已处理
	 */
	private String state;

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getMsgType() {
		return msgType;
	}

	public void setMsgType(String msgType) {
		this.msgType = msgType;
	}

	public String getSendTime() {
		return sendTime;
	}

	public void setSendTime(String sendTime) {
		this.sendTime = sendTime;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}
}
