package com.ejianc.foundation.message.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.hystrix.MessageHystrix;
import com.ejianc.foundation.message.vo.PageParam;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author CJ
 * @Description:
 * @date 2020/7/17 20:02
 */
@FeignClient(name= "ejc-message-web", url="${common.env.feign-client-url}", path="ejc-message-web", fallback = MessageHystrix.class)
public interface IMessageApi {
    /**
     * 查询用户指定条件的消息数量
     *
     * @param pageParam
     * @return
     */
    @PostMapping("/api/userMsg/countUserMsg")
    CommonResponse<Long> countUserMsg(@RequestBody PageParam pageParam);

    /**
     * 分页查询用户消息列表
     *
     * @param pageParam
     * @return
     */
    @PostMapping("/api/userMsg/pageList")
    CommonResponse<JSONObject> pageList(@RequestBody PageParam pageParam);
}
