package com.ejianc.foundation.message.api;

import com.ejianc.foundation.message.vo.SocketMsgParameter;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.ejianc.foundation.message.hystrix.PushMessageHystrix;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.response.CommonResponse;

import java.util.List;
import java.util.Map;

@FeignClient(name= "ejc-message-web", url="${common.env.feign-client-url}", path="ejc-message-web", fallback = PushMessageHystrix.class)
public interface IPushMessageApi {

    @PostMapping(value = "/api/message/sendMessage")
    public CommonResponse<String> pushMessage(@RequestBody PushMsgParameter parameter);
    
    /**
     * 发送消息不认证
     * 
     * @param parameter
     * @return
     */
    @PostMapping(value = "/no_auth/api/message/sendNoAuthMessage")
    public CommonResponse<String> pushNoAuthMessage(@RequestBody PushMsgParameter parameter);

    @PostMapping(value = "api/message/sendUserMsg")
    public CommonResponse<String> sendUserMsg(@RequestBody PushMsgParameter parameter);

    /**
     * 发送websocket消息
     * @param parameter
     * @return Map<String, String> key:接收人用户id,value:消息id
     */
    @PostMapping(value = "/api/message/sendWebsocketMessage")
    CommonResponse<Map<String, Long>> pushWebsocketMessage(@RequestBody SocketMsgParameter parameter);

    /**
     * 更新websocket消息状态
     * @param msgIds
     * @return
     */
    @PostMapping(value = "/api/message/updateWebsocketMessageStatus")
    CommonResponse<String> updateWebsocketMessageStatus(@RequestBody List<Long> msgIds);

}
