package com.ejianc.foundation.message.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

/**
 * 消息内容载体
 */
public class MessageVO extends BaseVO {
	private static final long serialVersionUID = 4347429583796861777L;

	/**
	 * 消息类型-任务消息
	 */
	public static final String MSG_TYPE_TASK = "task";
	/**
	 * 消息类型-提醒消息
	 */
	public static final String MSG_TYPE_NOTICE = "notice";
	/**
	 * 消息类型-预警消息
	 */
	public static final String MSG_TYPE_EALYWARNING = "earlywarning";

	/**
	 * 消息主题
	 */
	private String subject;

	/**
	 * status 0代表未读,1代表已读
	 */
	private Integer status;

	/**
	 * 消息内容
	 */
	private String content;
	// 移动端消息内容
	private String mobileContent;

	/**
	 * 消息类型：task(任务(旧))，notice(提醒(旧))，earlywarning(预警)
	 * bpmtask(审批待办消息)，bpmurge(流程催办提醒消息)，bpmpass(审批通过提醒消息)，bpmstop(流程终止提醒消息)，bpmunapprove(流程弃审提醒消息)，
	 * bpmreject(流程驳回提醒消息)，bpmcc(审批抄送提醒消息)，commentcc(评论抄送提醒消息)，elecsignwithdrawal(电子签章撤回提醒消息)，
	 * contractsign(合同签署待办提醒消息)，ordershelf(订单上架提醒消息)
	 */
	private String msgType;

	/**
	 * 发送时间
	 */
	private String sendTime;

	/**
	 * 消息发送人Id
	 */
	private Long sendUserId;
	
	/**
	 * 消息标题对应的url
	 */
	private String pcUrl;
	
	/**
	 * 消息标题对应的移动端url
	 */
	private String mobileUrl;

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getMsgType() {
		return msgType;
	}

	public void setMsgType(String msgType) {
		this.msgType = msgType;
	}

	public String getSendTime() {
		return sendTime;
	}

	public void setSendTime(String sendTime) {
		this.sendTime = sendTime;
	}

	public String getMobileContent() {
		return mobileContent;
	}

	public void setMobileContent(String mobileContent) {
		this.mobileContent = mobileContent;
	}

	public Long getSendUserId() {
		return sendUserId;
	}

	public void setSendUserId(Long sendUserId) {
		this.sendUserId = sendUserId;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public String getPcUrl() {
		return pcUrl;
	}

	public void setPcUrl(String pcUrl) {
		this.pcUrl = pcUrl;
	}

	public String getMobileUrl() {
		return mobileUrl;
	}

	public void setMobileUrl(String mobileUrl) {
		this.mobileUrl = mobileUrl;
	}

}
