package com.ejianc.foundation.message.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.alibaba.fastjson.JSONObject;

public class PushMsgParameter implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 基础消息信息处理队列
	 */
	public static final String MESSAGE_COMMON_QUEUE = "ejc-message-common-queue";
	/**
	 * 消息类型-系统消息
	 */
	public static final String CHANNEL_TYPE_SYS = "sys";
	/**
	 * 消息类型-邮件
	 */
	public static final String CHANNEL_TYPE_EMAIL = "email";
	/**
	 * 消息类型-微信公众号消息
	 */
	public static final String CHANNEL_TYPE_WEIXIN = "weixin";
	/**
	 * 消息类型-企业微信
	 */
	public static final String CHANNEL_TYPE_WEXINEE = "weixinee";
	/**
	 * 消息类型微信小程序
	 */
	public static final String CHANNEL_TYPE_WEIXIN_MINPROGRAM = "weixinminprogram";
	/**
	 * 消息类型-钉钉
	 */
	public static final String CHANNEL_TYPE_DINGDING = "dingding";
	/**
	 * 消息类型-钉钉-定制应用
	 */
	public static final String CHANNEL_TYPE_DDOPENAPP = "ddOpenApp";
	/**
	 * 消息类型-钉钉第三方企业应用
	 */
	public static final String CHANNEL_TYPE_DDTHIRDAPP = "ddThirdApp";
	/**
	 * 消息类型-五局云
	 */
	public static final String CHANNEL_TYPE_WJY="wjy";
	/**
	 * 消息类型-致远oa
	 */
	public static final String CHANNEL_TYPE_ZHIYUANOA="zhiyuanoa";
	
	/**
	 * 分供方一体化平台
	 */
	public static final String CHANNEL_TYPE_WEIXIN_SUPPLIER="weixinSupplier";
	
	/**
	 * 小e助手
	 */
	public static final String CHANNEL_TYPE_WEBSOCKET="websocket";

	// 消息通道
	private String[] channel;
	// 接收人IDs
	private String[] receivers;
	/**
	 * 消息类型：task(任务(旧))，notice(提醒(旧))，earlywarning(预警)
	 * bpmtask(审批待办消息)，bpmurge(流程催办提醒消息)，bpmpass(审批通过提醒消息)，bpmstop(流程终止提醒消息)，bpmunapprove(流程弃审提醒消息)，
	 * bpmreject(流程驳回提醒消息)，bpmcc(审批抄送提醒消息)，commentcc(评论抄送提醒消息)，elecsignwithdrawal(电子签章撤回提醒消息)，
	 * contractsign(合同签署待办提醒消息)，ordershelf(订单上架提醒消息)
	 */
	private String msgType;

	//中电四邮件消息扩展参数
	private JSONObject zdsExtEmailParams;

	// 消息标题
	private String subject;
	// 消息内容
	private String content;
	// 移动端消息内容
	private String mobileContent;
	
	/**
	 * 消息标题对应的url
	 */
	private String pcUrl;
	//PC链接打开页签名称
	private String pcTitle;
	
	/**
	 * 消息标题对应的移动端url
	 */
	private String mobileUrl;
	// 租户ID
	private String tenantId;
	// 消息发送人Id
	private Long sendUserId;
	// 微信公众号扩展参数
	private JSONObject weixinParams;
	// 企业微信扩展参数
	private JSONObject weixineeParams;
	// 钉钉扩展参数
	private JSONObject dingdingParams;
	// 微信小程序参数
	private JSONObject weixinMinProgramParams;
	// 五局云消息参数
	private JSONObject wjyMsgParams;

	//是否保存消息，发送用户消息时有效
	private boolean saveFlag = false;
	//附近Id列表，发送用户消息时有效
    private List<Long> attachIds = new ArrayList();

	public String[] getChannel() {
		return channel;
	}

	public void setChannel(String[] channel) {
		this.channel = channel;
	}

	public String[] getReceivers() {
		return receivers;
	}

	public void setReceivers(String[] receivers) {
		this.receivers = receivers;
	}

	public String getMsgType() {
		return msgType;
	}

	public void setMsgType(String msgType) {
		this.msgType = msgType;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getMobileContent() {
		return mobileContent;
	}

	public void setMobileContent(String mobileContent) {
		this.mobileContent = mobileContent;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public Long getSendUserId() {
		return sendUserId;
	}

	public void setSendUserId(Long sendUserId) {
		this.sendUserId = sendUserId;
	}

	public JSONObject getWeixinParams() {
		return weixinParams;
	}

	public void setWeixinParams(JSONObject weixinParams) {
		this.weixinParams = weixinParams;
	}

	public JSONObject getWeixineeParams() {
		return weixineeParams;
	}

	public void setWeixineeParams(JSONObject weixineeParams) {
		this.weixineeParams = weixineeParams;
	}

	public JSONObject getDingdingParams() {
		return dingdingParams;
	}

	public void setDingdingParams(JSONObject dingdingParams) {
		this.dingdingParams = dingdingParams;
	}

	public JSONObject getWeixinMinProgramParams() {
		return weixinMinProgramParams;
	}

	public void setWeixinMinProgramParams(JSONObject weixinMinProgramParams) {
		this.weixinMinProgramParams = weixinMinProgramParams;
	}

	public JSONObject getWjyMsgParams() {
		return wjyMsgParams;
	}

	public void setWjyMsgParams(JSONObject wjyMsgParams) {
		this.wjyMsgParams = wjyMsgParams;
	}

	public boolean isSaveFlag() {
		return saveFlag;
	}

	public void setSaveFlag(boolean saveFlag) {
		this.saveFlag = saveFlag;
	}

    public List<Long> getAttachIds() {
        return attachIds;
    }

    public void setAttachIds(List<Long> attachIds) {
        this.attachIds = attachIds;
    }

	public String getPcUrl() {
		return pcUrl;
	}

	public void setPcUrl(String pcUrl) {
		this.pcUrl = pcUrl;
	}

	public String getMobileUrl() {
		return mobileUrl;
	}

	public void setMobileUrl(String mobileUrl) {
		this.mobileUrl = mobileUrl;
	}

	public JSONObject getZdsExtEmailParams() {
		return zdsExtEmailParams;
	}

	public void setZdsExtEmailParams(JSONObject zdsExtEmailParams) {
		this.zdsExtEmailParams = zdsExtEmailParams;
	}

	public String getPcTitle() {
		return pcTitle;
	}

	public void setPcTitle(String pcTitle) {
		this.pcTitle = pcTitle;
	}
}
