package com.ejianc.foundation.message.vo;

import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.util.List;

public class SocketMsgParameter implements Serializable {

	private static final long serialVersionUID = 1L;

    // 接收人IDs，系统用户id
    private String[] receivers;
    /**
     * 消息类型：task(任务(旧))，notice(提醒(旧))，earlywarning(预警)
     * bpmtask(审批待办消息)，bpmurge(流程催办提醒消息)，bpmpass(审批通过提醒消息)，bpmstop(流程终止提醒消息)，bpmunapprove(流程弃审提醒消息)，
     * bpmreject(流程驳回提醒消息)，bpmcc(审批抄送提醒消息)，commentcc(评论抄送提醒消息)，elecsignwithdrawal(电子签章撤回提醒消息)，
     * contractsign(合同签署待办提醒消息)，ordershelf(订单上架提醒消息)
     */
    private String msgType;
    // 消息标题，缺省会以消息类型名称展示
    private String subject;
    // 普通消息内容，会以普通的小文字展示
    private String content;
    // 如果消息是待办，需要填写，1:未处理，2:已处理,可是使用SocketMessageLogVO.TO_DO和SocketMessageLogVO.DONE进行赋值，其他消息可以不填写，如果需要状态就需要填写
    private String state;
    // 重要的消息内容，会以超大字体展示，最好是金额之类的数据，言简意赅为妙
//	private String keyContent;
    //键值对对应的消息内容，例如：{"审批人":"张三"，"合计金额":"2000.00"}
    private JSONObject keyValueContent;
    /**
     * 消息标题对应的url
     */
    private String pcUrl;
    //PC链接打开页签名称
    private String pcTitle;
    /**
     * 消息标题对应的移动端url
     */
    private String mobileUrl;
    // 租户ID
    private String tenantId;

    //附件Id列表，发送用户消息时有效
    private List<Long> attachIds;

    public String[] getReceivers() {
        return receivers;
    }

    public void setReceivers(String[] receivers) {
        this.receivers = receivers;
    }

    public String getMsgType() {
        return msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public JSONObject getKeyValueContent() {
        return keyValueContent;
    }

    public void setKeyValueContent(JSONObject keyValueContent) {
        this.keyValueContent = keyValueContent;
    }

    public String getPcUrl() {
        return pcUrl;
    }

    public void setPcUrl(String pcUrl) {
        this.pcUrl = pcUrl;
    }

    public String getPcTitle() {
        return pcTitle;
    }

    public void setPcTitle(String pcTitle) {
        this.pcTitle = pcTitle;
    }

    public String getMobileUrl() {
        return mobileUrl;
    }

    public void setMobileUrl(String mobileUrl) {
        this.mobileUrl = mobileUrl;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public List<Long> getAttachIds() {
        return attachIds;
    }

    public void setAttachIds(List<Long> attachIds) {
        this.attachIds = attachIds;
    }

    public String getState() {
        return state;
    }

	public void setState(String state) {
		this.state = state;
	}
}
