package com.ejianc.foundation.message.api;

import com.ejianc.foundation.message.hystrix.SmsMessageHystrix;
import com.ejianc.foundation.message.vo.SmsCheckParam;
import com.ejianc.foundation.message.vo.SmsMsgSendParam;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name= "ejc-message-web", url="${common.env.feign-client-url}", path="ejc-message-web", fallback = SmsMessageHystrix.class)
public interface ISmsMessageApi {

    /**
     * 发送短消息
     *
     * @param param
     * @return
     */
    @PostMapping(value = "/api/sms/sendMessage")
    CommonResponse<String> sendMessage(@RequestBody SmsMsgSendParam param);

    /**
     * 检查验证码是否正确
     *
     * @return
     * @param param
     */
    @PostMapping(value = "/api/sms/checkMessage")
    public CommonResponse<String> checkMessage(@RequestBody SmsCheckParam param);
}
