package com.ejianc.foundation.message.vo;

import java.io.Serializable;
import java.util.List;

/**
 * 消息中心列表查询参数
 */
public class PageParam implements Serializable {
    private static final long serialVersionUID = 4030946622410855544L;

    /**
     * msgtype 消息类型：task为任务 notice为提醒 earlywarning 预警
     */
    private String msgType;

    /**
     * status 0代表未读,1代表已读
     */
    private Integer status;

    /**
     * pagenum 页码
     */
    private Integer pageNum;

    /**
     * pagesize 每页列表记录数
     */
    private Integer pageSize;

    /**
     * searchText 搜索关键字
     */
    private String searchText;

    private Long receiver;

    private Long tenantId;

    private String sendTime;

    private List<String> msgTypeList;

    public String getMsgType() {
        return msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getSearchText() {
        return searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public int getStartLine() {
        return (null != this.pageNum && null != this.pageSize) ? (this.pageNum <= 1 ? 0 : this.pageNum - 1) * this.pageSize : 0;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Long getReceiver() {
        return receiver;
    }

    public void setReceiver(Long receiver) {
        this.receiver = receiver;
    }

    public List<String> getMsgTypeList() {
        return msgTypeList;
    }

    public void setMsgTypeList(List<String> msgTypeList) {
        this.msgTypeList = msgTypeList;
    }

	public Long getTenantId() {
		return tenantId;
	}

	public void setTenantId(Long tenantId) {
		this.tenantId = tenantId;
	}

    public String getSendTime() {
        return sendTime;
    }

    public void setSendTime(String sendTime) {
        this.sendTime = sendTime;
    }

    public String getSendTimeBegin() {
        return (null != this.sendTime && null != this.sendTime) ? (sendTime.split(",")[0]) : null;
    }

    public String getSendTimeEnd() {
        return (null != this.sendTime && null != this.sendTime) ? (sendTime.split(",")[1]) : null;
    }
}
