package com.ejianc.foundation.message.service;

import java.util.List;

import com.ejianc.foundation.message.bean.MessageEntity;
import com.ejianc.foundation.message.vo.MessageVO;
import com.ejianc.foundation.message.vo.PageParam;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IMessageService extends IBaseService<MessageEntity> {

    /**
     * 消息发送MQ队列
     *
     * @param pushMsgParameter
     */
    void sendMessage(PushMsgParameter pushMsgParameter);

    /**
     * 查询我的消息总数
     * 
     * @param pageParam
     * @return
     */
	long queryCount(PageParam pageParam);

	/**
	 * 查询我的消息列表
	 * 
	 * @param pageParam
	 * @return
	 */
	List<MessageVO> queryList(PageParam pageParam);

	/**
	 * 删除我的消息
	 * 
	 * @param messageList
	 */
	void delMessage(List<MessageVO> messageList);

	/**
	 * 更改消息为已读
	 * 
	 * @param messageIds
	 */
	void updateMessageStatus(List<Long> messageIds);

	/**
	 * 更改消息为已读
	 * 
	 */
	void updateAllMessageStatus();
}
