package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.taobao.api.ApiException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

@Service("ddOpenApp")
public class DdOpenAppServiceImpl implements IMsgSendChannelProcessor {
	private static Logger logger = LoggerFactory.getLogger(DdOpenAppServiceImpl.class);

	@Autowired
	private IUserApi userApi;
	@Autowired
	private IThirdSystemApi thirdSystemApi;
	@Autowired
	private RedisTemplate<String, Object> redisTemplate;

	@Value("${ejc.dingding.appSecret:https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2}")
	private String sendDdUrl;
	
	@Override
	public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
		JSONObject configJson = null;
		if(StringUtils.isNotBlank(configInfo)) {
			configJson = JSON.parseObject(configInfo);
		}
		String customKey = configJson.getString("customKey");
		String customSecret = configJson.getString("customSecret");
		String corpId = configJson.getString("corpId");
		Long ddAppid = configJson.getLong("appid");
		JSONObject dingdingParams = pushMsgParameter.getDingdingParams();
		//获取钉钉accessToken
		CommonResponse<String> ddAccessTokenResult = thirdSystemApi.getDdOpenAppAccessToken(customKey, customSecret, corpId);
		if(!ddAccessTokenResult.isSuccess()){
			ddAccessTokenResult = thirdSystemApi.getDdOpenAppAccessToken(customKey, customSecret, corpId);
		}
		String ddAccessToken = ddAccessTokenResult.getData();
		logger.info("获取钉钉access Token结果："+ddAccessToken);

		List<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
		CommonResponse<List<UserVO>> userResponse = userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(),Long.parseLong(pushMsgParameter.getTenantId()));
		if(userResponse.isSuccess()) {
			List<UserVO> userVos = userResponse.getData();
			for(UserVO userVo:userVos) {
				String linkDdUrl = ("dingtalk://dingtalkclient/action/openapp?corpid=?corpid="+customKey+"&container_type=work_platform&app_id="+ddAppid+"&redirect_type=jump&redirect_url=");
				if(StringUtils.isBlank(userVo.getDingdingId())) {
					MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "钉钉消息发送失败", userVo.getDingdingId());
					logger.info("向" + userVo.getUserName() + "发送钉钉失败!该用户未绑定钉钉账号！");
					messageResponseList.add(response);
					continue;
				}
				try {
					DingTalkClient client = new DefaultDingTalkClient(sendDdUrl);
					OapiMessageCorpconversationAsyncsendV2Request request = new OapiMessageCorpconversationAsyncsendV2Request();
					request.setAgentId(ddAppid);
					request.setUseridList(userVo.getDingdingId());
					request.setToAllUser(false);
					OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();

					String maurl = null;
//					String pcurl = null;
					if(dingdingParams.get("maurl")!=null){
						maurl = dingdingParams.getString("maurl");
						if (maurl.contains("dingdingid")) {
							maurl = maurl.replaceAll("%7Bdingdingid%7D", userVo.getDingdingId()).replaceAll("%7bdingdingid%7d", userVo.getDingdingId()).replaceAll("\\{dingdingid\\}", userVo.getDingdingId());
						} else if (maurl.contains("userid")) {
							maurl = maurl.replaceAll("%7Buserid%7D", userVo.getId().toString()).replaceAll("%7buserid%7d", userVo.getId().toString()).replaceAll("\\{userid\\}", userVo.getId().toString());
						} else {
							if (maurl.contains("?")) {
								maurl += ("&userid=" + userVo.getId().toString());
							} else {
								maurl += ("?userid=" + userVo.getId().toString());
							}
						}
						try {
							maurl = URLEncoder.encode(maurl, "UTF-8");
						} catch (UnsupportedEncodingException e) {
							e.printStackTrace();
						}
						linkDdUrl += maurl;
					}
					String linkPcDdUrl = "dingtalk://dingtalkclient/page/link?url="+maurl+"&pc_slide=true";
//					if(dingdingParams.get("pcurl")!=null){
//						pcurl = dingdingParams.getString("pcurl");
//					}
					if(dingdingParams.get("type")!=null){
						String type = dingdingParams.getString("type");
						if("text".equals(type)){
							msg.setMsgtype("text");
							msg.setText(new OapiMessageCorpconversationAsyncsendV2Request.Text());
							msg.getText().setContent(dingdingParams.getString("content"));
							request.setMsg(msg);
						}else if("oa".equals(type)){
							msg.setOa(new OapiMessageCorpconversationAsyncsendV2Request.OA());
							msg.getOa().setHead(new OapiMessageCorpconversationAsyncsendV2Request.Head());
							msg.getOa().getHead().setText(dingdingParams.getString("title"));
							msg.getOa().setBody(new OapiMessageCorpconversationAsyncsendV2Request.Body());
							msg.getOa().getBody().setTitle(dingdingParams.getString("title"));
							if(dingdingParams.get("content")!=null){
								msg.getOa().getBody().setContent(dingdingParams.getString("content"));
							}
							List<OapiMessageCorpconversationAsyncsendV2Request.Form> form = new ArrayList<>();
							if(dingdingParams.get("oaJsonData")!=null){
								JSONObject oaJsonData = dingdingParams.getJSONObject("oaJsonData");
								for(String key : oaJsonData.keySet()){
									OapiMessageCorpconversationAsyncsendV2Request.Form e = new OapiMessageCorpconversationAsyncsendV2Request.Form();
									if(StringUtils.isNotBlank(key) && !key.startsWith("空key")){
										e.setKey(key+": ");
									}
									e.setValue(oaJsonData.getString(key));
									form.add(e);
								}
							}
							msg.getOa().getBody().setForm(form);
							msg.getOa().setMessageUrl(linkDdUrl);
							msg.getOa().setPcMessageUrl(linkPcDdUrl);
							msg.setMsgtype("oa");
							request.setMsg(msg);
						}else if("card".equals(type)){
							msg.setActionCard(new OapiMessageCorpconversationAsyncsendV2Request.ActionCard());
							msg.getActionCard().setMarkdown(dingdingParams.getString("title"));
							msg.getActionCard().setSingleTitle(dingdingParams.getString("content"));
							msg.getActionCard().setSingleUrl(linkDdUrl);
							msg.setMsgtype("action_card");
							request.setMsg(msg);
						}else{
							msg.setMsgtype("link");
							msg.setLink(new OapiMessageCorpconversationAsyncsendV2Request.Link());
							msg.getLink().setTitle(dingdingParams.getString("title"));
							msg.getLink().setText(dingdingParams.getString("content"));

							msg.getLink().setMessageUrl(linkDdUrl);
							msg.getLink().setPicUrl(linkPcDdUrl);
							request.setMsg(msg);
						}
					}else{
						if(dingdingParams.get("maurl")!=null) {
							msg.setMsgtype("link");
							msg.setLink(new OapiMessageCorpconversationAsyncsendV2Request.Link());
							msg.getLink().setTitle(dingdingParams.getString("title"));
							msg.getLink().setText(dingdingParams.getString("content"));

							msg.getLink().setMessageUrl(linkDdUrl);
							msg.getLink().setPicUrl(linkPcDdUrl);
							request.setMsg(msg);
						}else {
							OapiMessageCorpconversationAsyncsendV2Request.Text text = new OapiMessageCorpconversationAsyncsendV2Request.Text();
							text.setContent(dingdingParams.getString("content"));
							msg.setText(text);
							msg.setMsgtype("text");
							request.setMsg(msg);
						}
					}
					OapiMessageCorpconversationAsyncsendV2Response response = client.execute(request, ddAccessToken);
					JSONObject body = JSONObject.parseObject(response.getBody());
					logger.info("发送钉钉消息返回结果：---------》》》》"+response.getBody());
					if("0".equals(body.getString("errcode"))){
						
					}else{
						MsgSendResponse msgSendR = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "钉钉消息发送失败:"+body.getString("errmsg"), userVo.getDingdingId());
						logger.info("向" + userVo.getUserName() + userVo.getDingdingId() + "发送钉钉消息失败!--->>>"+body.getString("errmsg"));
						messageResponseList.add(msgSendR);
					}
				} catch (ApiException e) {
					e.printStackTrace();
					logger.error("发送钉钉消息失败-------------》》》》》》：",e);;
				}
				
			}
		}
		return messageResponseList;
	}

}
