package com.ejianc.foundation.message.service.impl;

import java.text.SimpleDateFormat;
import java.util.*;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.bean.MessageEntity;
import com.ejianc.foundation.message.bean.MsgChannelEntity;
import com.ejianc.foundation.message.bean.MsgReceiverUnreadEntity;
import com.ejianc.foundation.message.dispatch.MessageSend;
import com.ejianc.foundation.message.service.IMessageSendService;
import com.ejianc.foundation.message.service.IMessageService;
import com.ejianc.foundation.message.service.IMsgChannelService;
import com.ejianc.foundation.message.service.IMsgReceiverUnreadService;
import com.ejianc.foundation.message.vo.MessageVO;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;

@Service("messageSendService")
public class MessageSendServiceImpl implements IMessageSendService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMessageService messageService;
    @Autowired
    private IMsgChannelService msgChannelService;
    @Autowired
    private IMsgReceiverUnreadService msgReceiverUnreadService;
    @Autowired
	private IUserApi userApi;
    @Autowired
    private IAttachmentApi attachmentApi;

//    Map<channelType, implServiceName>
    @Value("#{${ejc.msg.channelImpl:null}}")
    private Map<String, String> channelImpl;

    @Override
    public void handMessage(String messageJson) {
        logger.info("待发送消息：【{}】", messageJson);
        PushMsgParameter msgParameter = JSONObject.parseObject(messageJson, PushMsgParameter.class);

        //获取要发送消息的渠道类型
        List<String> channelTypeList = new ArrayList<>(Arrays.asList(msgParameter.getChannel()));
        //根据渠道类型获取到租户的渠道发送配置信息
        List<MsgChannelEntity> channelList = msgChannelService.queryMsgSendConfig(msgParameter.getTenantId(), new ArrayList<>(channelTypeList));

        logger.info("待发送消息渠道-{}", JSONObject.toJSONString(channelList));
        for(MsgChannelEntity channel : channelList) {
            try {
                if(!PushMsgParameter.CHANNEL_TYPE_SYS.equals(channel.getType())) {
                    new MessageSend(msgParameter, channel, channelImpl).send();
                } else {
                    CommonResponse<List<UserVO>> userResponse = userApi.queryListByIdsTenantId(msgParameter.getReceivers(),Long.parseLong(msgParameter.getTenantId()));
                    if(userResponse.isSuccess()) {
                        List<UserVO> userVos = userResponse.getData();
                        if(userVos != null && userVos.size() > 0) {
                            Long tenantId = userVos.get(0).getTenantId();
                            MessageVO message = buildMessage(msgParameter);
                            message.setTenantId(tenantId);
                            //系统消息保存数据库 ， 其它消息暂时直接发送
                            //保存消息
                            MessageEntity messageEntity = BeanMapper.map(message, MessageEntity.class);
                            messageService.saveOrUpdate(messageEntity, false);
                            //保存用户未读消息
                            buildAndSaveReceivers(message, userVos);
                        } else {
                            logger.error("向用户{}发送系统消息失败，查询匹配用户信息为空",msgParameter.getReceivers());
                        }
                    }else {
                        logger.error("向用户{}发送系统消息异常，查询用户信息失败{}",msgParameter.getReceivers(), userResponse.getMsg());
                    }
                }
            } catch (Exception e) {
                logger.error("通过渠道-{}，发送消息-【{}】异常，", JSONObject.toJSONString(channel), JSONObject.toJSONString(msgParameter), e);
            }
        }
    }

    @Override
    public void sendUserMsg(PushMsgParameter parameter) {
        logger.info("待发送消息：【{}】", JSONObject.toJSONString(parameter));
        //获取要发送消息的渠道类型
        List<String> channelTypeList = new ArrayList<>(Arrays.asList(parameter.getChannel()));
        //根据渠道类型获取到租户的渠道发送配置信息
        List<MsgChannelEntity> channelList = msgChannelService.queryMsgSendConfig(parameter.getTenantId(), new ArrayList<>(channelTypeList));


        MessageVO message = buildMessage(parameter);
        message.setTenantId(InvocationInfoProxy.getTenantid());

        if(parameter.isSaveFlag() || channelTypeList.contains(PushMsgParameter.CHANNEL_TYPE_SYS)) {
            //保存消息
            MessageEntity messageEntity = BeanMapper.map(parameter, MessageEntity.class);
            messageEntity.setId(message.getId());
            messageService.saveOrUpdate(messageEntity, false);

            if(CollectionUtils.isNotEmpty(parameter.getAttachIds())) {
                CommonResponse<String> resp = attachmentApi.updateAttachRef(messageEntity.getId(), parameter.getAttachIds());
                if(!resp.isSuccess()) {
                    logger.error("附件【ids-{}】对应消息【id-{}】关联关系绑定失败, 原因：{}", JSONArray.toJSONString(parameter.getAttachIds()), messageEntity.getId().toString(), resp.getMsg());
                }
            }

            JSONObject weixinJson = parameter.getWeixinParams();
            if(weixinJson != null && !weixinJson.isEmpty()) {
                //小程序
                JSONObject miniprogram = weixinJson.getJSONObject("miniprogram");
                if(miniprogram != null && !miniprogram.isEmpty()) {
                    String pagepath = null != miniprogram.get("pagepath") ? miniprogram.getString("pagepath") : null;
                    if(StringUtils.isNotBlank(pagepath)) {
                        pagepath = pagepath.replaceAll("%7Bmid%7D", messageEntity.getId().toString()).replaceAll("%7bmid%7d", messageEntity.getId().toString()).replaceAll("\\{mid\\}", messageEntity.getId().toString());
                        miniprogram.put("pagepath", pagepath);
                    }
                }
            }
        }

        logger.info("待发送消息渠道-{}", JSONObject.toJSONString(channelList));
        for(MsgChannelEntity channel : channelList) {
            try {
                if(!PushMsgParameter.CHANNEL_TYPE_SYS.equals(channel.getType())) {
                    new MessageSend(parameter, channel, channelImpl).send();
                } else {
                    CommonResponse<List<UserVO>> userResponse = userApi.queryListByIdsTenantId(parameter.getReceivers(),Long.parseLong(parameter.getTenantId()));
                    if(userResponse.isSuccess()) {
                        List<UserVO> userVos = userResponse.getData();
                        if(CollectionUtils.isNotEmpty(userVos)) {
                            //保存用户未读消息
                            buildAndSaveReceivers(message, userVos);
                        } else {
                            logger.error("向用户{}发送系统消息失败，查询匹配用户信息为空",parameter.getReceivers());
                        }
                    } else {
                        logger.error("向用户{}发送系统消息异常，查询用户信息失败{}",parameter.getReceivers(), userResponse.getMsg());
                    }
                }
            } catch (Exception e) {
                logger.error("通过渠道-{}，发送消息-【{}】异常，", JSONObject.toJSONString(channel), JSONObject.toJSONString(parameter), e);
            }
        }
    }

    /**
     * 查询用户消息发送真正地址
     *
     * @param messageVO  消息
     * @param userVos 消息接收人
     * @return
     */
    private void buildAndSaveReceivers(MessageVO messageVO, List<UserVO> userVos) {
        List<MsgReceiverUnreadEntity> unReadList = new ArrayList<>();
        for(UserVO userVo : userVos) {
        	if(messageVO.getTenantId().longValue() != userVo.getTenantId().longValue()) {
            	continue;
            }
            MsgReceiverUnreadEntity e = new MsgReceiverUnreadEntity();
            e.setMessageId(messageVO.getId());
            e.setReceiverId(userVo.getId());
            e.setTenantId(messageVO.getTenantId());
            e.setCreateUserCode(messageVO.getCreateUserCode());
            unReadList.add(e);
        }

        if(CollectionUtils.isNotEmpty(unReadList)) {
            msgReceiverUnreadService.saveOrUpdateBatch(unReadList, unReadList.size(), false);
        }
    }


    /**
     * 保存消息
     *
     * @param msgParameter 消息推送原始参数
     * @return
     */
    private MessageVO buildMessage(PushMsgParameter msgParameter) {
        MessageVO messageVO = new MessageVO();
        messageVO.setId(IdWorker.getId());
        messageVO.setContent(msgParameter.getContent());
        messageVO.setMobileContent(msgParameter.getMobileContent());
        messageVO.setSubject(msgParameter.getSubject());
        messageVO.setMsgType(msgParameter.getMsgType());
        messageVO.setPcUrl(msgParameter.getPcUrl());
        messageVO.setMobileUrl(msgParameter.getMobileUrl());
        messageVO.setSendUserId(msgParameter.getSendUserId());
        messageVO.setTenantId(Long.valueOf(msgParameter.getTenantId()));
        messageVO.setCreateUserCode(StringUtils.isNotBlank(InvocationInfoProxy.getUsercode()) ? InvocationInfoProxy.getUsercode() : null);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        messageVO.setSendTime(dateFormat.format(new Date()));
        return messageVO;
    }
    
    public static void main(String[] args) {
    	Long a = Long.parseLong("1316333384232796162");
    	Long b = Long.parseLong("1316333384232796162");
		System.out.println(a.equals(b));
	}

}
