package com.ejianc.foundation.message.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.message.bean.MessageEntity;
import com.ejianc.foundation.message.bean.MsgReceiverReadedEntity;
import com.ejianc.foundation.message.mapper.MessageMapper;
import com.ejianc.foundation.message.mapper.MsgReceiverReadedMapper;
import com.ejianc.foundation.message.mapper.MsgReceiverUnreadMapper;
import com.ejianc.foundation.message.service.IMessageService;
import com.ejianc.foundation.message.service.IMsgReceiverReadedService;
import com.ejianc.foundation.message.vo.MessageVO;
import com.ejianc.foundation.message.vo.PageParam;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class MessageServiceImpl extends BaseServiceImpl<MessageMapper, MessageEntity> implements IMessageService {

	@Autowired
	private MessageMapper messageMapper;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private MsgReceiverReadedMapper msgReceiverReadedMapper;
    @Autowired
    private MsgReceiverUnreadMapper msgReceiverUnreadMapper;
    @Autowired
    private IMsgReceiverReadedService msgReceiverReadedService;

    @Override
    public void sendMessage(PushMsgParameter pushMsgParameter) {
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody(pushMsgParameter);
        rabbitTemplate.convertAndSend(PushMsgParameter.MESSAGE_COMMON_QUEUE, mqMessage);
    }

	@Override
	public long queryCount(PageParam pageParam) {
		Long count = messageMapper.queryCount(pageParam);
		return count;
	}

	@Override
	public List<MessageVO> queryList(PageParam pageParam) {
		List<MessageEntity> entities = messageMapper.queryList(pageParam);
		return BeanMapper.mapList(entities, MessageVO.class);
	}

	@Override
	public void delMessage(List<MessageVO> messageList) {
		Long userId = InvocationInfoProxy.getUserid();
		if(messageList != null && messageList.size() > 0) {
			String unReadMessageId = "";
			String readedMessageId = "";
			for(MessageVO messageVo:messageList) {
				if(0 == messageVo.getStatus()) {
					unReadMessageId += messageVo.getId() + ",";
				}else if(1 == messageVo.getStatus()) {
					readedMessageId += messageVo.getId() + ",";
				}
			}
			if(StringUtils.isNotBlank(unReadMessageId)) {
				unReadMessageId = unReadMessageId.substring(0, unReadMessageId.length()-1);
				msgReceiverUnreadMapper.deleteUnreadMessage(unReadMessageId, userId);
			}
			if(StringUtils.isNotBlank(readedMessageId)) {
				readedMessageId = readedMessageId.substring(0, readedMessageId.length()-1);
				msgReceiverReadedMapper.deleteReadedMessage(readedMessageId, userId);
			}
		}
	}

	@Override
	public void updateMessageStatus(List<Long> messageIds) {
		Long userId = InvocationInfoProxy.getUserid();
		if(messageIds != null && messageIds.size() > 0) {
			//删除未读表
			String unReadMessageId = "";
			List<MsgReceiverReadedEntity> readedEntities = new ArrayList<MsgReceiverReadedEntity>();
			for(Long messageId:messageIds) {
				unReadMessageId += messageId + ",";
				
				MsgReceiverReadedEntity msgReceiverReadedEntity = new MsgReceiverReadedEntity();
				msgReceiverReadedEntity.setMessageId(messageId);
				msgReceiverReadedEntity.setReceiverId(userId);
				readedEntities.add(msgReceiverReadedEntity);
				
			}
			unReadMessageId = unReadMessageId.substring(0, unReadMessageId.length()-1);
			msgReceiverUnreadMapper.deleteUnreadMessage(unReadMessageId, userId);
			//插入已读表
			msgReceiverReadedService.saveOrUpdateBatch(readedEntities, readedEntities.size(), false);
		}
	}

	@Override
	public void updateAllMessageStatus() {
		Long userId = InvocationInfoProxy.getUserid();
		msgReceiverUnreadMapper.insertAllReaded(userId);
		msgReceiverUnreadMapper.deleteAllUnreadMessage(userId);
	}
}
