package com.ejianc.foundation.message.service.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.util.GetYonyouTokenUtils;
import com.ejianc.foundation.message.util.HttpTookit;
import com.ejianc.foundation.message.util.WeixinRestUtil;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.google.gson.Gson;

@Service("wjy")
public class WjyMsgServiceImpl implements IMsgSendChannelProcessor {
	private static Logger logger = LoggerFactory.getLogger(WjyMsgServiceImpl.class);

	private static Gson gson = new Gson();

	@Value("${common.env.base-host}")
	private String baseHost;
	@Value("${yonYouCloud.wujuTenantId:aesw7o8h}")
	private String yonTenantId;
	@Value("${yonYouCloud.sendMessageUrl}")
	private String sendMessageUrl;
	@Autowired
	private IUserApi userApi;
	@Autowired
	private CacheManager cacheManager;
	@Autowired
	private GetYonyouTokenUtils getYonyouTokenUtils;

	@Override
	public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
		logger.info("五局云消息发送");
		JSONObject configJson = null;
		if(StringUtils.isNotBlank(configInfo)) {
			configJson = JSON.parseObject(configInfo);
		}
		List<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
		CommonResponse<List<UserVO>> userResponse = userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(),Long.parseLong(pushMsgParameter.getTenantId()));

		logger.info("cacheManager------->"+cacheManager);
		String token = cacheManager.get("wujuToken");
		if(token==null){
			token = getYonyouTokenUtils.getToken();
		}

		JSONObject wjyMsgJson = pushMsgParameter.getWjyMsgParams();
		if(userResponse.isSuccess()) {
			List<UserVO> userVoList = userResponse.getData();
			for(UserVO userVo:userVoList) {
				JSONObject templateJson = new JSONObject();
				templateJson.put("appid", wjyMsgJson.getString("appid"));
				templateJson.put("from", wjyMsgJson.getString("from"));
				templateJson.put("msg", wjyMsgJson.getString("msg"));
				templateJson.put("msgtype", "0");
				templateJson.put("redirect", "0");
				List<String> targets = new ArrayList<>();
				targets.add(userVo.getUserCode());
				templateJson.put("target", targets);
				templateJson.put("target_type", "users");
				String url = "";
				if(wjyMsgJson.get("url")!=null){
					url = wjyMsgJson.getString("url");
					url = url.replaceAll("%7Buserid%7D", userVo.getId()+"").replaceAll("%7buserid%7d", userVo.getId()+"")
							 .replaceAll("%7BuserId%7D", userVo.getId()+"").replaceAll("%7buserId%7d", userVo.getId()+"")
							 .replaceAll("\\{userid\\}", userVo.getId()+"");
				}
				templateJson.put("url", url);
				String templateContent = JSON.toJSONString(templateJson);
				logger.info("-->五局云消息发送参数：{}", templateContent);
				String templateResult = WeixinRestUtil.doPostHttpByURL(configJson.getString("send_url"), templateContent);
				logger.info("五局云消息发送结果：{}",templateResult);

				JSONObject httpResult = JSON.parseObject(templateResult);
				if(httpResult != null) {
					logger.info("wjy_response = "+JSON.toJSONString(httpResult));
					if ("0".equals(httpResult.get("flag"))) {
						logger.info("向" + userVo.getUserName() + "发送五局云消息成功!");
					} else {
						MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, httpResult.getString("desc"));
						messageResponseList.add(response);
					}
				}



				List<String> users = new ArrayList<>();
				JSONObject userData = getYonyouTokenUtils.getNcUser(userVo.getUserCode());
				if(userData!=null){
					users.add(userData.getString("user_id"));
				}
				Map<String, Object> paramterMap = new HashMap<>();
				paramterMap.put("appId", IdWorker.getId());
				paramterMap.put("title", "轻量化平台【通知】");
				paramterMap.put("content", wjyMsgJson.getString("msg"));
				paramterMap.put("yhtUserIds", users);
				paramterMap.put("tenantId", yonTenantId);
				paramterMap.put("url", url);
				String webUrl = "";
				if(wjyMsgJson.get("webUrl")!=null){
					webUrl = wjyMsgJson.getString("webUrl");
					try {
						webUrl = (baseHost+"/portal/sso/index?userid="+userVo.getId()+"&targeturl="+URLEncoder.encode(wjyMsgJson.getString("webUrl"), "utf-8"));
					} catch (UnsupportedEncodingException e) {
						e.printStackTrace();
					}
				}
				paramterMap.put("webUrl", webUrl);
				paramterMap.put("sendScope", "list");

				String serverUrl = sendMessageUrl + "?access_token="+token;
				String paramterStr = gson.toJson(paramterMap);
				try {
					logger.info("传递的参数：---------------"+paramterStr);
					logger.info("传递的serverUrl：---------------"+serverUrl);
					String result = HttpTookit.postByJson(serverUrl, paramterStr, null);
					logger.info("调用五局消息返回结果：---------------"+result);
					JSONObject resultjson = JSONObject.parseObject(result);
					if("310036".equals(resultjson.getString("code"))){
						//预防token失效时重新执行一遍
						token = getYonyouTokenUtils.getToken();
						result = HttpTookit.postByJson(serverUrl, paramterStr, null);
					}
				} catch (Exception e) {
					e.printStackTrace();
					logger.info("发送五局友空间消息失败");
					logger.info(e.getMessage());
				}
			}

		}

		return messageResponseList;
	}

}
