package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.controller.param.SmsMessageParam;
import com.ejianc.foundation.message.service.ISmsService;
import com.ejianc.foundation.message.util.ProduceNumber;
import com.ejianc.foundation.message.util.Validate;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springside.modules.nosql.redis.JedisTemplate;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@Service("zdsSupSmsService")
public class ZdsSupSmsServiceImpl implements ISmsService {
	private static final Logger logger = LoggerFactory.getLogger(ZdsSupSmsServiceImpl.class);
	
	@Autowired
	private JedisTemplate jedis;
	@Value("${ejc.sms.zds.host:0}")
	private String smsHost;
	@Value("${ejc.sms.zds.appid:0}")
	private String appid;
	@Value("${ejc.sms.zds.secret:0}")
	private String secret;
	@Value("${ejc.sms.zds.sup.elhost:0}")
	private String ElHost;
	@Value("${ejc.sms.zds.sup.elappid:0}")
	private String ElAppId;
	@Value("${ejc.sms.zds.sup.elsecret:0}")
	private String ElSecret;

	@Autowired
	private ISystemDataPushService systemDataPushService;

	private final String EL_SMS_URL = "/ejc-message-web/openapi/no_auth/sms/sendMessage";

	@Override
	public CommonResponse<String> sendMessage(SmsMessageParam param) {
		logger.info("发送短信参数：{}", param.toString());
		try {
			if(StringUtils.isBlank(param.getTemplateCode())) {
				logger.error("参数-{} 短信模板编号为空", JSONObject.toJSONString(param));
				return CommonResponse.error("短信模板编号不能为空！");
			}
			if(StringUtils.isBlank(param.getSignName())) {
				logger.error("参数-{} 短信签名为空", JSONObject.toJSONString(param));
				return CommonResponse.error("短信签名不能为空！");
			}
			if(!Validate.isMobile(param.getPhone())) {
				logger.error("参数-{} 手机号【{}】不合法", JSONObject.toJSONString(param), param.getPhone());
				return CommonResponse.error("手机号不合法！");
			}

			String rand = ProduceNumber.produce();

			param.getParams().put("rand", rand);
			logger.info("调用EL平台短信发送参数: param={} ElAppId={},ElSecret-{},ElHost-{}",JSONObject.toJSONString(param),
					ElAppId, ElSecret, ElHost);
			CommonResponse<String> smsSendResult = systemDataPushService.exchangeDataWithUniversal(EL_SMS_URL, RequestMethod.POST, JSONObject.toJSONString(param), ElAppId, ElSecret, ElHost);
			if(!smsSendResult.isSuccess()) {
				logger.error("调用EL平台进行短信发送失败，{}", JSONObject.toJSONString(smsSendResult));
				return CommonResponse.success("短信发送失败！");
			}
			CommonResponse<String> msgSendResult = JSONObject.parseObject(smsSendResult.getData(), CommonResponse.class);
			if(msgSendResult.isSuccess()) {
				jedis.setex(param.getTemplateCode()+param.getPhone(), rand, 600);
				return CommonResponse.success("短信发送成功！");
			} else {
				logger.info("短信发送失败！{}", smsSendResult.getData());
				return CommonResponse.error(msgSendResult.getMsg());
			}

		} catch(Exception ex) {
			logger.error("根据参数[{}]-发送短息异常", JSONObject.toJSONString(param));
			logger.error("发送短信异常",ex);
		}
		return CommonResponse.error("短信发送失败");
	}

	private static String toMD5(String plainText) {
		MessageDigest digest = null;
		try {
			digest = MessageDigest.getInstance("MD5");
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		}
		byte[] hashBytes = digest.digest(plainText.getBytes());
		StringBuilder sb = new StringBuilder();
		for (byte b : hashBytes) {
			sb.append(Integer.toString((b & 0xff) + 0x100, 16).substring(1));
		}
		return sb.toString().toLowerCase();
	}

}
