/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiMessageCorpconversationSendbytemplateRequest;
import com.dingtalk.api.response.OapiMessageCorpconversationSendbytemplateResponse;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="ddThirdApp")
public class DdThirdAppServiceImpl
implements IMsgSendChannelProcessor {
    private static Logger logger = LoggerFactory.getLogger(DdThirdAppServiceImpl.class);
    @Autowired
    private IUserApi userApi;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IThirdSystemApi thirdSystemApi;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Value(value="${ejc.dingding.appSecret:https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2}")
    private String sendDdUrl;

    @Override
    public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
        JSONObject configJson = null;
        if (StringUtils.isNotBlank((CharSequence)configInfo)) {
            configJson = JSON.parseObject((String)configInfo);
        }
        String ddAppid = configJson.getString("appid");
        ArrayList<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
        JSONObject dingdingParams = pushMsgParameter.getDingdingParams();
        Long tenantId = InvocationInfoProxy.getTenantid() != null ? InvocationInfoProxy.getTenantid() : Long.parseLong(pushMsgParameter.getTenantId());
        logger.error("tenantId------------" + tenantId);
        CommonResponse ddAccessTokenResult = this.thirdSystemApi.getDdThirdAppAccessToken(tenantId);
        CommonResponse tenantResponse = this.tenantApi.queryDetail(tenantId);
        String corpid = null;
        if (tenantResponse.isSuccess() && tenantResponse.getData() != null) {
            corpid = ((TenantVO)tenantResponse.getData()).getCorpid();
        }
        if (StringUtils.isBlank(corpid)) {
            logger.error("\u53d1\u9001\u9489\u9489\u6d88\u606f\u5931\u8d25,\u4e3a\u83b7\u53d6\u5230\u79df\u6237\u7684\u9489\u9489\u4f01\u4e1aid------------");
            return messageResponseList;
        }
        String ddAgentid = null;
        CommonResponse agentidResponse = this.thirdSystemApi.getDdThirdAgentid(corpid);
        if (agentidResponse.isSuccess() && agentidResponse.getData() != null) {
            ddAgentid = (String)agentidResponse.getData();
        }
        if (StringUtils.isBlank(ddAgentid)) {
            logger.error("\u53d1\u9001\u9489\u9489\u6d88\u606f\u5931\u8d25,\u4e3a\u83b7\u53d6\u5230\u79df\u6237\u7684\u9489\u9489\u4f01\u4e1aagentid------------");
            return messageResponseList;
        }
        String ddAccessToken = (String)ddAccessTokenResult.getData();
        logger.info("\u83b7\u53d6\u9489\u9489access Token\u7ed3\u679c\uff1a" + ddAccessToken);
        if (StringUtils.isBlank((CharSequence)ddAccessToken)) {
            logger.error("\u53d1\u9001\u9489\u9489\u6d88\u606f\u5931\u8d25,\u4e3a\u83b7\u53d6\u5230\u9489\u9489ddAccessToken------------");
            return messageResponseList;
        }
        CommonResponse userResponse = this.userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(), Long.valueOf(Long.parseLong(pushMsgParameter.getTenantId())));
        if (userResponse.isSuccess()) {
            List userVos = (List)userResponse.getData();
            for (UserVO userVo : userVos) {
                if (StringUtils.isBlank((CharSequence)userVo.getSourceId())) {
                    MsgSendResponse response = new MsgSendResponse("0", "\u9489\u9489\u6d88\u606f\u53d1\u9001\u5931\u8d25", userVo.getDingdingId());
                    logger.info("\u5411" + userVo.getUserName() + "\u53d1\u9001\u9489\u9489\u5931\u8d25!\u8be5\u7528\u6237\u672a\u7ed1\u5b9a\u9489\u9489\u8d26\u53f7\uff01");
                    messageResponseList.add(response);
                    continue;
                }
                try {
                    String linkDdUrl = "dingtalk://dingtalkclient/action/openapp?corpid=" + corpid + "&container_type=work_platform&app_id=" + ddAppid + "&redirect_type=jump&redirect_url=";
                    String templateId = dingdingParams.getString("templateId");
                    DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/message/corpconversation/sendbytemplate");
                    OapiMessageCorpconversationSendbytemplateRequest req = new OapiMessageCorpconversationSendbytemplateRequest();
                    req.setAgentId(Long.valueOf(Long.parseLong(ddAgentid)));
                    req.setUseridList(userVo.getSourceId());
                    req.setTemplateId(templateId);
                    JSONObject data = new JSONObject();
                    if (dingdingParams.get((Object)"type") != null) {
                        String pcurl;
                        String maurl;
                        if ("bpmTask".equals(dingdingParams.getString("type"))) {
                            maurl = dingdingParams.getString("maurl");
                            pcurl = dingdingParams.getString("pcurl");
                            maurl = this.dealUrl(maurl, userVo);
                            pcurl = this.dealUrl(pcurl, userVo);
                            maurl = linkDdUrl + maurl;
                            pcurl = linkDdUrl + pcurl;
                            data.put("title", (Object)dingdingParams.getString("title"));
                            data.put("pcUrl", (Object)pcurl);
                            data.put("content", (Object)dingdingParams.getString("content"));
                            data.put("linkUrl", (Object)maurl);
                            data.put("billTypeName", (Object)dingdingParams.getString("billTypeName"));
                            data.put("submitUserName", (Object)dingdingParams.getString("submitUserName"));
                            data.put("approveTime", (Object)dingdingParams.getString("approveTime"));
                        } else if ("bpmNotice".equals(dingdingParams.getString("type"))) {
                            maurl = dingdingParams.getString("maurl");
                            pcurl = dingdingParams.getString("pcurl");
                            maurl = this.dealUrl(maurl, userVo);
                            pcurl = this.dealUrl(pcurl, userVo);
                            maurl = linkDdUrl + maurl;
                            pcurl = linkDdUrl + pcurl;
                            data.put("title", (Object)dingdingParams.getString("title"));
                            data.put("pcUrl", (Object)pcurl);
                            data.put("content", (Object)dingdingParams.getString("content"));
                            data.put("linkUrl", (Object)maurl);
                            data.put("billTypeName", (Object)dingdingParams.getString("billTypeName"));
                            data.put("userLabel", (Object)dingdingParams.getString("userLabel"));
                            data.put("userName", (Object)dingdingParams.getString("userName"));
                            data.put("timeLabel", (Object)dingdingParams.getString("timeLabel"));
                            data.put("timeValue", (Object)dingdingParams.getString("timeValue"));
                        }
                    }
                    logger.info("\u52a8\u6001\u53d8\u91cf\u8d4b\u503c:------------" + data.toJSONString());
                    req.setDataString(data.toJSONString());
                    OapiMessageCorpconversationSendbytemplateResponse response = (OapiMessageCorpconversationSendbytemplateResponse)client.execute((TaobaoRequest)req, ddAccessToken);
                    JSONObject body = JSONObject.parseObject((String)response.getBody());
                    logger.info("\u53d1\u9001\u9489\u9489\u6d88\u606f\u8fd4\u56de\u7ed3\u679c\uff1a---------\u300b\u300b\u300b\u300b" + response.getBody());
                    if ("0".equals(body.getString("errcode"))) continue;
                    MsgSendResponse msgSendR = new MsgSendResponse("0", "\u9489\u9489\u6d88\u606f\u53d1\u9001\u5931\u8d25:" + body.getString("errmsg"), userVo.getDingdingId());
                    logger.info("\u5411" + userVo.getUserName() + userVo.getSourceId() + "\u53d1\u9001\u9489\u9489\u6d88\u606f\u5931\u8d25!--->>>" + body.getString("errmsg"));
                    messageResponseList.add(msgSendR);
                }
                catch (ApiException e) {
                    e.printStackTrace();
                    logger.error("\u53d1\u9001\u9489\u9489\u6d88\u606f\u5931\u8d25-------------\u300b\u300b\u300b\u300b\u300b\u300b\uff1a", (Throwable)e);
                }
            }
        }
        return messageResponseList;
    }

    public String dealUrl(String url, UserVO userVo) {
        url = url.contains("ddThirdAppid") ? url.replaceAll("%7BddThirdAppid%7D", userVo.getSourceId()).replaceAll("%7bddThirdAppid%7d", userVo.getSourceId()).replaceAll("\\{ddThirdAppid\\}", userVo.getSourceId()) : (url.contains("userid") ? url.replaceAll("%7Buserid%7D", userVo.getId().toString()).replaceAll("%7buserid%7d", userVo.getId().toString()).replaceAll("\\{userid\\}", userVo.getId().toString()) : (url.contains("?") ? url + "&userid=" + userVo.getId().toString() : url + "?userid=" + userVo.getId().toString()));
        try {
            url = URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return url;
    }
}

