/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.util.WeixinRestUtil;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="weixinSupplier")
public class WeixinSupplierServiceImpl
implements IMsgSendChannelProcessor {
    private static Logger logger = LoggerFactory.getLogger(WeixinSupplierServiceImpl.class);
    @Autowired
    private IUserApi userApi;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
        JSONObject configJson = null;
        if (StringUtils.isNotBlank((CharSequence)configInfo)) {
            configJson = JSON.parseObject((String)configInfo);
        }
        ArrayList<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
        CommonResponse userResponse = this.userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(), Long.valueOf(Long.parseLong(pushMsgParameter.getTenantId())));
        JSONObject weixinJson = pushMsgParameter.getWeixinParams();
        if (userResponse.isSuccess()) {
            List userVos = (List)userResponse.getData();
            JSONObject templateJson = new JSONObject();
            templateJson.put("template_id", (Object)weixinJson.getString("template_id"));
            JSONObject wxparams = weixinJson.getJSONObject("data");
            if (wxparams != null && !wxparams.isEmpty()) {
                JSONObject wxparamJson = new JSONObject();
                for (String key : wxparams.keySet()) {
                    JSONObject keyJson = new JSONObject();
                    keyJson.put("value", wxparams.get((Object)key));
                    if ("remark".equals(key)) {
                        keyJson.put("color", (Object)"#0274f2");
                    }
                    wxparamJson.put(key, (Object)keyJson);
                }
                templateJson.put("data", (Object)wxparamJson);
            }
            JSONObject miniprogram = weixinJson.getJSONObject("miniprogram");
            for (UserVO userVo : userVos) {
                if (StringUtils.isBlank((CharSequence)userVo.getWeixinId())) {
                    MsgSendResponse response = new MsgSendResponse("0", "\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u53d1\u9001\u5931\u8d25", userVo.getWeixinId());
                    logger.info("\u5411" + userVo.getWeixinId() + "\u53d1\u9001\u5fae\u4fe1\u5931\u8d25!");
                    messageResponseList.add(response);
                    continue;
                }
                String wxurl = weixinJson.getString("url");
                if (StringUtils.isNotBlank((CharSequence)wxurl)) {
                    wxurl = wxurl.replaceAll("%7Bopenid%7D", userVo.getWeixinId()).replaceAll("%7bopenid%7d", userVo.getWeixinId()).replaceAll("\\{openid\\}", userVo.getWeixinId());
                    templateJson.put("url", (Object)wxurl);
                }
                if (miniprogram != null && !miniprogram.isEmpty()) {
                    String pagepath;
                    String string = pagepath = null != miniprogram.get((Object)"pagepath") ? miniprogram.getString("pagepath") : null;
                    if (StringUtils.isNotBlank((CharSequence)pagepath)) {
                        pagepath = pagepath.replaceAll("%7Bopenid%7D", userVo.getWeixinId()).replaceAll("%7bopenid%7d", userVo.getWeixinId()).replaceAll("\\{openid\\}", userVo.getWeixinId());
                        miniprogram.put("pagepath", (Object)pagepath);
                    }
                    templateJson.put("miniprogram", (Object)miniprogram);
                }
                templateJson.put("touser", (Object)userVo.getWeixinId());
                String templateContent = JSON.toJSONString((Object)templateJson);
                logger.info("\u5fae\u4fe1\u53d1\u9001\u4fe1\u606f,{}", (Object)templateContent);
                String appid = configJson.getString("appid");
                String secret = configJson.getString("secret");
                String accessToken = this.getWeixinAccessToken(appid, secret, false);
                logger.info("access_token = " + accessToken);
                String templateResult = WeixinRestUtil.doPostByURL("https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + accessToken, templateContent);
                JSONObject httpResult = JSON.parseObject((String)templateResult);
                if (httpResult != null) {
                    logger.info("weixin_response = " + JSON.toJSONString((Object)httpResult));
                }
                if ("ok".equals(httpResult.get((Object)"errmsg"))) {
                    logger.info("\u5411" + userVo.getWeixinId() + "\u53d1\u9001\u5fae\u4fe1\u6210\u529f!");
                    continue;
                }
                if ("40001".equals(httpResult.getString("errcode"))) {
                    this.getWeixinAccessToken(appid, secret, true);
                }
                MsgSendResponse response = new MsgSendResponse("0", "\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u53d1\u9001\u5931\u8d25", userVo.getWeixinId());
                logger.info("\u5411" + userVo.getWeixinId() + "\u53d1\u9001\u5fae\u4fe1\u5931\u8d25!");
                messageResponseList.add(response);
            }
        }
        return messageResponseList;
    }

    public String getWeixinAccessToken(String appid, String secret, boolean reload) {
        String key = appid + "_" + secret;
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)key);
        logger.info("redis----accessToken=" + accessToken);
        System.out.println("redis----accessToken=" + accessToken);
        if (StringUtils.isBlank((CharSequence)accessToken) || reload) {
            JSONObject accessJson;
            String accessResult = WeixinRestUtil.doGetByURL("https://api.weixin.qq.com/cgi-bin/token", "grant_type=client_credential&appid=" + appid + "&secret=" + secret);
            logger.info("accessResult=" + accessResult);
            System.out.println("accessResult=" + accessResult);
            if (StringUtils.isNotBlank((CharSequence)accessResult) && StringUtils.isNotBlank((CharSequence)(accessToken = (accessJson = JSON.parseObject((String)accessResult)).getString("access_token")))) {
                this.redisTemplate.opsForValue().set((Object)key, (Object)accessToken, 7000L, TimeUnit.SECONDS);
            }
        }
        return accessToken;
    }
}

