package com.ejianc.foundation.message.dispatch;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;

public class SendChannelExtFactory {

    private static final Logger logger = LoggerFactory.getLogger(SendChannelExtFactory.class);

    public SendChannelExtFactory() {
    }

    public static IMsgSendChannelProcessor getInstance(String channelType) throws BusinessException {
        IMsgSendChannelProcessor channelProcessor = ContextUtil.getBean(channelType, IMsgSendChannelProcessor.class);
        if(null == channelProcessor) {
            logger.error("没有配置与{}对应的消息发送渠道实现。请检查消息渠道插件信息配置，或者传入的发送渠道类型有误!", channelType);
            throw new BusinessException("没有配置与"+channelType+"对应的消息发送渠道实现。请检查消息渠道插件信息配置，或者传入的发送渠道类型有误!");
        }
        return channelProcessor;
    }
}
