package com.ejianc.foundation.message.service.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.taobao.api.ApiException;

@Service("dingding")
public class DingdingServiceImpl implements IMsgSendChannelProcessor {
	private static Logger logger = LoggerFactory.getLogger(DingdingServiceImpl.class);

	@Autowired
	private IUserApi userApi;
	@Autowired
	private IThirdSystemApi thirdSystemApi;
	@Autowired
	private RedisTemplate<String, Object> redisTemplate;

	@Value("${ejc.dingding.appid:1465075370}")
	private Long ddAppid;

//	@Value("${ejc.dingding.appkey:dingqmy9xtqvhvrxrssb}")
//	private String ddAppkey;
//
//	@Value("${ejc.dingding.appSecret:6BtqGLVReboqAsN1XcTji92dqa8_6_7UPgqEP9haXOs_y8IdRz9OlURUO9-aLsPw}")
//	private String ddAppSecret;

	@Value("${ejc.dingding.appSecret:https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2}")
	private String sendDdUrl;
	
	@Override
	public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
		JSONObject configJson = null;
		if(StringUtils.isNotBlank(configInfo)) {
			configJson = JSON.parseObject(configInfo);
		}
		String ddAppkey = configJson.getString("appid");
		String ddAppSecret = configJson.getString("appsecret");
		if(configJson.get("aid")!=null){
			ddAppid = configJson.getLong("aid");
		}
		JSONObject dingdingParams = pushMsgParameter.getDingdingParams();
		//获取钉钉accessToken
		CommonResponse<String> ddAccessTokenResult = thirdSystemApi.getDingDingAccessToken(ddAppkey, ddAppSecret, false);
		if(!ddAccessTokenResult.isSuccess()){
			ddAccessTokenResult = thirdSystemApi.getDingDingAccessToken(ddAppkey, ddAppSecret, true);
		}
		String ddAccessToken = ddAccessTokenResult.getData();
		logger.info("获取钉钉access Token结果："+ddAccessToken);
//		sendDdUrl += ddAccessToken;
		
		
		List<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
		CommonResponse<List<UserVO>> userResponse = userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(),Long.parseLong(pushMsgParameter.getTenantId()));
		if(userResponse.isSuccess()) {
			List<UserVO> userVos = userResponse.getData();
			for(UserVO userVo:userVos) {
				String linkDdUrl = ("dingtalk://dingtalkclient/action/openapp?corpid=?corpid="+ddAppkey+"&container_type=work_platform&app_id="+ddAppid+"&redirect_type=jump&redirect_url=");
				if(StringUtils.isBlank(userVo.getDingdingId())) {
					MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "钉钉消息发送失败", userVo.getDingdingId());
					logger.info("向" + userVo.getUserName() + "发送钉钉失败!该用户未绑定钉钉账号！");
					messageResponseList.add(response);
					continue;
				}
				try {
					DingTalkClient client = new DefaultDingTalkClient(sendDdUrl);
					OapiMessageCorpconversationAsyncsendV2Request request = new OapiMessageCorpconversationAsyncsendV2Request();
					request.setAgentId(ddAppid);
					request.setUseridList(userVo.getDingdingId());
					request.setToAllUser(false);
					OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
					String maurl = null;
//					String pcurl = null;
					if(dingdingParams.get("maurl")!=null){
						maurl = dingdingParams.getString("maurl");
						if (maurl.contains("dingdingid")) {
							maurl = maurl.replaceAll("%7Bdingdingid%7D", userVo.getDingdingId()).replaceAll("%7bdingdingid%7d", userVo.getDingdingId()).replaceAll("\\{dingdingid\\}", userVo.getDingdingId());
						} else if (maurl.contains("userid")) {
							maurl = maurl.replaceAll("%7Buserid%7D", userVo.getId().toString()).replaceAll("%7buserid%7d", userVo.getId().toString()).replaceAll("\\{userid\\}", userVo.getId().toString());
						} else {
							if (maurl.contains("?")) {
								maurl += ("&userid=" + userVo.getId().toString());
							} else {
								maurl += ("?userid=" + userVo.getId().toString());
							}
						}
						try {
							maurl = URLEncoder.encode(maurl, "UTF-8");
						} catch (UnsupportedEncodingException e) {
							e.printStackTrace();
						}
						linkDdUrl += maurl;
					}
//					if(dingdingParams.get("pcurl")!=null){
//						pcurl = dingdingParams.getString("pcurl");
//					}
					String linkPcDdUrl = "dingtalk://dingtalkclient/page/link?url="+maurl+"&pc_slide=true";
					if(dingdingParams.get("type")!=null){
						String type = dingdingParams.getString("type");
						if("text".equals(type)){
							msg.setMsgtype("text");
							msg.setText(new OapiMessageCorpconversationAsyncsendV2Request.Text());
							msg.getText().setContent(dingdingParams.getString("content"));
							request.setMsg(msg);
						}else if("oa".equals(type)){
							msg.setOa(new OapiMessageCorpconversationAsyncsendV2Request.OA());
							msg.getOa().setHead(new OapiMessageCorpconversationAsyncsendV2Request.Head());
							msg.getOa().getHead().setText(dingdingParams.getString("title"));
							msg.getOa().setBody(new OapiMessageCorpconversationAsyncsendV2Request.Body());
							msg.getOa().getBody().setTitle(dingdingParams.getString("title"));
							if(dingdingParams.get("content")!=null){
								msg.getOa().getBody().setContent(dingdingParams.getString("content"));
							}
							List<OapiMessageCorpconversationAsyncsendV2Request.Form> form = new ArrayList<>();
							if(dingdingParams.get("oaJsonData")!=null){
								JSONObject oaJsonData = dingdingParams.getJSONObject("oaJsonData");
								for(String key : oaJsonData.keySet()){
									OapiMessageCorpconversationAsyncsendV2Request.Form e = new OapiMessageCorpconversationAsyncsendV2Request.Form();
									if(StringUtils.isNotBlank(key) && !key.startsWith("空key")){
										e.setKey(key+": ");
									}
									e.setValue(oaJsonData.getString(key));
									form.add(e);
								}
							}
							msg.getOa().getBody().setForm(form);
							msg.getOa().setMessageUrl(linkDdUrl);
							msg.getOa().setPcMessageUrl(linkPcDdUrl);
							msg.setMsgtype("oa");
							request.setMsg(msg);
						}else if("card".equals(type)){
							msg.setActionCard(new OapiMessageCorpconversationAsyncsendV2Request.ActionCard());
							msg.getActionCard().setMarkdown(dingdingParams.getString("title"));
							msg.getActionCard().setSingleTitle(dingdingParams.getString("content"));
							msg.getActionCard().setSingleUrl(linkDdUrl);
							msg.setMsgtype("action_card");
							request.setMsg(msg);
						}else{
							msg.setMsgtype("link");
							msg.setLink(new OapiMessageCorpconversationAsyncsendV2Request.Link());
							msg.getLink().setTitle(dingdingParams.getString("title"));
							msg.getLink().setText(dingdingParams.getString("content"));

							msg.getLink().setMessageUrl(linkDdUrl);
							msg.getLink().setPicUrl(linkPcDdUrl);
							request.setMsg(msg);
						}
					}else{
						if(dingdingParams.get("maurl")!=null) {
							msg.setMsgtype("link");
							msg.setLink(new OapiMessageCorpconversationAsyncsendV2Request.Link());
							msg.getLink().setTitle(dingdingParams.getString("title"));
							msg.getLink().setText(dingdingParams.getString("content"));

							msg.getLink().setMessageUrl(linkDdUrl);
							msg.getLink().setPicUrl(linkPcDdUrl);
							request.setMsg(msg);
						}else {
							OapiMessageCorpconversationAsyncsendV2Request.Text text = new OapiMessageCorpconversationAsyncsendV2Request.Text();
							text.setContent(dingdingParams.getString("content"));
							msg.setText(text);
							msg.setMsgtype("text");
							request.setMsg(msg);
						}
					}

					OapiMessageCorpconversationAsyncsendV2Response response = client.execute(request, ddAccessToken);
					JSONObject body = JSONObject.parseObject(response.getBody());
					logger.info("发送钉钉消息返回结果：---------》》》》"+response.getBody());
					if("0".equals(body.getString("errcode"))){
						
					}else{
						MsgSendResponse msgSendR = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "钉钉消息发送失败:"+body.getString("errmsg"), userVo.getDingdingId());
						logger.info("向" + userVo.getUserName() + userVo.getDingdingId() + "发送钉钉消息失败!--->>>"+body.getString("errmsg"));
						messageResponseList.add(msgSendR);
					}
				} catch (ApiException e) {
					e.printStackTrace();
					logger.error("发送钉钉消息失败-------------》》》》》》：",e);;
				}
				
			}
		}
		return messageResponseList;
	}

	public static void main(String[] arguments) throws ApiException {
		//测试钉钉消息
		DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2");
		OapiMessageCorpconversationAsyncsendV2Request request = new OapiMessageCorpconversationAsyncsendV2Request();
		request.setAgentId(1465075370L);
		request.setUseridList("01141823511126293769");
		request.setToAllUser(false);

		OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();

		/*
		//1、文本消息
		msg.setMsgtype("text");
		msg.setText(new OapiMessageCorpconversationAsyncsendV2Request.Text());
		msg.getText().setContent("test123");
		request.setMsg(msg);

		//5、链接消息
		msg.setMsgtype("link");
		msg.setLink(new OapiMessageCorpconversationAsyncsendV2Request.Link());
		msg.getLink().setTitle("标题");
		msg.getLink().setText("内容内容内容内容内容内容内容内容");
		msg.getLink().setMessageUrl("https://dev.17elian.com/ejc-zjkjapproval-mobile/#/inContract/constructionContract?id=577893569709883454&userid=303581417601122400");
		msg.getLink().setPicUrl("https://dev.17elian.com/ejc-zjkjapproval-mobile/#/inContract/constructionContract?id=577893569709883454&userid=303581417601122400");
		request.setMsg(msg);
		*/

		//6、oa消息
		msg.setOa(new OapiMessageCorpconversationAsyncsendV2Request.OA());
		msg.getOa().setHead(new OapiMessageCorpconversationAsyncsendV2Request.Head());
		msg.getOa().getHead().setText("oa消息标题");
		msg.getOa().setBody(new OapiMessageCorpconversationAsyncsendV2Request.Body());
		msg.getOa().getBody().setTitle("---oa消息标题----");
		msg.getOa().getBody().setContent("内容内容内容内容内容内容内容");
		List<OapiMessageCorpconversationAsyncsendV2Request.Form> form = new ArrayList<>();
		OapiMessageCorpconversationAsyncsendV2Request.Form e = new OapiMessageCorpconversationAsyncsendV2Request.Form();
		e.setKey("单据类型");
		e.setValue("合同管理");
		form.add(e);

		OapiMessageCorpconversationAsyncsendV2Request.Form e1 = new OapiMessageCorpconversationAsyncsendV2Request.Form();
		e1.setKey("单据编码");
		e1.setValue("SDFF10033423482893");
		form.add(e1);

		msg.getOa().getBody().setForm(form);
		String linkDdUrl = ("dingtalk://dingtalkclient/action/openapp?corpid=?corpid=dingc6b8e384dc67b70f35c2f4657eb6378f&container_type=work_platform&app_id=1465075370L&redirect_type=jump&redirect_url=");
		String maurl = "https://dev.17elian.com/ejc-zjkjapproval-mobile/#/inContract/constructionContract?id=577893569709883454&userid=303581417601122400";

		String pcUrl = "https://dev.17elian.com/ejc-incontract-frontend/#/constructionContract/card?id=701477426643484719";
		try {
			maurl = URLEncoder.encode(maurl, "UTF-8");
			pcUrl = URLEncoder.encode(pcUrl, "UTF-8");
		} catch (UnsupportedEncodingException eq) {
			eq.printStackTrace();
		}

		msg.getOa().setMessageUrl(linkDdUrl+maurl);
		String linkPcDdUrl = "dingtalk://dingtalkclient/page/link?url="+pcUrl+"&pc_slide=false";
		msg.getOa().setPcMessageUrl(linkPcDdUrl);
		msg.setMsgtype("oa");
		request.setMsg(msg);

		/*
		//8、卡片消息
		msg.setActionCard(new OapiMessageCorpconversationAsyncsendV2Request.ActionCard());
		msg.getActionCard().setMarkdown("### 测试123111");
		msg.getActionCard().setSingleTitle("测试测试");
		msg.getActionCard().setSingleUrl("https://dev.17elian.com/ejc-zjkjapproval-mobile/#/inContract/constructionContract?id=577893569709883454&userid=303581417601122400");
		msg.setMsgtype("action_card");
		request.setMsg(msg);

		*/

		OapiMessageCorpconversationAsyncsendV2Response rsp = client.execute(request, "080dc9007c1635e781768fb23f0b0a3d");
		System.out.println(rsp.getBody());


//		ZonedDateTime now = ZonedDateTime.now();
//		// 定义日期时间格式化器
//		DateTimeFormatter formatter = DateTimeFormatter.ISO_INSTANT;
//		// 转换日期和时间为指定格式
//		String formattedDate = now.format(formatter);
//
//		System.out.println(formattedDate);
	}
}
