package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.ejianc.foundation.message.config.MessageConfiguration;
import com.ejianc.foundation.message.controller.param.SmsMessageParam;
import com.ejianc.foundation.message.service.ISmsService;
import com.ejianc.foundation.message.util.ProduceNumber;
import com.ejianc.foundation.message.util.Validate;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springside.modules.nosql.redis.JedisTemplate;

import java.util.Map;

@Service("zjhdSmsService")
public class ZjhdSmsServiceImpl implements ISmsService {
	private static final Logger logger = LoggerFactory.getLogger(ZjhdSmsServiceImpl.class);
	
	@Autowired
	private JedisTemplate jedis;
	@Autowired
	private MessageConfiguration messageConfiguration;
	
	@Override
	public CommonResponse<String> sendMessage(SmsMessageParam param) {
		logger.info("发送短信参数：{}", param.toString());
		try {
			if(StringUtils.isBlank(param.getTemplateCode())) {
				throw new BusinessException("短信模板编号不能为空！");
			}
			if(!Validate.isMobile(param.getPhone())) {
				throw new BusinessException("手机号不合法！");
			}

			DefaultProfile profile = DefaultProfile.getProfile(messageConfiguration.getRegionId(), messageConfiguration.getAccessKey(), messageConfiguration.getSecret());
	        IAcsClient client = new DefaultAcsClient(profile);
	        
	        CommonRequest commonRequest = new CommonRequest();
	        commonRequest.setSysMethod(MethodType.POST);
	        commonRequest.setSysDomain(messageConfiguration.getSysDomain());
	        commonRequest.setSysVersion(messageConfiguration.getSysVersion());
	        commonRequest.setSysAction(messageConfiguration.getSysAction());
	        commonRequest.putQueryParameter("RegionId", messageConfiguration.getRegionId());
	        commonRequest.putQueryParameter("PhoneNumbers", param.getPhone());
	        String signName = param.getSignName();
	        if(StringUtils.isNotBlank(signName)) {
	        	commonRequest.putQueryParameter("SignName", signName);
	        }else{
	        	commonRequest.putQueryParameter("SignName", "浙江火电");
	        }
	        commonRequest.putQueryParameter("TemplateCode", param.getTemplateCode());
	        
	        Map<String, String> templateParam = param.getParams();
			String rand = templateParam.get("code");
			boolean transCode = true;//外部传入code
			if(StringUtils.isEmpty(rand)){
				rand = ProduceNumber.produce();
				templateParam.put("code", rand);
				transCode = false;
			}
	        commonRequest.putQueryParameter("TemplateParam", JSON.toJSONString(templateParam));
	        try {
	            com.aliyuncs.CommonResponse response = client.getCommonResponse(commonRequest);
	            String result = response.getData();
	            if(StringUtils.isNotBlank(result)) {
	            	JSONObject resultJson = JSON.parseObject(result);
	            	if("OK".equals(resultJson.getString("Code"))) {
	            		if(!transCode){//外部传入code不缓存
							jedis.setex(param.getTemplateCode()+param.getPhone(), rand, 600);
						}
	            		return CommonResponse.success("短信发送成功");
	            	} else {
	            		String errorMsg = resultJson.getString("Message");
	            		return CommonResponse.error(errorMsg);
	            	}
	            }
	        } catch (ServerException e) {
	        	logger.error(e.getMessage());
	            e.printStackTrace();
	        } catch (ClientException e) {
	        	logger.error(e.getMessage());
	            e.printStackTrace();
	        }
		} catch(Exception e) {
			logger.error(e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("短信发送失败");
	}

}
