/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.bean.SocketMessageLogEntity;
import com.ejianc.foundation.message.service.ISocketMessageService;
import com.ejianc.foundation.message.vo.SocketMessageLogVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/socket/"})
public class SocketMessageController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISocketMessageService socketMessageService;
    @Autowired
    private SessionManager sessionManager;

    @PostMapping(value={"writeSocketMsg"})
    @ResponseBody
    CommonResponse<String> writeSocketMsgToDb(@RequestBody SocketMessageLogVO logVO) {
        SocketMessageLogEntity message = (SocketMessageLogEntity)((Object)BeanMapper.map((Object)logVO, SocketMessageLogEntity.class));
        this.socketMessageService.saveOrUpdate((Object)message);
        this.logger.info("\u4fdd\u5b58\u6d88\u606f\u6210\u529f\uff01socket\u6d88\u606f\u6301\u4e45\u5316\u6210\u529f\uff1a{}", (Object)JSON.toJSONString((Object)((Object)message)));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @GetMapping(value={"getSocketMsgLogList"})
    @ResponseBody
    CommonResponse<List<SocketMessageLogVO>> getSocketMsgLogList(@RequestParam(value="userId") Long userId, @RequestParam(value="sendTime", required=false) String sendTime) {
        List res = new ArrayList();
        QueryParam queryParam = new QueryParam();
        if (StringUtils.isNotBlank((CharSequence)sendTime)) {
            queryParam.getParams().put("sendTime", new Parameter("lt", (Object)sendTime));
        }
        queryParam.getParams().put("userId", Parameter.getEqInstance((Object)userId));
        queryParam.getParams().put("tenantId", Parameter.getEqInstance((Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("sendTime", "desc");
        queryParam.setLimit(Integer.valueOf(20));
        List list = this.socketMessageService.queryList(queryParam, false);
        if (list != null) {
            res = BeanMapper.mapList((Iterable)list, SocketMessageLogVO.class);
            res.forEach(item -> {
                if (item.getMsgType().equals("robot")) {
                    JSONObject content = JSONObject.parseObject((String)item.getContent());
                    content.put("msgState", (Object)item.getState());
                    item.setContent(JSONObject.toJSONString((Object)content));
                }
            });
        }
        return CommonResponse.success(res);
    }

    @PostMapping(value={"getTokensByUserId"})
    @ResponseBody
    public CommonResponse<List<String>> openApp(@RequestBody JSONObject parameter) {
        this.logger.info("\u83b7\u53d6\u7528\u6237token\uff1a{}", (Object)parameter.toJSONString());
        Map userSessions = this.sessionManager.getUserSessionMap(parameter.getLong("userId"));
        ArrayList res = new ArrayList(userSessions.keySet());
        return CommonResponse.success(res);
    }
}

