/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.bean.MessageEntity;
import com.ejianc.foundation.message.bean.MsgChannelEntity;
import com.ejianc.foundation.message.bean.MsgReceiverUnreadEntity;
import com.ejianc.foundation.message.dispatch.MessageSend;
import com.ejianc.foundation.message.service.IMessageSendService;
import com.ejianc.foundation.message.service.IMessageService;
import com.ejianc.foundation.message.service.IMsgChannelService;
import com.ejianc.foundation.message.service.IMsgReceiverUnreadService;
import com.ejianc.foundation.message.vo.MessageVO;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="messageSendService")
public class MessageSendServiceImpl
implements IMessageSendService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMessageService messageService;
    @Autowired
    private IMsgChannelService msgChannelService;
    @Autowired
    private IMsgReceiverUnreadService msgReceiverUnreadService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="#{${ejc.msg.channelImpl:null}}")
    private Map<String, String> channelImpl;

    @Override
    public void handMessage(String messageJson) {
        this.logger.info("\u5f85\u53d1\u9001\u6d88\u606f\uff1a\u3010{}\u3011", (Object)messageJson);
        PushMsgParameter msgParameter = (PushMsgParameter)JSONObject.parseObject((String)messageJson, PushMsgParameter.class);
        ArrayList<String> channelTypeList = new ArrayList<String>(Arrays.asList(msgParameter.getChannel()));
        List<MsgChannelEntity> channelList = this.msgChannelService.queryMsgSendConfig(msgParameter.getTenantId(), new ArrayList<String>(channelTypeList));
        this.logger.info("\u5f85\u53d1\u9001\u6d88\u606f\u6e20\u9053-{}", (Object)JSONObject.toJSONString(channelList));
        for (MsgChannelEntity channel : channelList) {
            try {
                if (!"sys".equals(channel.getType())) {
                    new MessageSend(msgParameter, channel, this.channelImpl).send();
                    continue;
                }
                CommonResponse userResponse = this.userApi.queryListByIdsTenantId(msgParameter.getReceivers(), Long.valueOf(Long.parseLong(msgParameter.getTenantId())));
                if (userResponse.isSuccess()) {
                    List userVos = (List)userResponse.getData();
                    if (userVos != null && userVos.size() > 0) {
                        Long tenantId = ((UserVO)userVos.get(0)).getTenantId();
                        MessageVO message = this.buildMessage(msgParameter);
                        message.setTenantId(tenantId);
                        MessageEntity messageEntity = (MessageEntity)((Object)BeanMapper.map((Object)message, MessageEntity.class));
                        this.messageService.saveOrUpdate((Object)messageEntity, false);
                        this.buildAndSaveReceivers(message, userVos);
                        continue;
                    }
                    this.logger.error("\u5411\u7528\u6237{}\u53d1\u9001\u7cfb\u7edf\u6d88\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u5339\u914d\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a", (Object[])msgParameter.getReceivers());
                    continue;
                }
                this.logger.error("\u5411\u7528\u6237{}\u53d1\u9001\u7cfb\u7edf\u6d88\u606f\u5f02\u5e38\uff0c\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25{}", (Object)msgParameter.getReceivers(), (Object)userResponse.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u901a\u8fc7\u6e20\u9053-{}\uff0c\u53d1\u9001\u6d88\u606f-\u3010{}\u3011\u5f02\u5e38\uff0c", new Object[]{JSONObject.toJSONString((Object)((Object)channel)), JSONObject.toJSONString((Object)msgParameter), e});
            }
        }
    }

    @Override
    public void sendUserMsg(PushMsgParameter parameter) {
        this.logger.info("\u5f85\u53d1\u9001\u6d88\u606f\uff1a\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)parameter));
        ArrayList<String> channelTypeList = new ArrayList<String>(Arrays.asList(parameter.getChannel()));
        List<MsgChannelEntity> channelList = this.msgChannelService.queryMsgSendConfig(parameter.getTenantId(), new ArrayList<String>(channelTypeList));
        MessageVO message = this.buildMessage(parameter);
        message.setTenantId(InvocationInfoProxy.getTenantid());
        if (parameter.isSaveFlag() || channelTypeList.contains("sys")) {
            JSONObject miniprogram;
            JSONObject weixinJson;
            CommonResponse resp;
            MessageEntity messageEntity = (MessageEntity)((Object)BeanMapper.map((Object)parameter, MessageEntity.class));
            messageEntity.setId(message.getId());
            this.messageService.saveOrUpdate((Object)messageEntity, false);
            if (CollectionUtils.isNotEmpty((Collection)parameter.getAttachIds()) && !(resp = this.attachmentApi.updateAttachRef(messageEntity.getId(), parameter.getAttachIds())).isSuccess()) {
                this.logger.error("\u9644\u4ef6\u3010ids-{}\u3011\u5bf9\u5e94\u6d88\u606f\u3010id-{}\u3011\u5173\u8054\u5173\u7cfb\u7ed1\u5b9a\u5931\u8d25, \u539f\u56e0\uff1a{}", new Object[]{JSONArray.toJSONString((Object)parameter.getAttachIds()), messageEntity.getId().toString(), resp.getMsg()});
            }
            if ((weixinJson = parameter.getWeixinParams()) != null && !weixinJson.isEmpty() && (miniprogram = weixinJson.getJSONObject("miniprogram")) != null && !miniprogram.isEmpty()) {
                String pagepath;
                String string = pagepath = null != miniprogram.get((Object)"pagepath") ? miniprogram.getString("pagepath") : null;
                if (StringUtils.isNotBlank((CharSequence)pagepath)) {
                    pagepath = pagepath.replaceAll("%7Bmid%7D", messageEntity.getId().toString()).replaceAll("%7bmid%7d", messageEntity.getId().toString()).replaceAll("\\{mid\\}", messageEntity.getId().toString());
                    miniprogram.put("pagepath", (Object)pagepath);
                }
            }
        }
        this.logger.info("\u5f85\u53d1\u9001\u6d88\u606f\u6e20\u9053-{}", (Object)JSONObject.toJSONString(channelList));
        for (MsgChannelEntity channel : channelList) {
            try {
                if (!"sys".equals(channel.getType())) {
                    new MessageSend(parameter, channel, this.channelImpl).send();
                    continue;
                }
                CommonResponse userResponse = this.userApi.queryListByIdsTenantId(parameter.getReceivers(), Long.valueOf(Long.parseLong(parameter.getTenantId())));
                if (userResponse.isSuccess()) {
                    List userVos = (List)userResponse.getData();
                    if (CollectionUtils.isNotEmpty((Collection)userVos)) {
                        this.buildAndSaveReceivers(message, userVos);
                        continue;
                    }
                    this.logger.error("\u5411\u7528\u6237{}\u53d1\u9001\u7cfb\u7edf\u6d88\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u5339\u914d\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a", (Object[])parameter.getReceivers());
                    continue;
                }
                this.logger.error("\u5411\u7528\u6237{}\u53d1\u9001\u7cfb\u7edf\u6d88\u606f\u5f02\u5e38\uff0c\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25{}", (Object)parameter.getReceivers(), (Object)userResponse.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u901a\u8fc7\u6e20\u9053-{}\uff0c\u53d1\u9001\u6d88\u606f-\u3010{}\u3011\u5f02\u5e38\uff0c", new Object[]{JSONObject.toJSONString((Object)((Object)channel)), JSONObject.toJSONString((Object)parameter), e});
            }
        }
    }

    private void buildAndSaveReceivers(MessageVO messageVO, List<UserVO> userVos) {
        ArrayList<MsgReceiverUnreadEntity> unReadList = new ArrayList<MsgReceiverUnreadEntity>();
        for (UserVO userVo : userVos) {
            if (messageVO.getTenantId().longValue() != userVo.getTenantId().longValue()) continue;
            MsgReceiverUnreadEntity e = new MsgReceiverUnreadEntity();
            e.setMessageId(messageVO.getId());
            e.setReceiverId(userVo.getId());
            e.setTenantId(messageVO.getTenantId());
            e.setCreateUserCode(messageVO.getCreateUserCode());
            unReadList.add(e);
        }
        if (CollectionUtils.isNotEmpty(unReadList)) {
            this.msgReceiverUnreadService.saveOrUpdateBatch(unReadList, unReadList.size(), false);
        }
    }

    private MessageVO buildMessage(PushMsgParameter msgParameter) {
        MessageVO messageVO = new MessageVO();
        messageVO.setId(Long.valueOf(IdWorker.getId()));
        messageVO.setContent(msgParameter.getContent());
        messageVO.setMobileContent(msgParameter.getMobileContent());
        messageVO.setSubject(msgParameter.getSubject());
        messageVO.setMsgType(msgParameter.getMsgType());
        messageVO.setPcUrl(msgParameter.getPcUrl());
        messageVO.setMobileUrl(msgParameter.getMobileUrl());
        messageVO.setSendUserId(msgParameter.getSendUserId());
        messageVO.setTenantId(Long.valueOf(msgParameter.getTenantId()));
        messageVO.setCreateUserCode(StringUtils.isNotBlank((CharSequence)InvocationInfoProxy.getUsercode()) ? InvocationInfoProxy.getUsercode() : null);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        messageVO.setSendTime(dateFormat.format(new Date()));
        return messageVO;
    }

    public static void main(String[] args) {
        Long a = Long.parseLong("1316333384232796162");
        Long b = Long.parseLong("1316333384232796162");
        System.out.println(a.equals(b));
    }
}

