/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.ejianc.foundation.message.config.MessageConfiguration;
import com.ejianc.foundation.message.controller.param.SmsMessageParam;
import com.ejianc.foundation.message.service.ISmsService;
import com.ejianc.foundation.message.util.ProduceNumber;
import com.ejianc.foundation.message.util.Validate;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springside.modules.nosql.redis.JedisTemplate;

@Service
public class SmsServiceImpl
implements ISmsService {
    private static final Logger logger = LoggerFactory.getLogger(SmsServiceImpl.class);
    @Autowired
    private JedisTemplate jedis;
    @Autowired
    private MessageConfiguration messageConfiguration;

    @Override
    public com.ejianc.framework.core.response.CommonResponse<String> sendMessage(SmsMessageParam param) {
        logger.info("\u53d1\u9001\u77ed\u4fe1\u53c2\u6570\uff1a{}", (Object)param.toString());
        try {
            if (StringUtils.isBlank((CharSequence)param.getTemplateCode())) {
                throw new BusinessException("\u77ed\u4fe1\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!Validate.isMobile(param.getPhone())) {
                throw new BusinessException("\u624b\u673a\u53f7\u4e0d\u5408\u6cd5\uff01");
            }
            DefaultProfile profile = DefaultProfile.getProfile((String)this.messageConfiguration.getRegionId(), (String)this.messageConfiguration.getAccessKey(), (String)this.messageConfiguration.getSecret());
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            CommonRequest commonRequest = new CommonRequest();
            commonRequest.setSysMethod(MethodType.POST);
            commonRequest.setSysDomain(this.messageConfiguration.getSysDomain());
            commonRequest.setSysVersion(this.messageConfiguration.getSysVersion());
            commonRequest.setSysAction(this.messageConfiguration.getSysAction());
            commonRequest.putQueryParameter("RegionId", this.messageConfiguration.getRegionId());
            commonRequest.putQueryParameter("PhoneNumbers", param.getPhone());
            String signName = param.getSignName();
            if (StringUtils.isNotBlank((CharSequence)signName)) {
                commonRequest.putQueryParameter("SignName", signName);
            } else {
                commonRequest.putQueryParameter("SignName", "\u76ca\u4f01\u5de5\u7a0b\u4e91");
            }
            commonRequest.putQueryParameter("TemplateCode", param.getTemplateCode());
            Map<String, String> templateParam = param.getParams();
            String rand = templateParam.get("code");
            boolean transCode = true;
            if (StringUtils.isEmpty((CharSequence)rand)) {
                rand = ProduceNumber.produce();
                templateParam.put("code", rand);
                transCode = false;
            }
            commonRequest.putQueryParameter("TemplateParam", JSON.toJSONString(templateParam));
            try {
                CommonResponse response = client.getCommonResponse(commonRequest);
                String result = response.getData();
                if (StringUtils.isNotBlank((CharSequence)result)) {
                    JSONObject resultJson = JSON.parseObject((String)result);
                    if ("OK".equals(resultJson.getString("Code"))) {
                        if (!transCode) {
                            this.jedis.setex(param.getTemplateCode() + param.getPhone(), rand, 600);
                        }
                        return com.ejianc.framework.core.response.CommonResponse.success((String)"\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
                    }
                    String errorMsg = resultJson.getString("Message");
                    return com.ejianc.framework.core.response.CommonResponse.error((String)errorMsg);
                }
            }
            catch (ServerException e) {
                logger.error(e.getMessage());
                e.printStackTrace();
            }
            catch (ClientException e) {
                logger.error(e.getMessage());
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        return com.ejianc.framework.core.response.CommonResponse.error((String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
    }
}

