package com.ejianc.foundation.message.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 *
 * socket消息日志
 *
 */
@TableName("ejc_socket_message_log")
public class SocketMessageLogEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
	 * 消息内容
	 * 机器人消息是json格式，用户消息是纯文本
	 */
	@TableField(value = "content")
	private String content;

	/**
	 * 消息类型：robot or user
	 * robot:机器人发送的消息，user:用户回复的消息
	 */
	@TableField(value = "msg_type")
	private String msgType;

	/**
	 * 发送时间
	 */
	@TableField(value = "send_time")
	private String sendTime;

	/**
	 * 消息状态：1:未处理，2:已处理
	 */
	@TableField(value = "state")
	private String state;

	/**
	 * 用户id，会话是哪个用户的历史记录
	 */
	@TableField(value = "user_id")
	private Long userId;

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getMsgType() {
		return msgType;
	}

	public void setMsgType(String msgType) {
		this.msgType = msgType;
	}

	public String getSendTime() {
		return sendTime;
	}

	public void setSendTime(String sendTime) {
		this.sendTime = sendTime;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}
}
